/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import java.io.File;
import java.io.IOException;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class DomainDirectoryReorgPlugIn
extends AbstractPlugIn {
    private File upgradeDir;
    private File upgradeAbsDir;
    private File parentDir;
    private String upgradeDirPath;
    private DomainMBean domainBean;
    private String[] serverNames;

    public DomainDirectoryReorgPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryReorgPlugIn.exc.NoDomainDir");
        }
        try {
            this.upgradeAbsDir = this.upgradeDir.getCanonicalFile();
            this.parentDir = this.upgradeAbsDir.getParentFile();
            this.upgradeDirPath = this.upgradeDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("DomainDirectoryReorgPlugIn.msg.InExecuteMethod");
        this.createDomainConfigDirs();
        this.createServerConfigDirs();
        this.updateStatus("DomainDirectoryReorgPlugIn.msg.OutExecuteMethod");
    }

    private void createDomainConfigDirs() {
        this.updateStatus("DomainDirectoryReorgPlugIn.msg.BeginCreateDomainDirectories", this.domainBean.getName());
        this.createDirectory(DomainDir.getBinDir());
        this.createDirectory(DomainDir.getConfigDir());
        this.createDirectory(DomainDir.getPathRelativeRootDir((String)"console-ext"));
        this.createDirectory(DomainDir.getLibDir());
        this.createDirectory(DomainDir.getPendingDir());
        this.createDirectory(DomainDir.getSecurityDir());
        this.createDirectory(DomainDir.getServersDir());
        this.createDirectory(DomainDir.getDeploymentsDir());
        this.createDirectory(DomainDir.getDiagnosticsDir());
        this.createDirectory(DomainDir.getJDBCDir());
        this.createDirectory(DomainDir.getJMSDir());
        this.createDirectory(DomainDir.getConfigSecurityDir());
        this.createDirectory(DomainDir.getConfigStartupDir());
        this.createDirectory(DomainDir.getLibModulesDir());
        this.updateStatus("DomainDirectoryReorgPlugIn.msg.EndCreateDomainDirectories", this.domainBean.getName());
    }

    private void createServerConfigDirs() {
        for (int i = 0; i < this.serverNames.length; ++i) {
            String string = this.serverNames[i];
            this.updateStatus("DomainDirectoryReorgPlugIn.msg.BeginCreateServerDirectories", string);
            this.createDirectory(DomainDir.getDirForServer((String)string));
            this.createDirectory(DomainDir.getBinDirForServer((String)string));
            this.createDirectory(DomainDir.getCacheDirForServer((String)string));
            this.createDirectory(DomainDir.getDataDirForServer((String)string));
            this.createDirectory(DomainDir.getLogsDirForServer((String)string));
            this.createDirectory(DomainDir.getSecurityDirForServer((String)string));
            this.createDirectory(DomainDir.getTempDirForServer((String)string));
            this.createDirectory(DomainDir.getLDAPDataDirForServer((String)string));
            this.createDirectory(DomainDir.getStoreDataDirForServer((String)string));
            this.updateStatus("DomainDirectoryReorgPlugIn.msg.EndCreateServerDirectories", string);
        }
    }

    private void createDirectory(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (!file.exists()) {
            file.mkdirs();
            this.updateStatus("DomainDirectoryReorgPlugIn.msg.CreatedDirectory", string2);
        } else {
            this.updateStatus("DomainDirectoryReorgPlugIn.msg.DirectoryAlreadyExists", string2);
        }
    }

    private void updateStatus(String string) {
        this.log(UpgradeHelper.i18n(string));
    }

    private void updateStatus(String string, Object object) {
        this.log(UpgradeHelper.i18n(string, object));
    }

    private PlugInException createException(String string) {
        String string2 = UpgradeHelper.i18n(string);
        this.log(string2);
        return new PlugInException(this.getName(), string2);
    }

    private PlugInException createException(String string, Object object) {
        String string2 = UpgradeHelper.i18n(string, object);
        this.log(string2);
        return new PlugInException(this.getName(), string2);
    }

    private PlugInException createException(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuffer.append(": ");
            stringBuffer.append(throwable2.toString());
        }
        String string2 = UpgradeHelper.i18n(string, stringBuffer.toString());
        this.log(string2);
        return new PlugInException(this.getName(), string2);
    }

    private void log(String string) {
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), string + ""));
    }
}

