/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryrestructure.BaseFileRestructurePlugin;
import weblogic.utils.FileUtils;

public class MoveBinFilesPlugin
extends BaseFileRestructurePlugin {
    private File upgradeDir;
    private File upgradeAbsDir;
    private String upgradeDirPath;
    private DomainMBean domainBean;
    private String[] serverNames;

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Prepare Exception", (Throwable)exception);
        }
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoDomainDir");
        }
        try {
            this.upgradeAbsDir = this.upgradeDir.getCanonicalFile();
            this.upgradeDirPath = this.upgradeDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.InExecuteMethod", "BinFiles");
        FileFilter fileFilter = FileUtils.makeExtensionFilter((String)"cmd");
        FileFilter fileFilter2 = FileUtils.makeExtensionFilter((String)"sh");
        File[] fileArray = FileUtils.find((File)this.upgradeDir, (FileFilter)fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = new File(DomainDir.getPathRelativeBinDir((String)fileArray[i].getName()));
            this.moveFile(fileArray[i], file);
        }
        File[] fileArray2 = FileUtils.find((File)this.upgradeDir, (FileFilter)fileFilter2);
        for (int i = 0; i < fileArray2.length; ++i) {
            File file = new File(DomainDir.getPathRelativeBinDir((String)fileArray2[i].getName()));
            this.moveFile(fileArray2[i], file);
        }
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.OutExecuteMethod", "BinFiles");
    }

    private void moveFile(File file, File file2) {
        try {
            FileUtils.copy((File)file, (File)file2);
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.BinFileMoveSucceeded", file2);
        }
        catch (IOException iOException) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.IOException", iOException.getMessage());
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.BinFileMoveFailed", file);
        }
    }
}

