/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryrestructure.BaseFileRestructurePlugin;
import weblogic.utils.FileUtils;
import weblogic.utils.io.GlobFilenameFilter;

public class MoveConfigurationFilesPlugin
extends BaseFileRestructurePlugin {
    private static final String CONFIG_FILE = "config.xml";
    private static final String CONFIG_FILE_ORIGINAL = "config.xml.original";
    private static final String CONFIG_FILE_BOOTED = "config.xml.booted";
    private static final String CONFIG_FILE_MSI = "msi-config.xml";
    private static final String CONFIG_ARCHIVE_DIRECTORY_NAME = "configArchive";
    private static final String USER_CONFIG_DIRECTORY_NAME = "userConfig";
    private static final String RUNNING_MANAGED_SERVERS_FILE = "running-managed-servers.xml";
    private static final String COMMO_CONFIG_XML_BOOTED = "CommoConfig.xml.booted";
    private File upgradeDir;
    private String upgradeDirPath;
    private DomainMBean domainBean;
    private String[] serverNames;

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Prepare Exception", (Throwable)exception);
        }
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoDomainDir");
        }
        String string = (String)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_VERSION_KEY);
        if (string.startsWith("6.1")) {
            this.upgradeDir = new File(this.upgradeDir, "config");
            this.upgradeDir = new File(this.upgradeDir, this.domainBean.getName());
        }
        try {
            this.upgradeDirPath = this.upgradeDir.getCanonicalFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        File file;
        File file2;
        File file3;
        File file4;
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.InExecuteMethod", "ConfigFiles");
        String string = BootStrap.getConfigFileName();
        File file5 = new File(this.upgradeDirPath + File.separator + string);
        if (file5.exists()) {
            this.deleteFile(file5);
        }
        GlobFilenameFilter globFilenameFilter = new GlobFilenameFilter("config.xml*");
        File[] fileArray = this.upgradeDir.listFiles((FilenameFilter)globFilenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().equals(CONFIG_FILE_ORIGINAL) && !fileArray[i].getName().equals(CONFIG_FILE_BOOTED)) continue;
            this.deleteFile(fileArray[i]);
        }
        File file6 = new File(this.upgradeDirPath + File.separator + CONFIG_ARCHIVE_DIRECTORY_NAME);
        if (file6.exists()) {
            this.deleteFile(file6);
        }
        if ((file4 = new File(this.upgradeDirPath + File.separator + RUNNING_MANAGED_SERVERS_FILE)).exists()) {
            this.deleteFile(file4);
        }
        if ((file3 = new File(this.upgradeDirPath + File.separator + CONFIG_FILE_MSI)).exists()) {
            this.deleteFile(file3);
        }
        if ((file2 = new File(this.upgradeDirPath + File.separator + USER_CONFIG_DIRECTORY_NAME)).exists()) {
            this.deleteFile(file2);
        }
        if ((file = new File(this.upgradeDirPath + File.separator + COMMO_CONFIG_XML_BOOTED)).exists()) {
            this.deleteFile(file);
        }
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.OutExecuteMethod", "ConfigFiles");
    }

    private void deleteFile(File file) {
        FileUtils.remove((File)file);
        if (!file.exists()) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.ConfigFileDeleteSucceeded", file);
        } else {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.ConfigFileDeleteFailed", file);
        }
    }
}

