/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import java.io.IOException;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryrestructure.BaseFileRestructurePlugin;
import weblogic.utils.FileUtils;

public class MoveDeploymentFilesPlugin
extends BaseFileRestructurePlugin {
    private File upgradeDir;
    private File upgradeAbsDir;
    private String upgradeDirPath;
    private DomainMBean domainBean;
    private String[] serverNames;

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Prepare Exception", (Throwable)exception);
        }
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoDomainDir");
        }
        try {
            this.upgradeAbsDir = this.upgradeDir.getCanonicalFile();
            this.upgradeDirPath = this.upgradeDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.InExecuteMethod", "DeploymentFiles");
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.OutExecuteMethod", "DeploymentFiles");
    }

    private void deleteFile(File file) {
        FileUtils.remove((File)file);
        if (!file.exists()) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.DeploymentFileDeleteSucceeded", file);
        } else {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.DeploymentFileDeleteFailed", file);
        }
    }

    private void moveFile(File file, File file2) {
        try {
            FileUtils.copy((File)file, (File)file2);
            file.delete();
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.DeploymentFileMoveSucceeded", file2);
        }
        catch (IOException iOException) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.IOException", iOException.getMessage());
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.DeploymentFileMoveFailed", file);
        }
    }
}

