/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import weblogic.logging.WeblogicLogfileFilter;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryrestructure.BaseFileRestructurePlugin;
import weblogic.utils.FileUtils;

public class MoveLogFilesPlugin
extends BaseFileRestructurePlugin {
    private static final String SAVED_LOGS_DIR = "pre-90-logs";
    private File upgradeDir;
    private File upgradeAbsDir;
    private String upgradeDirPath;
    private DomainMBean domainBean;
    private String[] serverNames;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Prepare Exception", (Throwable)exception);
        }
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoDomainDir");
        }
        try {
            this.upgradeAbsDir = this.upgradeDir.getCanonicalFile();
            this.upgradeDirPath = this.upgradeDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.InExecuteMethod", "LogFile");
        this.moveDomainLogs();
        this.moveServerLogs();
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.OutExecuteMethod", "LogFile");
    }

    private void moveDomainLogs() {
        boolean bl = false;
        boolean bl2 = false;
        LogMBean logMBean = this.domainBean.getLog();
        File file = new File(logMBean.getFileName());
        String string = file.getName();
        if (logMBean.isSet("FileName")) {
            bl = true;
        }
        if (file.isAbsolute()) {
            bl2 = true;
        }
        File file2 = null;
        file2 = !bl2 ? new File(this.upgradeAbsDir, string) : file;
        if (file2.exists()) {
            if (ManagementService.getPropertyService(kernelId).isAdminServer()) {
                String string2 = ManagementService.getPropertyService(kernelId).getServerName();
                this.saveOldLogs(bl2, file2, string2);
            } else {
                this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.DomainLogFileNotProcessedOnMS", file2);
            }
        } else {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.LogFileNotInDefaultLocation", file2);
        }
    }

    private void moveServerLogs() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.serverNames.length; ++i) {
            String string = this.serverNames[i];
            ServerMBean serverMBean = this.domainBean.lookupServer(string);
            LogMBean logMBean = serverMBean.getLog();
            File file = new File(logMBean.getFileName());
            String string2 = file.getName();
            bl = logMBean.isSet("FileName");
            bl2 = file.isAbsolute();
            File file2 = new File(this.upgradeAbsDir, string);
            File file3 = new File(this.upgradeAbsDir, string + File.separator + string2);
            if (file3.exists()) {
                this.saveOldLogs(bl2, file3, string);
                continue;
            }
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.LogFileNotInDefaultLocation", file3);
        }
    }

    private void saveOldLogs(boolean bl, File file, String string) {
        File file2 = null;
        file2 = !bl ? new File(DomainDir.getPathRelativeServersLogsDir((String)string, (String)SAVED_LOGS_DIR)) : new File(file.getParentFile(), SAVED_LOGS_DIR);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.moveFile(file, file2);
        File[] fileArray = this.getExistingRotatedLogFiles(file.getParentFile(), file.getName());
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.moveFile(fileArray[i], file2);
        }
    }

    private File[] getExistingRotatedLogFiles(File file, String string) {
        File[] fileArray = file.listFiles(new WeblogicLogfileFilter(new File(string)));
        return fileArray;
    }

    private void moveFile(File file, File file2) {
        String[] stringArray = new String[2];
        try {
            stringArray[0] = file.getCanonicalPath();
            stringArray[1] = file2.getCanonicalPath();
            FileUtils.copy((File)file, (File)file2);
            file.delete();
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.LogFileMoveSucceeded", stringArray);
        }
        catch (IOException iOException) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.IOException", iOException.getMessage());
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.LogFileMoveFailed", stringArray);
        }
    }
}

