/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryrestructure.BaseFileRestructurePlugin;
import weblogic.utils.FileUtils;

public class MoveSecurityFilesPlugin
extends BaseFileRestructurePlugin {
    private File upgradeDir;
    private File upgradeAbsDir;
    private String upgradeDirPath;
    private DomainMBean domainBean;
    private String[] serverNames;
    private DefaultAuditLogFilenameFilter auditFilter;
    private static final String EMBEDDED_LDAP_DIR_NAME = "ldap";
    private static final String EMBEDDED_LDAP_CONF_DIR_NAME = "conf";
    private static final String EMBEDDED_LDAP_REPLICAS_NAME = "replicas.prop";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Prepare Exception", (Throwable)exception);
        }
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoDomainDir");
        }
        try {
            this.upgradeAbsDir = this.upgradeDir.getCanonicalFile();
            this.upgradeDirPath = this.upgradeDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.InExecuteMethod", "SecurityFiles");
        this.moveDomainLevelFile("SerializedSystemIni.dat");
        this.moveLDIFTFiles();
        File file = new File(this.upgradeAbsDir.getAbsolutePath() + File.separator + "boot.properties");
        boolean bl = file.exists();
        String string = ManagementService.getPropertyService(kernelId).getServerName();
        for (int i = 0; i < this.serverNames.length; ++i) {
            String string2 = this.serverNames[i];
            ServerMBean serverMBean = this.domainBean.lookupServer(string2);
            if (bl && string2.equals(string)) {
                File file2 = new File(DomainDir.getPathRelativeServersSecurityDir((String)string2, (String)"boot.properties"));
                this.copyFile(file, file2);
            }
            this.moveAuditLogs(string2);
            this.moveLDAPTree(string2);
        }
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.OutExecuteMethod", "SecurityFiles");
    }

    private void moveDomainLevelFile(String string) {
        File file = new File(this.upgradeDirPath + File.separator + string);
        if (file.exists()) {
            File file2 = new File(DomainDir.getPathRelativeSecurityDir((String)string));
            this.moveFile(file, file2);
        }
    }

    private void moveDomainLevelFile(File file) {
        if (file.exists()) {
            File file2 = new File(DomainDir.getPathRelativeSecurityDir((String)file.getName()));
            this.moveFile(file, file2);
        }
    }

    private void moveLDIFTFiles() {
        DefaultLDIFTFilenameFilter defaultLDIFTFilenameFilter;
        File file = new File(this.upgradeAbsDir.getAbsolutePath());
        File[] fileArray = file.listFiles(defaultLDIFTFilenameFilter = new DefaultLDIFTFilenameFilter(file));
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file2 = new File(DomainDir.getSecurityDir());
        for (int i = 0; i < fileArray.length; ++i) {
            this.moveDomainLevelFile(fileArray[i]);
        }
    }

    private void moveAuditLogs(String string) {
        File file = new File(this.upgradeAbsDir.getAbsolutePath() + File.separator + string);
        this.auditFilter = new DefaultAuditLogFilenameFilter(file);
        File[] fileArray = file.listFiles(this.auditFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file2 = new File(DomainDir.getLogsDirForServer((String)string));
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = new File(DomainDir.getPathRelativeServersLogsDir((String)string, (String)fileArray[i].getName()));
            this.moveFile(fileArray[i], file3);
        }
    }

    private void moveLDAPTree(String string) {
        String string2 = this.upgradeDirPath + File.separator + string + File.separator + EMBEDDED_LDAP_DIR_NAME;
        File file = new File(string2);
        if (!file.exists()) {
            return;
        }
        this.moveFile(file, new File(DomainDir.getLDAPDataDirForServer((String)string)));
        String string3 = EMBEDDED_LDAP_CONF_DIR_NAME + File.separator + EMBEDDED_LDAP_REPLICAS_NAME;
        File file2 = new File(DomainDir.getPathRelativeServersLDAPDataDir((String)string, (String)string3));
        if (file2.exists()) {
            this.deleteFile(file2);
        }
    }

    private void deleteFile(File file) {
        if (file.canWrite()) {
            FileUtils.remove((File)file);
        }
        if (!file.exists()) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.SecurityFileDeleteSucceeded", file);
        } else {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.SecurityFileDeleteFailed", file);
        }
    }

    private void copyFile(File file, File file2) {
        String[] stringArray = new String[2];
        try {
            stringArray[0] = file.getCanonicalPath();
            stringArray[1] = file2.getCanonicalPath();
            FileUtils.copy((File)file, (File)file2);
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.SecurityFileCopySucceeded", stringArray);
        }
        catch (IOException iOException) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.IOException", iOException.getMessage());
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.SecurityFileCopyFailed", stringArray);
        }
    }

    private void moveFile(File file, File file2) {
        String[] stringArray = new String[2];
        try {
            stringArray[0] = file.getCanonicalPath();
            stringArray[1] = file2.getCanonicalPath();
            FileUtils.copy((File)file, (File)file2);
            if (file.canWrite()) {
                FileUtils.remove((File)file);
            }
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.SecurityFileMoveSucceeded", stringArray);
        }
        catch (IOException iOException) {
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.IOException", iOException.getMessage());
            this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.SecurityFileMoveFailed", stringArray);
        }
    }

    private static class DefaultLDIFTFilenameFilter
    implements FilenameFilter {
        String absPath = null;

        public DefaultLDIFTFilenameFilter(File file) {
            try {
                this.absPath = file.getAbsolutePath();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public boolean accept(File file, String string) {
            if (file == null || this.absPath == null || string == null || string.length() == 0) {
                return false;
            }
            try {
                if (!this.absPath.equals(file.getAbsolutePath())) {
                    return false;
                }
            }
            catch (SecurityException securityException) {
                return false;
            }
            return string.endsWith("Init.ldift");
        }
    }

    private static class DefaultAuditLogFilenameFilter
    implements FilenameFilter {
        String absPath = null;

        public DefaultAuditLogFilenameFilter(File file) {
            try {
                this.absPath = file.getAbsolutePath();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public boolean accept(File file, String string) {
            if (file == null || this.absPath == null || string == null || string.length() == 0) {
                return false;
            }
            try {
                if (!this.absPath.equals(file.getAbsolutePath())) {
                    return false;
                }
            }
            catch (SecurityException securityException) {
                return false;
            }
            return string.startsWith("DefaultAuditRecorder") && string.endsWith(".log");
        }
    }
}

