/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryselection;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.helper.ProductRegistryHelper;
import com.bea.plateng.plugin.ia.DefaultFileSelectionInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import com.oracle.cie.common.Version;
import com.oracle.cie.domain.DomainTypeDetector;
import com.oracle.cie.domain.PlatformDomainInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.internal.ServerLocks;
import weblogic.management.provider.internal.DescriptorManagerHelper;
import weblogic.management.provider.internal.DescriptorManagerHelperContext;
import weblogic.management.upgrade.ConfigFileHelper;
import weblogic.management.upgrade.ConfigParser;
import weblogic.management.upgrade.LogHandler;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryselection.VersionException;
import weblogic.utils.FileUtils;

public class DomainDirectorySelectionPlugIn
extends AbstractPlugIn
implements LogHandler {
    private static String SERVER_LOCKS_INSTALLED_KEY = DomainDirectorySelectionPlugIn.class.getName() + ".SERVER_LOCKS_INSTALLED_KEY";

    public DomainDirectorySelectionPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        this.preselectDir();
    }

    private void preselectDir() {
        Object object;
        File file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (file == null) {
            object = null;
            String string = (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_VERSION_KEY);
            if (string == null || !string.startsWith("6.1")) {
                object = DomainDir.getRootDir();
            }
            if (object == null) {
                object = ".";
            }
            file = new File((String)object);
        }
        object = (DefaultFileSelectionInputAdapter)this._adapter;
        object.setSelectionMode(1);
        object.setMultipleSelection(false);
        object.setSelectedFileNames(new String[]{file.getPath()});
    }

    public InputAdapter getInputAdapter() {
        this.preselectDir();
        return super.getInputAdapter();
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        String string = (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_VERSION_KEY);
        DefaultFileSelectionInputAdapter defaultFileSelectionInputAdapter = (DefaultFileSelectionInputAdapter)this._adapter;
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        File[] fileArray = defaultFileSelectionInputAdapter.getSelectedFiles();
        File file = fileArray[0];
        if (validationStatus.isValid()) {
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.config.invalid.text"));
                validationStatus.setValid(false);
            }
        }
        if (validationStatus.isValid()) {
            String string2 = BootStrap.getConfigFileName();
            if (string.startsWith("6.1")) {
                File file2 = new File(file, "config");
                File file3 = null;
                File[] fileArray2 = file2.listFiles();
                int n = 0;
                if (fileArray2 != null && fileArray2.length >= 1) {
                    File file4 = null;
                    for (int i = 0; i < fileArray2.length; ++i) {
                        if (!fileArray2[i].isDirectory() || !(file4 = new File(fileArray2[i], string2)).exists()) continue;
                        file3 = file4;
                        ++n;
                    }
                }
                if (n == 1 && file3 != null) {
                    this._context.put((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY, (Object)file);
                    this._context.put((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_SOURCE_FILE, file3);
                } else {
                    validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.domain.invalid.61.text"));
                    validationStatus.setValid(false);
                }
            } else {
                File file5 = new File(file, string2);
                File file6 = new File(file, "msi-config.xml");
                File file7 = new File(file, "config/" + string2);
                if (file7.exists()) {
                    int n = 0;
                    try {
                        n = ConfigFileHelper.getConfigurationVersionFromNewFormat(file7);
                    }
                    catch (Exception exception) {
                        validationStatus.setErrorMessage(exception.toString());
                    }
                    if (n == 0) {
                        validationStatus.setValid(false);
                    } else {
                        this._context.put((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY, (Object)file);
                        this._context.put((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_SOURCE_FILE, (Object)file7);
                        this.validatePlatformDomain(validationStatus, file);
                    }
                } else if (file5.exists()) {
                    this._context.put((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY, (Object)file);
                    this._context.put((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_SOURCE_FILE, (Object)file5);
                    this.validatePlatformDomain(validationStatus, file);
                } else if (file6.exists()) {
                    this._context.put((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY, (Object)file);
                    this._context.put((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_SOURCE_FILE, (Object)file6);
                } else {
                    validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.config.invalid.text"));
                    validationStatus.setValid(false);
                }
            }
        }
        if (validationStatus.isValid()) {
            this._context.put((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_SELECTION_DATE_KEY, (Object)new Date());
        }
        return validationStatus;
    }

    public void execute() throws PlugInException {
        try {
            Object object;
            String string = (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_VERSION_KEY);
            File file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
            UpgradeHelper.log(this, UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.execute.directory_selected", file.getAbsolutePath()));
            DomainDir.resetRootDirForExplicitUpgrade((String)file.getAbsolutePath());
            UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.execute.directory_selected", file.getAbsolutePath()));
            if (this._context.get((Object)SERVER_LOCKS_INSTALLED_KEY) != null) {
                ServerLocks.releaseAllServerLocks();
            }
            ServerLocks.getAllServerLocks();
            ServerLocks.releaseAllServerLocks();
            this._context.put((Object)SERVER_LOCKS_INSTALLED_KEY, (Object)file);
            File file2 = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_SOURCE_FILE);
            DomainMBean domainMBean = null;
            if (string.startsWith("6.1")) {
                FileUtils.copy((File)new File(file2.getParentFile(), "SerializedSystemIni.dat"), (File)file);
                FileUtils.copy((File)new File(file2.getParentFile(), "fileRealm.properties"), (File)file);
            }
            if (!(string.startsWith("6.") || string.startsWith("7.") || string.startsWith("8."))) {
                domainMBean = this.parseNewStyleConfig(file2);
            } else {
                object = new ConfigParser(file2, this);
                ((ConfigParser)object).parse(true);
                domainMBean = ((ConfigParser)object).getRoot();
                if (string.startsWith("6.1") && domainMBean.getName() == null) {
                    domainMBean.setName(file2.getParentFile().getName());
                }
            }
            object = domainMBean.getConfigurationVersion();
            UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.execute.original_version_message") + (String)object);
            this._context.put((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY, (Object)domainMBean);
            UpgradeHelper.resetLocalServerNames(this, this._context);
            String string2 = UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.execute.message.text", object);
            UpgradeHelper.log(this, string2);
            if (DomainDirectorySelectionPlugIn.isWindowsPlatform() && file.getAbsolutePath().length() > 50) {
                UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.execute.windows_file_length_message"));
            }
        }
        catch (ManagementException managementException) {
            if (managementException.getCause() != null && managementException.getCause() instanceof VersionException) {
                UpgradeHelper.log(this, managementException.getCause().getMessage());
                throw new PlugInException(this.getName(), managementException.getCause().getMessage());
            }
            throw new PlugInException(this.getName(), "Execute Exception ... " + managementException.toString(), (Throwable)managementException);
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Execute Exception ... " + exception.toString(), (Throwable)exception);
        }
    }

    public void undo() {
        this._context.remove((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
    }

    private static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Windows");
    }

    public void log(String string) {
        UpgradeHelper.log(this, string);
    }

    private void validatePlatformDomain(ValidationStatus validationStatus, File file) {
        Version version2;
        PlatformDomainInfo platformDomainInfo = null;
        ProductRegistryHelper productRegistryHelper = null;
        try {
            platformDomainInfo = DomainTypeDetector.inspectDomain((File)file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("" + this.getClass().getName() + ".validatePlatformDomain: " + "Failed to get Platform domain info." + fileNotFoundException.getMessage());
        }
        this._context.put((Object)DomainPlugInConstants.PLATFORM_DOMAIN_INFO_KEY, (Object)platformDomainInfo);
        productRegistryHelper = ProductRegistryHelper.factory();
        if (productRegistryHelper == null) {
            System.out.println("" + this.getClass().getName() + ".validatePlatformDomain: " + "Failed to get info on installed products from product registry");
        }
        this._context.put((Object)DomainPlugInConstants.PRODUCT_REGISTRY_INFO_KEY, (Object)productRegistryHelper);
        if (productRegistryHelper == null || platformDomainInfo == null || platformDomainInfo.isPureWLS()) {
            return;
        }
        boolean bl = Boolean.valueOf(System.getProperty("weblogic.upgrade.domain.directoryselection.DomainDirectorySelectionPlugIn.disable_platform_domain_validation", "true"));
        if (bl) {
            System.out.println("" + this.getClass().getName() + ".validatePlatformDomain: " + "Property set to skip platform domain validation. Skipping...");
            return;
        }
        String string = platformDomainInfo.getDomainVersion();
        if (string != null && string != "" && (version2 = new Version(string)).isEarlier(new Version("8.1.2.0"))) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.config.invalid.version.text"));
            validationStatus.setValid(false);
            return;
        }
        if (platformDomainInfo.isLD()) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.ld_unavailable.text"));
            validationStatus.setValid(false);
            return;
        }
        if (platformDomainInfo.isWLP() && !productRegistryHelper.isWebLogicPortalInstalled()) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.cant_upgrade_wlp_domain.text"));
            validationStatus.setValid(false);
            return;
        }
        if (platformDomainInfo.isWLI() && !productRegistryHelper.isWebLogicIntegrationInstalled()) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.cant_upgrade_wli_domain.text"));
            validationStatus.setValid(false);
            return;
        }
        if (platformDomainInfo.isLD() && !productRegistryHelper.isAquaLogicDataServicesPlatformInstalled()) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectorySelectionPlugIn.FileSelectionIA.cant_upgrade_ld_domain.text"));
            validationStatus.setValid(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainMBean parseNewStyleConfig(File file) throws Exception {
        ArrayList arrayList = new ArrayList();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            DescriptorManagerHelperContext descriptorManagerHelperContext = new DescriptorManagerHelperContext();
            descriptorManagerHelperContext.setEditable(true);
            descriptorManagerHelperContext.setValidate(true);
            descriptorManagerHelperContext.setTransform(true);
            descriptorManagerHelperContext.setErrors(arrayList);
            DomainMBean domainMBean = (DomainMBean)DescriptorManagerHelper.loadDescriptor(fileInputStream, descriptorManagerHelperContext).getRootBean();
            if (arrayList.size() > 0) {
                for (Object e : arrayList) {
                    if (e instanceof Exception) {
                        UpgradeHelper.log(this, ((Exception)e).getMessage());
                        continue;
                    }
                    UpgradeHelper.log(this, e.toString());
                }
                throw new PlugInException(this.getName(), "Validation errors occurred in parsing " + file);
            }
            DomainMBean domainMBean2 = domainMBean;
            return domainMBean2;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

