/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryselection;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.Choice;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.plugin.ia.DefaultCompositeInputAdapter;
import com.bea.plateng.plugin.ia.DefaultTextInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class DomainInfoVerificationPlugIn
extends AbstractPlugIn {
    public DomainInfoVerificationPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)this._adapter;
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)defaultCompositeInputAdapter.getInputAdapter("ChoiceIA");
        defaultChoiceInputAdapter.setGroupDescription(UpgradeHelper.i18n("DomainInfoVerificationPlugIn.ChoiceIA.description.text"));
        defaultChoiceInputAdapter.setMultipleSelectionPermitted(false);
        Choice[] choiceArray = new Choice[6];
        String[] stringArray = new String[]{"6.1", "7.0", "8.1", "9.0", "9.1", "9.2"};
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            choiceArray[i] = new Choice(stringArray[i], false);
            choiceArray[i].setPrompt(stringArray[i]);
            if ((domainMBean.getConfigurationVersion() == null || !domainMBean.getConfigurationVersion().startsWith(stringArray[i])) && (!"8.1".equals(stringArray[i]) || bl)) continue;
            choiceArray[i].setSelected(true);
            bl = true;
        }
        defaultChoiceInputAdapter.setChoices(choiceArray);
        DefaultTextInputAdapter defaultTextInputAdapter = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIA");
        defaultTextInputAdapter.setRequired(true);
        defaultTextInputAdapter.setDescription(UpgradeHelper.i18n("DomainInfoVerificationPlugIn.TextIA.input.description.text"));
        defaultTextInputAdapter.setValue(domainMBean.getName());
        defaultTextInputAdapter.setPrompt(UpgradeHelper.i18n("DomainInfoVerificationPlugIn.TextIA.input.prompt.text"));
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        ValidationStatus validationStatus = new ValidationStatus(true);
        DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)this._adapter;
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)defaultCompositeInputAdapter.getInputAdapter("ChoiceIA");
        Choice choice = defaultChoiceInputAdapter.getSelectedChoices()[0];
        String string = choice.getId();
        DefaultTextInputAdapter defaultTextInputAdapter = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIA");
        String string2 = defaultTextInputAdapter.getValue();
        if (string2 == null || string2.trim().length() == 0) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n(""));
            validationStatus.setValid(false);
        }
        return validationStatus;
    }

    public void execute() throws PlugInException {
        try {
            DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
            DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)this._adapter;
            DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)defaultCompositeInputAdapter.getInputAdapter("ChoiceIA");
            Choice choice = defaultChoiceInputAdapter.getSelectedChoices()[0];
            String string = choice.getId();
            DefaultTextInputAdapter defaultTextInputAdapter = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIA");
            String string2 = defaultTextInputAdapter.getValue();
            domainMBean.setName(string2);
            UpgradeHelper.log(this, UpgradeHelper.i18n("DomainInfoVerificationPlugIn.execute.domain_name_set", string2));
            domainMBean.setConfigurationVersion(string);
            UpgradeHelper.log(this, UpgradeHelper.i18n("DomainInfoVerificationPlugIn.execute.weblogic_version_set", string));
            UpgradeHelper.resetLocalServerNames(this, this._context);
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), exception.getMessage(), (Throwable)exception);
        }
    }
}

