/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryselection;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.ia.Choice;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.wizard.plugin.gui.InputAdapterGUIBinder;
import com.oracle.cie.common.ui.gui.MultiLineLabelUI;
import com.oracle.cie.common.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

public class OptionalGroupsInputAdapterGUIPanel
extends InputAdapterGUIBinder {
    protected Choice[] _choices = null;
    protected JToggleButton[] _buttons = null;
    protected JLabel[] _labels = null;

    public void init(PlugInContext plugInContext) {
        final ButtonGroup buttonGroup = new ButtonGroup();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        String string = ((DefaultChoiceInputAdapter)this._adapter).getGroupDescription();
        if (!StringUtil.isNullOrEmpty((String)string)) {
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            gridBagConstraints.insets.bottom = UIManager.getInt("PlugIn.choiceHeaderVSpacing");
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets.bottom = 0;
        }
        boolean bl = ((DefaultChoiceInputAdapter)this._adapter).isMulptipleSelectionPermitted();
        this._choices = ((DefaultChoiceInputAdapter)this._adapter).getChoices();
        this._buttons = new JToggleButton[this._choices.length];
        this._labels = new JLabel[this._choices.length];
        for (int i = 0; i < this._choices.length; ++i) {
            JToggleButton jToggleButton;
            if (bl) {
                jToggleButton = new JCheckBox(this._choices[i].getPrompt(), this._choices[i].isSelected());
            } else {
                jToggleButton = new JRadioButton(this._choices[i].getPrompt(), this._choices[i].isSelected());
                buttonGroup.add(jToggleButton);
            }
            JLabel jLabel = new JLabel(this._choices[i].getDescription());
            MultiLineLabelUI multiLineLabelUI = new MultiLineLabelUI();
            multiLineLabelUI.setWordWrap(110);
            jLabel.setUI((LabelUI)multiLineLabelUI);
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    jToggleButton.requestFocus();
                    jToggleButton.doClick();
                }
            });
            this._labels[i] = jLabel;
            this._buttons[i] = jToggleButton;
            jToggleButton.putClientProperty("choice", this._choices[i]);
            jToggleButton.putClientProperty("choices", this._choices);
            jToggleButton.putClientProperty("buttons", this._buttons);
            jToggleButton.putClientProperty("labels", this._labels);
            jToggleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JToggleButton[] jToggleButtonArray;
                    Choice[] choiceArray;
                    Choice choice;
                    if (buttonGroup.getButtonCount() > 0) {
                        choice = buttonGroup.getElements();
                        while (choice.hasMoreElements()) {
                            choiceArray = (Choice[])choice.nextElement();
                            jToggleButtonArray = (JToggleButton[])choiceArray.getClientProperty("choice");
                            jToggleButtonArray.setSelected(false);
                        }
                    }
                    choice = (Choice)jToggleButton.getClientProperty("choice");
                    choice.setSelected(jToggleButton.isSelected());
                    choiceArray = (Choice[])jToggleButton.getClientProperty("choices");
                    jToggleButtonArray = (JToggleButton[])jToggleButton.getClientProperty("buttons");
                    JLabel[] jLabelArray = (JLabel[])jToggleButton.getClientProperty("labels");
                    if (!choiceArray[0].isSelected()) {
                        choiceArray[1].setSelected(false);
                        jToggleButtonArray[1].setEnabled(false);
                        jLabelArray[1].setEnabled(false);
                    } else {
                        jToggleButtonArray[1].setEnabled(true);
                        jLabelArray[1].setEnabled(true);
                    }
                }
            });
            int n = gridBagConstraints.insets.top = bl ? UIManager.getInt("PlugIn.checkboxVSpacing") : UIManager.getInt("PlugIn.radiobuttonVSpacing");
            if (i == 0) {
                gridBagConstraints.insets.top = 0;
            }
            jPanel.add((Component)jToggleButton, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.top = UIManager.getInt("PlugIn.inlineHelpSpacing");
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.add(jPanel, "North");
    }

    public String[] getSelectedChoiceIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._choices.length; ++i) {
            if (!this._choices[i].isSelected()) continue;
            arrayList.add(this._choices[i].getId());
        }
        return arrayList.toArray(new String[0]);
    }
}

