/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryselection;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.Choice;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.util.Arrays;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryselection.VersionException;

public class SelectWebLogicVersionPlugIn
extends AbstractPlugIn {
    private static String DOMAIN_VERSION_SPECIFIED_BY_USER = "8.1";
    private static boolean DOMAIN_VERSION_HAS_BEEN_SPECIFIED_BY_USER = false;
    private static boolean DOMAIN_VERSION_9_0_OR_HIGHER_SPECIFIED_BY_USER = false;
    private static String DOMAIN_VERSION_9_0 = "9.0";

    public SelectWebLogicVersionPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        UpgradeHelper.addSummaryMessageForOutputLocation(plugInContext, this.getName());
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
        defaultChoiceInputAdapter.setGroupDescription(UpgradeHelper.i18n("SelectWebLogicVersionPlugIn.ChoiceIA.description.text"));
        defaultChoiceInputAdapter.setMultipleSelectionPermitted(false);
        Choice[] choiceArray = new Choice[4];
        String[] stringArray = new String[]{"6.1", "7.0", "8.1", UpgradeHelper.i18n("SelectWebLogicVersionPlugIn.ChoiceIA.domain.90orhigher.text")};
        String string = System.getProperty("weblogic.upgrade.domainversion");
        if (!Arrays.asList(stringArray).contains(string)) {
            string = "8.1";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            choiceArray[i] = new Choice(stringArray[i], false);
            choiceArray[i].setPrompt(stringArray[i]);
            if (!string.equals(stringArray[i])) continue;
            choiceArray[i].setSelected(true);
        }
        defaultChoiceInputAdapter.setChoices(choiceArray);
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
        Choice choice = defaultChoiceInputAdapter.getSelectedChoices()[0];
        String string = choice.getId();
        String string2 = UpgradeHelper.i18n("SelectWebLogicVersionPlugIn.ChoiceIA.domain.90orhigher.text");
        if (string2.equals(string)) {
            string = DOMAIN_VERSION_9_0;
            DOMAIN_VERSION_9_0_OR_HIGHER_SPECIFIED_BY_USER = true;
        }
        this._context.put((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_VERSION_KEY, (Object)string);
        return new ValidationStatus(true);
    }

    public void execute() throws PlugInException {
        String string;
        DOMAIN_VERSION_SPECIFIED_BY_USER = string = (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_CONFIGURATION_VERSION_KEY);
        DOMAIN_VERSION_HAS_BEEN_SPECIFIED_BY_USER = true;
        UpgradeHelper.log(this, UpgradeHelper.i18n("SelectWebLogicVersionPlugIn.execute.weblogic_version_set", string));
    }

    public static String getUserSpecifiedDomainVersion() {
        return DOMAIN_VERSION_SPECIFIED_BY_USER;
    }

    public static boolean getDomainVersionHasBeenSpecifiedByUser() {
        return DOMAIN_VERSION_HAS_BEEN_SPECIFIED_BY_USER;
    }

    public static void validateDomainVersion(String string) {
        if (string != null && string.trim().length() > 0 && DOMAIN_VERSION_9_0_OR_HIGHER_SPECIFIED_BY_USER && !string.startsWith("6.") && !string.startsWith("7.") && !string.startsWith("8.")) {
            return;
        }
        if (string != null && string.trim().length() > 0 && DOMAIN_VERSION_HAS_BEEN_SPECIFIED_BY_USER && !string.startsWith(DOMAIN_VERSION_SPECIFIED_BY_USER)) {
            if (string.length() >= 3) {
                string = string.substring(0, 3);
            }
            String string2 = UpgradeHelper.i18n("SelectWebLogicVersionPlugIn.validateDomainVersion.error", DOMAIN_VERSION_SPECIFIED_BY_USER, string);
            throw new VersionException(string2);
        }
    }
}

