/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import weblogic.upgrade.jms.UpgradeIOBypass;

public class BufferDataInputStream
extends InputStream
implements ObjectInput {
    private ByteBuffer buf;
    private UpgradeIOBypass objectIOBypass;
    private static final int VERSION = 1234;

    public BufferDataInputStream(UpgradeIOBypass upgradeIOBypass, ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        this.objectIOBypass = upgradeIOBypass;
    }

    public int read() {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.buf.remaining() <= 0) {
            return -1;
        }
        int n3 = Math.min(n2, this.buf.remaining());
        this.buf.get(byArray, n, n3);
        return n3;
    }

    public long skip(long l) {
        int n = Math.min((int)l, this.buf.remaining());
        this.buf.position(this.buf.position() + n);
        return n;
    }

    public int available() {
        return this.buf.remaining();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
        throw new UnsupportedOperationException("mark not supported");
    }

    public void reset() {
        this.buf.rewind();
    }

    public synchronized void close() throws IOException {
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.buf.remaining() < n2) {
            throw new EOFException();
        }
        this.buf.get(byArray, n, n2);
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = Math.min(n, this.buf.remaining());
        this.buf.position(this.buf.position() + n2);
        return n2;
    }

    public final Object readObject() throws IOException, ClassNotFoundException {
        int n = this.readInt();
        if (n != 1234) {
            throw new StreamCorruptedException("Unknown object stream version. " + n);
        }
        if (this.objectIOBypass == null) {
            throw new StreamCorruptedException("Stream can not handle raw objects.");
        }
        return this.objectIOBypass.readObject(this);
    }

    public final boolean readBoolean() throws IOException {
        try {
            byte by = this.buf.get();
            return by != 0;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final int readUnsignedByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final int readUnsignedShort() throws IOException {
        if (this.buf.remaining() < 2) {
            throw new EOFException();
        }
        return ((this.buf.get() & 0xFF) << 8) + ((this.buf.get() & 0xFF) << 0);
    }

    public final char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EOFException();
        }
    }

    public final String readLine() throws IOException {
        throw new IOException("not implemented");
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

