/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import weblogic.jms.backend.BEConfigUpdater;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class ConfigUpgradePlugIn
extends AbstractPlugIn {
    private DomainMBean domainBean;

    public ConfigUpgradePlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw new PlugInException(this.getName(), "The domain bean tree was not found");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("Beginning upgrade of the domain bean tree for the domain \"" + this.domainBean.getName() + "\"...");
        try {
            UpgradeHelper.setupWLSClientLogger(this);
            BEConfigUpdater bEConfigUpdater = new BEConfigUpdater();
            bEConfigUpdater.updateConfiguration(this.domainBean);
        }
        catch (ManagementException managementException) {
            this.updateStatus("Got an exception: " + (Object)((Object)managementException));
            throw new PlugInException(this.getName(), "Error updating configuration: " + (Object)((Object)managementException), (Throwable)managementException);
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
        this.updateStatus("Domain bean tree upgrade complete.");
    }

    private void updateStatus(String string) {
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), string + ""));
    }
}

