/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.File;
import java.io.IOException;
import javax.jms.JMSException;
import weblogic.management.configuration.GenericFileStoreMBean;
import weblogic.store.PersistentStoreException;
import weblogic.store.StoreWritePolicy;
import weblogic.store.admin.FileAdminHandler;
import weblogic.store.io.file.Heap;
import weblogic.upgrade.jms.BufferDataInputStream;
import weblogic.upgrade.jms.StoreReader;
import weblogic.upgrade.jms.UpgradeIOBypass;

public class FileStoreReader
implements StoreReader {
    private String storeName;
    private String directoryName;
    private Heap heap;
    private UpgradeIOBypass ioBypass;
    private boolean open;

    public FileStoreReader(GenericFileStoreMBean genericFileStoreMBean, UpgradeIOBypass upgradeIOBypass) throws JMSException {
        this.storeName = genericFileStoreMBean.getName();
        this.ioBypass = upgradeIOBypass;
        this.directoryName = FileAdminHandler.canonicalizeDirectoryName(genericFileStoreMBean.getDirectory());
        this.reOpen();
    }

    public void reOpen() throws JMSException {
        File[] fileArray;
        this.close();
        if (this.directoryName == null) {
            return;
        }
        File file = new File(this.directoryName);
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            try {
                this.heap = new Heap(this.storeName, this.directoryName, false);
                this.heap.setSynchronousWritePolicy(StoreWritePolicy.DISABLED);
                this.heap.open();
            }
            catch (PersistentStoreException persistentStoreException) {
                throw new weblogic.jms.common.JMSException(persistentStoreException);
            }
            this.open = true;
        }
    }

    public boolean requiresUpgrade() {
        return this.open;
    }

    public boolean alreadyUpgraded() {
        return this.open && this.heap.getHeapVersion() == 2;
    }

    public void close() {
        try {
            if (this.open) {
                this.heap.close();
                this.open = false;
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            // empty catch block
        }
    }

    public StoreReader.Record recover() throws JMSException {
        Heap.HeapRecord heapRecord;
        try {
            heapRecord = this.heap.recover();
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException(persistentStoreException);
        }
        if (heapRecord == null) {
            return null;
        }
        return this.makeRecord(heapRecord);
    }

    private StoreReader.Record makeRecord(Heap.HeapRecord heapRecord) throws JMSException {
        try {
            BufferDataInputStream bufferDataInputStream = new BufferDataInputStream(this.ioBypass, heapRecord.getBody());
            Object object = bufferDataInputStream.readObject();
            return new StoreReader.Record(heapRecord.getHandle(), heapRecord.getOldState(), object);
        }
        catch (IOException iOException) {
            throw new weblogic.jms.common.JMSException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new weblogic.jms.common.JMSException(classNotFoundException);
        }
    }
}

