/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.sql.DataSource;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.store.PersistentStoreException;
import weblogic.store.admin.JDBCAdminHandler;
import weblogic.store.io.jdbc.JDBCHelper;
import weblogic.upgrade.jms.BufferDataInputStream;
import weblogic.upgrade.jms.StoreReader;
import weblogic.upgrade.jms.UpgradeIOBypass;

public class JDBCStoreReader
implements StoreReader {
    private static final boolean debug = false;
    private String prefixName;
    private UpgradeIOBypass ioBypass;
    private ClearOrEncryptedService encryptionService;
    private String prefix = "";
    private boolean didUpgrade;
    private boolean recoveredState;
    private boolean recoveryComplete;
    private ResultSet recoverResults;
    private long recoverCount;
    private Map st;
    private int dbmsType;
    private DataSource dataSource;
    private Connection conn;
    private PreparedStatement selectStmt1;
    private PreparedStatement selectStmt2;
    private PreparedStatement selectStmt3;
    private PreparedStatement selectStmt4;
    private boolean tablesExist;
    private static final int CURRENT_VERSION = 1;
    private int version;
    boolean isOpen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCStoreReader(JDBCStoreMBean jDBCStoreMBean, UpgradeIOBypass upgradeIOBypass, ClearOrEncryptedService clearOrEncryptedService) throws JMSException {
        this.prefixName = jDBCStoreMBean.getPrefixName();
        this.ioBypass = upgradeIOBypass;
        this.encryptionService = clearOrEncryptedService;
        this.prefix = this.prefixName;
        if (this.prefix == null) {
            this.prefix = "";
        } else {
            int n = this.prefix.indexOf(".");
            while (n >= 0) {
                this.prefix = this.prefix.substring(n + 1);
                n = this.prefix.indexOf(".");
            }
        }
        this.st = new HashMap();
        try {
            this.dataSource = JDBCAdminHandler.createDataSource(jDBCStoreMBean, clearOrEncryptedService);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException("Can't create database connection: " + (Object)((Object)persistentStoreException), (Throwable)persistentStoreException);
        }
        this.opendb();
        try {
            try {
                this.dbmsType = JDBCHelper.getDBMSType((DatabaseMetaData)this.conn.getMetaData(), null);
            }
            catch (SQLException sQLException) {
                throw new weblogic.jms.common.JMSException("Can't get database type: " + sQLException, (Throwable)sQLException);
            }
            if (this.tablesInitialized()) {
                this.tablesExist = true;
                this.prepareStatements();
                this.version = this.getVersion();
            }
            this.isOpen = true;
        }
        finally {
            if (!this.isOpen) {
                this.closedb();
            }
        }
    }

    public boolean requiresUpgrade() {
        return this.tablesExist && this.version == 1;
    }

    public boolean alreadyUpgraded() {
        return false;
    }

    public void reOpen() {
        this.recoveryComplete = false;
        this.recoverCount = 0L;
    }

    private StoreReader.Record doRecover() throws JMSException {
        StoreReader.Record record;
        if (!this.recoveredState) {
            this.recoverCount = 0L;
            this.doRecoverStates();
            this.recoverResults = null;
            this.recoveredState = true;
        }
        if (this.recoveryComplete) {
            return null;
        }
        if (this.recoverResults == null) {
            try {
                this.recoverResults = this.selectStmt3.executeQuery();
            }
            catch (SQLException sQLException) {
                throw new weblogic.jms.common.JMSException("Error executing recovery query", (Throwable)sQLException);
            }
        }
        if ((record = this.doRecoverBodies()) == null) {
            this.ensureClosed(this.recoverResults);
            this.recoverResults = null;
            this.recoveryComplete = true;
        }
        return record;
    }

    private void doRecoverStates() throws JMSException {
        boolean bl = false;
        try {
            if (this.conn == null) {
                this.opendb();
            }
            this.recoverResults = this.selectStmt2.executeQuery();
            bl = true;
            while (this.recoverResults.next()) {
                long l = this.recoverResults.getLong("recordHandle");
                int n = this.recoverResults.getInt("recordState");
                long l2 = this.recoverResults.getLong("recordGeneration");
                if (l == -1L || l == -2L) continue;
                Long l3 = new Long(l);
                JMSState jMSState = (JMSState)this.st.get(l3);
                JMSState jMSState2 = new JMSState(n, l2);
                if (jMSState != null) {
                    if (jMSState.generation >= l2) continue;
                    this.st.put(l3, jMSState2);
                    continue;
                }
                this.st.put(l3, jMSState2);
            }
        }
        catch (Exception exception) {
            bl = false;
            throw new weblogic.jms.common.JMSException("Error recovering JMSState table", (Throwable)exception);
        }
        finally {
            if (bl) {
                this.ensureClosed(this.recoverResults);
            }
            this.recoverResults = null;
        }
    }

    private StoreReader.Record doRecoverBodies() throws JMSException {
        try {
            while (this.recoverResults.next()) {
                Object object;
                long l = this.recoverResults.getLong("recordHandle");
                int n = this.recoverResults.getInt("recordState");
                byte[] byArray = this.recoverResults.getBytes("record");
                JMSState jMSState = (JMSState)this.st.get(new Long(l));
                if (jMSState != null) {
                    if (jMSState.state == -1) continue;
                    n = jMSState.state;
                }
                try {
                    BufferDataInputStream bufferDataInputStream = new BufferDataInputStream(this.ioBypass, ByteBuffer.wrap(byArray));
                    object = bufferDataInputStream.readObject();
                }
                catch (IOException iOException) {
                    throw new weblogic.jms.common.JMSException(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new weblogic.jms.common.JMSException(classNotFoundException);
                }
                ++this.recoverCount;
                return new StoreReader.Record(l, n, object);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("Error recovering JMS messages", (Throwable)exception);
        }
        return null;
    }

    public StoreReader.Record recover() throws JMSException {
        if (this.didUpgrade) {
            return this.doRecover();
        }
        this.didUpgrade = true;
        return this.doRecover();
    }

    public void close() {
        this.isOpen = false;
        this.closedb();
    }

    private boolean tablesInitialized() throws JMSException {
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        try {
            boolean bl;
            int n;
            int n2;
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            if (this.dbmsType == 6) {
                string2 = databaseMetaData.getUserName().toUpperCase();
            } else if (this.prefixName != null && this.prefixName != "") {
                int n3 = this.prefixName.indexOf(".");
                n2 = -1;
                n = -1;
                bl = false;
                boolean bl2 = false;
                if (n3 >= 0) {
                    n2 = this.prefixName.indexOf(".", n3 + 1);
                    bl2 = true;
                }
                if (n2 >= 0) {
                    n = this.prefixName.indexOf(".", n2 + 1);
                    bl = true;
                }
                if (bl) {
                    string = this.prefixName.substring(0, n3);
                    string2 = this.prefixName.substring(n3 + 1, n2);
                } else if (bl2) {
                    string2 = this.prefixName.substring(0, n3);
                }
            }
            String string3 = "";
            switch (this.dbmsType) {
                case 5: {
                    string3 = this.prefix.toLowerCase() + "jms";
                    break;
                }
                case 1: {
                    string3 = this.prefix.toUpperCase() + "JMS";
                    break;
                }
                case 3: {
                    string3 = this.prefix + "JMS";
                }
            }
            if (this.dbmsType == 1 && databaseMetaData.getDriverMajorVersion() == 10 && databaseMetaData.getDatabaseProductVersion().startsWith("Oracle8i")) {
                string2 = string2 == null ? "" : " and OWNER LIKE '" + string2 + "'";
                resultSet = this.conn.createStatement().executeQuery("select TABLE_NAME from ALL_CATALOG where TABLE_NAME like '" + string3 + "%'" + string2);
                n2 = 1;
            } else {
                resultSet = databaseMetaData.getTables(string, string2, string3 + "%", null);
                n2 = 3;
            }
            n = 0;
            bl = false;
            while (resultSet.next()) {
                String string4 = resultSet.getString(n2);
                if (string4.equalsIgnoreCase(this.prefix + "JMSStore")) {
                    bl = true;
                    if (n == 0) continue;
                    break;
                }
                if (!string4.equalsIgnoreCase(this.prefix + "JMSState")) continue;
                n = 1;
                if (!bl) continue;
                break;
            }
            boolean bl3 = n != 0 && bl;
            this.ensureClosed(resultSet);
            return bl3;
        }
        catch (Exception exception) {
            try {
                throw new weblogic.jms.common.JMSException("Error checking for database tables", (Throwable)exception);
            }
            catch (Throwable throwable) {
                this.ensureClosed(resultSet);
                throw throwable;
            }
        }
    }

    private void ensureClosed(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ensureClosed(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ensureClosed(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        ResultSet resultSet = null;
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (this.conn == null) {
                this.opendb();
            }
            resultSet = this.selectStmt4.executeQuery();
            bl2 = true;
            if (resultSet.next()) {
                n = resultSet.getInt("recordState");
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        finally {
            if (bl2) {
                this.ensureClosed(resultSet);
            }
        }
        return n;
    }

    private void opendb() throws JMSException {
        if (this.conn != null) {
            return;
        }
        try {
            this.conn = this.dataSource.getConnection();
            this.conn.setAutoCommit(true);
        }
        catch (Exception exception) {
            this.closedb();
            throw new weblogic.jms.common.JMSException("Error connecting to the database", (Throwable)exception);
        }
    }

    private void prepareStatements() throws JMSException {
        try {
            this.selectStmt1 = this.conn.prepareStatement("SELECT record FROM " + this.prefix + "JMSStore " + "WHERE recordHandle = ?");
            this.selectStmt2 = this.conn.prepareStatement("SELECT recordHandle, recordState, recordGeneration FROM " + this.prefix + "JMSState");
            this.selectStmt3 = this.conn.prepareStatement("SELECT recordHandle, recordState, record FROM " + this.prefix + "JMSStore");
            this.selectStmt4 = this.conn.prepareStatement("SELECT recordHandle, recordState, recordGeneration FROM " + this.prefix + "JMSState" + " WHERE recordHandle = -1");
        }
        catch (Exception exception) {
            this.closedb();
            throw new weblogic.jms.common.JMSException("Error preparing SQL statements", (Throwable)exception);
        }
    }

    private void closedb() {
        try {
            this.ensureClosed(this.selectStmt1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ensureClosed(this.selectStmt2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ensureClosed(this.selectStmt3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ensureClosed(this.selectStmt4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ensureClosed(this.conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class JMSScavenge {
        long handle;
        long generation;
        int state;
        JMSScavenge next;

        JMSScavenge(long l, int n, long l2) {
            this.handle = l;
            this.generation = l2;
            this.state = n;
        }
    }

    private static final class JMSState {
        int state;
        long generation;

        JMSState(int n, long l) {
            this.state = n;
            this.generation = l;
        }
    }
}

