/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.backend.BEDurableSubscriptionStore;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSVariableBinder;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.SendOptions;
import weblogic.messaging.kernel.internal.DestinationImpl;
import weblogic.messaging.kernel.internal.MessageElementImpl;
import weblogic.messaging.kernel.internal.MessageHandle;
import weblogic.messaging.kernel.internal.MessageReference;
import weblogic.messaging.kernel.internal.MultiMessageHandle;
import weblogic.messaging.kernel.internal.MultiMessageReference;
import weblogic.messaging.kernel.internal.MultiPersistenceHandle;
import weblogic.messaging.kernel.internal.PersistenceImpl;
import weblogic.messaging.kernel.internal.QueueImpl;
import weblogic.messaging.kernel.internal.QueueMessageReference;
import weblogic.messaging.kernel.internal.TopicImpl;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.gxa.GXid;
import weblogic.store.gxa.internal.GXAObjectHandler;
import weblogic.store.gxa.internal.GXATwoPhaseRecord;
import weblogic.store.gxa.internal.GXidImpl;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.upgrade.jms.StoreReader;
import weblogic.upgrade.jms.StoreUpgradePlugIn;
import weblogic.upgrade.jms.UpgradeConsumer;
import weblogic.upgrade.jms.UpgradeDestinationDeleteRecord;
import weblogic.upgrade.jms.UpgradeDistConsumer;
import weblogic.upgrade.jms.UpgradeDurableTopicMessageInfo;
import weblogic.upgrade.jms.UpgradeIOBypass;
import weblogic.upgrade.jms.UpgradeMoveMessagePendingDeleteRecord;
import weblogic.upgrade.jms.UpgradeXATranEntryReceive;
import weblogic.upgrade.jms.UpgradeXAXid;
import weblogic.utils.expressions.Expression;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.expressions.ExpressionParser;
import weblogic.utils.expressions.ExpressionParserException;
import weblogic.utils.expressions.VariableBinder;

public class JMSStoreUpgradeProcessor {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean debug = false;
    private static final boolean debugVerbose = false;
    private StoreReader reader;
    private PersistentStoreXA store;
    private PersistenceImpl kernelPersistence;
    private BEDurableSubscriptionStore beSubscriptionStore;
    private UpgradeIOBypass ioBypass;
    private StoreUpgradePlugIn plugin;
    public static final int STORE_STATE_NONE = 0;
    public static final int STORE_STATE_PREADD = 1;
    public static final int STORE_STATE_REDELIVERED = 2;
    private static final int SEND_PACK_SIZE = 32;
    private String serverName;
    private String xaResourceName;
    private Map subscribersBySlot = new HashMap();
    private DifferentiatedHashMap dtmisByID = new DifferentiatedHashMap();
    private Map renamedQueues = new HashMap();
    private Map renamedTopics = new HashMap();
    private Map destinationsByName = new HashMap();
    private Map queuesByName = new HashMap();
    private Map topicsByName = new HashMap();
    private Map subscribersByName = new HashMap();
    private Map messageListsByName = new HashMap();
    private Set committedXIDs = new HashSet();
    private DifferentiatedHashMap pendingDeleteRecords = new DifferentiatedHashMap();
    private DifferentiatedHashMap preparedMessages = new DifferentiatedHashMap();
    private boolean hasPreparedMessages;
    private List xaRecords = new ArrayList();
    private ExpressionParser expressionParser = new ExpressionParser();
    private long nextDestinationID = 1L;
    private long nextHandleID = 1L;

    public JMSStoreUpgradeProcessor(StoreUpgradePlugIn storeUpgradePlugIn, String string, String string2, StoreReader storeReader, PersistentStoreXA persistentStoreXA, PersistenceImpl persistenceImpl, BEDurableSubscriptionStore bEDurableSubscriptionStore, UpgradeIOBypass upgradeIOBypass) {
        this.plugin = storeUpgradePlugIn;
        this.serverName = string;
        this.xaResourceName = string2;
        this.reader = storeReader;
        this.store = persistentStoreXA;
        this.kernelPersistence = persistenceImpl;
        this.beSubscriptionStore = bEDurableSubscriptionStore;
        this.ioBypass = upgradeIOBypass;
    }

    boolean has2PCRecords() {
        return this.hasPreparedMessages;
    }

    public void upgrade(int n) throws JMSException {
        int n2 = n / 8;
        int n3 = n / 4;
        try {
            this.mapDestinationNames();
            this.discoverDestinations();
            this.plugin.incrementProgress(n2);
            this.createKernelDestinations();
            this.plugin.incrementProgress(n3);
            this.reader.reOpen();
            this.upgradeMessages();
            this.plugin.incrementProgress(n3);
            this.createKernelMessages();
            this.plugin.incrementProgress(n3);
            this.createXARecords();
            this.plugin.incrementProgress(n2);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException(persistentStoreException);
        }
    }

    private void mapDestinationNames() {
        JMSBean jMSBean = JMSBeanHelper.getInteropJMSBean(this.plugin.getDomainBean());
        if (jMSBean != null) {
            QueueBean[] queueBeanArray = jMSBean.getQueues();
            for (int i = 0; queueBeanArray != null && i < queueBeanArray.length; ++i) {
                QueueBean queueBean = queueBeanArray[i];
                if (queueBean.getJMSCreateDestinationIdentifier() == null || !queueBean.getName().endsWith(this.serverName)) continue;
                this.renamedQueues.put(queueBean.getJMSCreateDestinationIdentifier(), queueBean.getName());
            }
            TopicBean[] topicBeanArray = jMSBean.getTopics();
            for (int i = 0; topicBeanArray != null && i < topicBeanArray.length; ++i) {
                TopicBean topicBean = topicBeanArray[i];
                if (topicBean.getJMSCreateDestinationIdentifier() == null || !topicBean.getName().endsWith(this.serverName)) continue;
                this.renamedTopics.put(topicBean.getJMSCreateDestinationIdentifier(), topicBean.getName());
            }
        }
    }

    private String getNewQueueName(String string) {
        String string2 = (String)this.renamedQueues.get(string);
        return string2 == null ? string : string2;
    }

    private String getNewTopicName(String string) {
        String string2 = (String)this.renamedTopics.get(string);
        return string2 == null ? string : string2;
    }

    private void discoverDestinations() throws JMSException {
        Object object;
        Iterator iterator;
        HashSet<DestinationKey> hashSet = new HashSet<DestinationKey>();
        HashSet<DestinationKey> hashSet2 = new HashSet<DestinationKey>();
        int n = 0;
        int n2 = 0;
        StoreReader.Record record = this.reader.recover();
        while (record != null) {
            ++n;
            iterator = record.getObject();
            switch (this.ioBypass.getCode(iterator)) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    UpgradeXAXid upgradeXAXid;
                    ++n2;
                    object = (MessageImpl)((Object)iterator);
                    weblogic.jms.common.DestinationImpl destinationImpl = (weblogic.jms.common.DestinationImpl)((MessageImpl)object).getJMSDestination();
                    hashSet.add(new DestinationKey(destinationImpl.getName(), destinationImpl.getGeneration()));
                    if (((MessageImpl)object).getBEXAXid() != null && ((MessageImpl)object).getBEXAXid() instanceof UpgradeMoveMessagePendingDeleteRecord && (record.getState() & 1) == 0) {
                        this.pendingDeleteRecords.put(((MessageImpl)object).getId(), ((MessageImpl)object).getBEXAXid());
                        break;
                    }
                    if ((record.getState() & 1) == 0 || this.committedXIDs.contains(upgradeXAXid = (UpgradeXAXid)((MessageImpl)object).getBEXAXid())) break;
                    this.preparedMessages.put(((MessageImpl)object).getId(), upgradeXAXid);
                    this.hasPreparedMessages = true;
                    break;
                }
                case 21: {
                    ++n2;
                    UpgradeDestinationDeleteRecord upgradeDestinationDeleteRecord = (UpgradeDestinationDeleteRecord)((Object)iterator);
                    hashSet2.add(new DestinationKey(upgradeDestinationDeleteRecord.getDestinationName(), upgradeDestinationDeleteRecord.getCreationTime()));
                    break;
                }
                case 1: 
                case 19: {
                    ++n2;
                    UpgradeConsumer upgradeConsumer = (UpgradeConsumer)((Object)iterator);
                    UpgradeConsumer upgradeConsumer2 = (UpgradeConsumer)this.subscribersBySlot.get(upgradeConsumer.getDurableSlot());
                    if (upgradeConsumer2 != null && upgradeConsumer.getTimestampId().compareTime(upgradeConsumer2.getTimestampId()) <= 0) break;
                    this.subscribersBySlot.put(upgradeConsumer.getDurableSlot(), upgradeConsumer);
                    break;
                }
                case 17: {
                    ++n2;
                    UpgradeDurableTopicMessageInfo upgradeDurableTopicMessageInfo = (UpgradeDurableTopicMessageInfo)((Object)iterator);
                    UpgradeDurableTopicMessageInfo upgradeDurableTopicMessageInfo2 = (UpgradeDurableTopicMessageInfo)this.dtmisByID.get(upgradeDurableTopicMessageInfo.getMessageId());
                    if (upgradeDurableTopicMessageInfo2 != null && upgradeDurableTopicMessageInfo.getGeneration() <= upgradeDurableTopicMessageInfo2.getGeneration()) break;
                    this.dtmisByID.put(upgradeDurableTopicMessageInfo.getMessageId(), upgradeDurableTopicMessageInfo);
                    break;
                }
                case 3: {
                    ++n2;
                    UpgradeXAXid upgradeXAXid = (UpgradeXAXid)((Object)iterator);
                    this.committedXIDs.add(upgradeXAXid);
                    break;
                }
                case 4: {
                    ++n2;
                    UpgradeXATranEntryReceive upgradeXATranEntryReceive = (UpgradeXATranEntryReceive)((Object)iterator);
                    if (this.committedXIDs.contains(upgradeXATranEntryReceive.getRecoveredBEXAXid())) break;
                    this.preparedMessages.put(upgradeXATranEntryReceive.getRecoveredMessageId(), upgradeXATranEntryReceive);
                    this.hasPreparedMessages = true;
                    break;
                }
                case 20: {
                    ++n2;
                    UpgradeMoveMessagePendingDeleteRecord upgradeMoveMessagePendingDeleteRecord = (UpgradeMoveMessagePendingDeleteRecord)((Object)iterator);
                    this.pendingDeleteRecords.put(upgradeMoveMessagePendingDeleteRecord.getMessageId(), upgradeMoveMessagePendingDeleteRecord);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Recovered object from invalid class " + iterator.getClass().getName()));
                }
            }
            record = this.reader.recover();
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet.remove(iterator.next());
        }
        for (DestinationKey destinationKey : hashSet) {
            object = (DestinationRec)this.destinationsByName.get(destinationKey.getName());
            if (object != null && destinationKey.getGeneration() <= ((DestinationRec)object).getGeneration()) continue;
            this.destinationsByName.put(destinationKey.getName(), new DestinationRec(destinationKey.getGeneration()));
        }
    }

    private void createKernelDestinations() throws JMSException, KernelException {
        HashSet hashSet = new HashSet(this.destinationsByName.keySet());
        for (UpgradeConsumer upgradeConsumer : this.subscribersBySlot.values()) {
            ArrayList<SubscriberRec> arrayList;
            upgradeConsumer.parseName();
            String string = upgradeConsumer instanceof UpgradeDistConsumer ? upgradeConsumer.getSubscriptionName() : BETopicImpl.getSubscriptionQueueName(null, upgradeConsumer.getClientId(), upgradeConsumer.getSubscriptionName());
            upgradeConsumer.setQueueName(string);
            this.createKernelQueue(string);
            weblogic.jms.common.DestinationImpl destinationImpl = upgradeConsumer.getStoredTopic();
            hashSet.remove(destinationImpl.getName());
            if (!this.topicsByName.containsKey(destinationImpl.getName())) {
                this.createKernelTopic(destinationImpl.getName());
            }
            if ((arrayList = (ArrayList<SubscriberRec>)this.subscribersByName.get(destinationImpl.getName())) == null) {
                arrayList = new ArrayList<SubscriberRec>();
                this.subscribersByName.put(destinationImpl.getName(), arrayList);
            }
            arrayList.add(new SubscriberRec(upgradeConsumer, this.expressionParser));
            if (upgradeConsumer instanceof UpgradeDistConsumer) continue;
            JMSSQLExpression jMSSQLExpression = new JMSSQLExpression(upgradeConsumer.getSelector(), upgradeConsumer.getNoLocal(), null, false);
            this.beSubscriptionStore.createSubscription(this.getNewTopicName(destinationImpl.getName()), upgradeConsumer.getClientId(), upgradeConsumer.getSubscriptionName(), jMSSQLExpression);
        }
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.createKernelQueue((String)iterator.next());
        }
    }

    private void createKernelQueue(String string) throws KernelException {
        QueueImpl queueImpl = new QueueImpl(this.getNewQueueName(string));
        queueImpl.setSerialNumber(this.nextDestinationID++);
        this.queuesByName.put(string, queueImpl);
        this.kernelPersistence.createDestination((DestinationImpl)queueImpl);
        DestinationRec destinationRec = (DestinationRec)this.destinationsByName.get(string);
        if (destinationRec == null) {
            destinationRec = new DestinationRec(0L, (DestinationImpl)queueImpl);
            this.destinationsByName.put(string, destinationRec);
        } else {
            destinationRec.setDestination((DestinationImpl)queueImpl);
        }
    }

    private void createKernelTopic(String string) throws KernelException {
        TopicImpl topicImpl = new TopicImpl(this.getNewTopicName(string));
        topicImpl.setSerialNumber(this.nextDestinationID++);
        this.topicsByName.put(string, topicImpl);
        this.kernelPersistence.createDestination((DestinationImpl)topicImpl);
        DestinationRec destinationRec = (DestinationRec)this.destinationsByName.get(string);
        if (destinationRec == null) {
            destinationRec = new DestinationRec(0L, (DestinationImpl)topicImpl);
            this.destinationsByName.put(string, destinationRec);
        } else {
            destinationRec.setDestination((DestinationImpl)topicImpl);
        }
    }

    private void upgradeMessages() throws JMSException, PersistentStoreException {
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray;
        JMSBean jMSBean = JMSBeanHelper.getInteropJMSBean(this.plugin.getDomainBean());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (jMSBean != null) {
            int n;
            int n2;
            DistributedQueueBean[] distributedQueueBeanArray = jMSBean.getDistributedQueues();
            DistributedTopicBean[] distributedTopicBeanArray = jMSBean.getDistributedTopics();
            for (n2 = 0; n2 < distributedQueueBeanArray.length; ++n2) {
                distributedDestinationMemberBeanArray = distributedQueueBeanArray[n2].getDistributedQueueMembers();
                for (n = 0; n < distributedDestinationMemberBeanArray.length; ++n) {
                    hashMap.put(distributedDestinationMemberBeanArray[n].getPhysicalDestinationName(), distributedQueueBeanArray[n2].getName());
                }
            }
            for (n2 = 0; n2 < distributedTopicBeanArray.length; ++n2) {
                distributedDestinationMemberBeanArray = distributedTopicBeanArray[n2].getDistributedTopicMembers();
                for (n = 0; n < distributedDestinationMemberBeanArray.length; ++n) {
                    hashMap.put(distributedDestinationMemberBeanArray[n].getPhysicalDestinationName(), distributedTopicBeanArray[n2].getName());
                }
            }
        }
        int n = 0;
        int n3 = 0;
        StoreReader.Record record = this.reader.recover();
        while (record != null) {
            ++n;
            distributedDestinationMemberBeanArray = record.getObject();
            switch (this.ioBypass.getCode(distributedDestinationMemberBeanArray)) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    String string;
                    ++n3;
                    MessageImpl messageImpl = (MessageImpl)distributedDestinationMemberBeanArray;
                    weblogic.jms.common.DestinationImpl destinationImpl = (weblogic.jms.common.DestinationImpl)messageImpl.getJMSDestination();
                    DestinationRec destinationRec = (DestinationRec)this.destinationsByName.get(destinationImpl.getName());
                    messageImpl.setOldMessage(true);
                    weblogic.jms.common.DestinationImpl destinationImpl2 = (weblogic.jms.common.DestinationImpl)messageImpl.getJMSReplyTo();
                    if (destinationImpl2 != null && (string = (String)hashMap.get(destinationImpl2.getName())) != null) {
                        messageImpl.setJMSReplyTo(new weblogic.jms.common.DestinationImpl(destinationImpl2.getType(), destinationImpl2.getServerName(), string, destinationImpl2.getApplicationName(), destinationImpl2.getModuleName(), destinationImpl2.getBackEndId(), destinationImpl2.getDestinationId()));
                    }
                    if (destinationRec == null || destinationImpl.getGeneration() != destinationRec.getGeneration()) break;
                    string = destinationRec.getDestination() instanceof QueueImpl ? this.createQueueMessage(record, messageImpl, destinationImpl, destinationRec) : this.createTopicMessage(messageImpl, destinationImpl);
                    string.setPagedOut();
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 17: 
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Recovered object from invalid class " + distributedDestinationMemberBeanArray.getClass().getName()));
                }
            }
            record = this.reader.recover();
        }
    }

    private SendOptions createSendOptions(MessageImpl messageImpl) {
        SendOptions sendOptions = new SendOptions();
        sendOptions.setPersistent(true);
        sendOptions.setDeliveryTime(messageImpl.getDeliveryTime());
        sendOptions.setExpirationTime(messageImpl.getExpirationTime());
        sendOptions.setRedeliveryLimit(messageImpl.getRedeliveryLimit());
        return sendOptions;
    }

    private MessageHandle createQueueMessage(StoreReader.Record record, MessageImpl messageImpl, weblogic.jms.common.DestinationImpl destinationImpl, DestinationRec destinationRec) throws PersistentStoreException {
        Object object;
        MessageHandle messageHandle = new MessageHandle(this.nextHandleID++, (Message)messageImpl, this.createSendOptions(messageImpl));
        UpgradeMoveMessagePendingDeleteRecord upgradeMoveMessagePendingDeleteRecord = (UpgradeMoveMessagePendingDeleteRecord)this.pendingDeleteRecords.get(messageImpl.getId());
        if (upgradeMoveMessagePendingDeleteRecord != null && upgradeMoveMessagePendingDeleteRecord.isQueueMessage()) {
            return messageHandle;
        }
        QueueImpl queueImpl = (QueueImpl)destinationRec.getDestination();
        QueueMessageReference queueMessageReference = new QueueMessageReference(queueImpl, messageHandle);
        if ((record.getState() & 2) != 0) {
            queueMessageReference.setDeliveryCount(1);
        }
        if ((object = this.preparedMessages.get(messageImpl.getId())) != null) {
            if (object instanceof UpgradeXAXid) {
                UpgradeXAXid upgradeXAXid = (UpgradeXAXid)object;
                if (!this.committedXIDs.contains(upgradeXAXid)) {
                    this.xaRecords.add(new PreparedTransactionRec((MessageReference)queueMessageReference, queueImpl, upgradeXAXid, 1));
                }
            } else if (object instanceof UpgradeXATranEntryReceive) {
                UpgradeXATranEntryReceive upgradeXATranEntryReceive = (UpgradeXATranEntryReceive)object;
                if (!this.committedXIDs.contains(upgradeXATranEntryReceive.getRecoveredBEXAXid())) {
                    this.xaRecords.add(new PreparedTransactionRec((MessageReference)queueMessageReference, queueImpl, upgradeXATranEntryReceive.getRecoveredBEXAXid(), 2));
                }
            } else {
                throw new AssertionError();
            }
        }
        this.addMessageToList(destinationImpl.getName(), (MessageReference)queueMessageReference, messageImpl);
        messageImpl.setBEXAXid(null);
        this.persistMessageBody(messageHandle);
        return messageHandle;
    }

    private MessageHandle createTopicMessage(MessageImpl messageImpl, weblogic.jms.common.DestinationImpl destinationImpl) throws PersistentStoreException {
        MultiMessageHandle multiMessageHandle = new MultiMessageHandle(this.nextHandleID++, (Message)messageImpl, this.createSendOptions(messageImpl));
        UpgradeMoveMessagePendingDeleteRecord upgradeMoveMessagePendingDeleteRecord = (UpgradeMoveMessagePendingDeleteRecord)this.pendingDeleteRecords.get(messageImpl.getId());
        if (upgradeMoveMessagePendingDeleteRecord != null && upgradeMoveMessagePendingDeleteRecord.appliesToAllConsumers()) {
            return multiMessageHandle;
        }
        UpgradeXAXid upgradeXAXid = null;
        Object object = this.preparedMessages.get(messageImpl.getId());
        if (object != null && object instanceof UpgradeXAXid && !this.committedXIDs.contains(object)) {
            upgradeXAXid = (UpgradeXAXid)object;
        }
        MultiPersistenceHandle multiPersistenceHandle = null;
        int n = 0;
        boolean bl = false;
        UpgradeDurableTopicMessageInfo upgradeDurableTopicMessageInfo = (UpgradeDurableTopicMessageInfo)this.dtmisByID.get(messageImpl.getId());
        if (upgradeDurableTopicMessageInfo == null) {
            List list = (List)this.subscribersByName.get(destinationImpl.getName());
            if (list != null) {
                for (SubscriberRec subscriberRec : list) {
                    if (!subscriberRec.match(messageImpl)) continue;
                    QueueImpl queueImpl = (QueueImpl)this.queuesByName.get(subscriberRec.getConsumer().getQueueName());
                    bl = true;
                    if (multiPersistenceHandle == null || n >= 32) {
                        multiPersistenceHandle = new MultiPersistenceHandle((MessageHandle)multiMessageHandle);
                    }
                    MultiMessageReference multiMessageReference = new MultiMessageReference(queueImpl, (MessageHandle)multiMessageHandle, multiPersistenceHandle);
                    ++n;
                    this.addMessageToList(queueImpl.getName(), (MessageReference)multiMessageReference, messageImpl);
                    if (upgradeXAXid == null) continue;
                    this.xaRecords.add(new PreparedTransactionRec((MessageReference)multiMessageReference, queueImpl, upgradeXAXid, 6));
                }
            }
        } else {
            int n2 = -1;
            while ((n2 = upgradeDurableTopicMessageInfo.getNextOccupiedSlot(n2)) >= 0) {
                UpgradeXAXid upgradeXAXid2;
                UpgradeConsumer upgradeConsumer = (UpgradeConsumer)this.subscribersBySlot.get(new Integer(n2));
                if (upgradeConsumer == null || upgradeDurableTopicMessageInfo.isOlderThanConsumer(upgradeConsumer) || upgradeMoveMessagePendingDeleteRecord != null && upgradeMoveMessagePendingDeleteRecord.getSlot() == n2) continue;
                QueueImpl queueImpl = (QueueImpl)this.queuesByName.get(upgradeConsumer.getQueueName());
                bl = true;
                if (multiPersistenceHandle == null || n >= 32) {
                    multiPersistenceHandle = new MultiPersistenceHandle((MessageHandle)multiMessageHandle);
                }
                MultiMessageReference multiMessageReference = new MultiMessageReference(queueImpl, (MessageHandle)multiMessageHandle, multiPersistenceHandle);
                ++n;
                if (upgradeDurableTopicMessageInfo.isRedelivered(upgradeConsumer)) {
                    multiMessageReference.setDeliveryCount(1);
                }
                this.addMessageToList(queueImpl.getName(), (MessageReference)multiMessageReference, messageImpl);
                if (upgradeXAXid != null) {
                    this.xaRecords.add(new PreparedTransactionRec((MessageReference)multiMessageReference, queueImpl, upgradeXAXid, 6));
                    continue;
                }
                if (upgradeDurableTopicMessageInfo.getReceiveTran(upgradeConsumer) == null || this.committedXIDs.contains(upgradeXAXid2 = upgradeDurableTopicMessageInfo.getReceiveTran(upgradeConsumer))) continue;
                this.xaRecords.add(new PreparedTransactionRec((MessageReference)multiMessageReference, queueImpl, upgradeXAXid2, 2));
            }
        }
        if (bl) {
            messageImpl.setBEXAXid(null);
            this.persistMessageBody((MessageHandle)multiMessageHandle);
        }
        return multiMessageHandle;
    }

    private void addMessageToList(String string, MessageReference messageReference, MessageImpl messageImpl) {
        ArrayList<MessageElementRec> arrayList = (ArrayList<MessageElementRec>)this.messageListsByName.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<MessageElementRec>();
            this.messageListsByName.put(string, arrayList);
        }
        arrayList.add(new MessageElementRec(messageReference, messageImpl.getId()));
    }

    private void persistMessageBody(MessageHandle messageHandle) throws PersistentStoreException {
        PersistentStoreTransaction persistentStoreTransaction = this.kernelPersistence.startStoreTransaction();
        this.kernelPersistence.createMessageBody(persistentStoreTransaction, messageHandle);
        persistentStoreTransaction.commit();
    }

    private void persistMessageElement(MessageReference messageReference) throws PersistentStoreException {
        PersistentStoreTransaction persistentStoreTransaction = this.kernelPersistence.startStoreTransaction();
        if (messageReference instanceof QueueMessageReference) {
            QueueMessageReference queueMessageReference = (QueueMessageReference)messageReference;
            this.kernelPersistence.createQueueMessageReference(persistentStoreTransaction, queueMessageReference);
        } else if (messageReference instanceof MultiMessageReference) {
            MultiMessageReference multiMessageReference = (MultiMessageReference)messageReference;
            MultiPersistenceHandle multiPersistenceHandle = multiMessageReference.getPersistenceHandle();
            if (multiPersistenceHandle.getPersistentHandle() == null) {
                this.kernelPersistence.createMultiMessageReference(persistentStoreTransaction, multiPersistenceHandle);
            }
        } else {
            throw new AssertionError();
        }
        persistentStoreTransaction.commit();
    }

    private void createKernelMessages() throws PersistentStoreException {
        MessageReference messageReference;
        Iterator iterator = this.messageListsByName.entrySet().iterator();
        ArrayList<MessageReference> arrayList = new ArrayList<MessageReference>();
        while (iterator.hasNext()) {
            Map.Entry messageElementRecArray = iterator.next();
            List list = (List)messageElementRecArray.getValue();
            if (list.isEmpty()) continue;
            messageReference = new MessageElementRec[list.size()];
            messageReference = list.toArray((T[])messageReference);
            Arrays.sort((Object[])messageReference);
            for (int i = 0; i < ((MessageReference)messageReference).length; ++i) {
                MessageReference messageReference2 = messageReference[i].getElement();
                messageReference2.setSequenceNumber((long)i);
            }
            arrayList.add(messageReference);
        }
        for (MessageElementRec[] messageElementRecArray : arrayList) {
            for (int i = 0; i < messageElementRecArray.length; ++i) {
                messageReference = messageElementRecArray[i].getElement();
                this.persistMessageElement(messageReference);
            }
        }
    }

    private void createXARecords() throws PersistentStoreException {
        PreparedTransactionRec preparedTransactionRec2;
        if (this.xaRecords.isEmpty()) {
            return;
        }
        String string = SubjectUtils.getUsername((Subject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID).getSubject());
        HashSet<UpgradeXAXid> hashSet = new HashSet<UpgradeXAXid>();
        for (PreparedTransactionRec preparedTransactionRec2 : this.xaRecords) {
            hashSet.add(preparedTransactionRec2.getXid());
            PersistentStoreTransaction persistentStoreTransaction = this.kernelPersistence.startStoreTransaction();
            this.kernelPersistence.create2PCRecord(persistentStoreTransaction, preparedTransactionRec2.getType(), (GXid)new GXidImpl((Xid)preparedTransactionRec2.getXid()), preparedTransactionRec2.getQueue(), preparedTransactionRec2.getElement(), string);
            persistentStoreTransaction.commit();
        }
        preparedTransactionRec2 = this.store.createConnection(this.xaResourceName, (ObjectHandler)new GXAObjectHandler());
        for (UpgradeXAXid upgradeXAXid : hashSet) {
            GXATwoPhaseRecord gXATwoPhaseRecord = new GXATwoPhaseRecord(new GXidImpl((Xid)upgradeXAXid), false);
            PersistentStoreTransaction persistentStoreTransaction = this.kernelPersistence.startStoreTransaction();
            preparedTransactionRec2.create(persistentStoreTransaction, gXATwoPhaseRecord, 0);
            persistentStoreTransaction.commit();
        }
    }

    private static final class SubscriberRec {
        private UpgradeConsumer consumer;
        private Expression expression;

        SubscriberRec(UpgradeConsumer upgradeConsumer, ExpressionParser expressionParser) throws JMSException {
            this.consumer = upgradeConsumer;
            if (upgradeConsumer.getSelector() != null) {
                try {
                    this.expression = expressionParser.parse(upgradeConsumer.getSelector(), (VariableBinder)JMSVariableBinder.THE_ONE);
                }
                catch (ExpressionParserException expressionParserException) {
                    throw new weblogic.jms.common.JMSException("Error parsing selector \"" + upgradeConsumer.getSelector() + "\"", (Throwable)expressionParserException);
                }
            }
        }

        UpgradeConsumer getConsumer() {
            return this.consumer;
        }

        boolean match(MessageImpl messageImpl) {
            if (messageImpl.getId().compareTime(this.consumer.getTimestampId()) < 0) {
                return false;
            }
            if (this.consumer instanceof UpgradeDistConsumer && messageImpl.getDDForwarded()) {
                return false;
            }
            if (this.expression == null) {
                return true;
            }
            try {
                return this.expression.evaluate((Object)new MessageElementImpl((Message)messageImpl));
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                return false;
            }
        }
    }

    private static final class PreparedTransactionRec {
        private MessageReference element;
        private QueueImpl queue;
        private UpgradeXAXid xid;
        private int type;

        PreparedTransactionRec(MessageReference messageReference, QueueImpl queueImpl, UpgradeXAXid upgradeXAXid, int n) {
            this.element = messageReference;
            this.queue = queueImpl;
            this.xid = upgradeXAXid;
            this.type = n;
        }

        MessageReference getElement() {
            return this.element;
        }

        QueueImpl getQueue() {
            return this.queue;
        }

        UpgradeXAXid getXid() {
            return this.xid;
        }

        int getType() {
            return this.type;
        }
    }

    private static final class MessageElementRec
    implements Comparable {
        private MessageReference element;
        private JMSMessageId id;

        MessageElementRec(MessageReference messageReference, JMSMessageId jMSMessageId) {
            this.element = messageReference;
            this.id = jMSMessageId;
        }

        MessageReference getElement() {
            return this.element;
        }

        JMSMessageId getId() {
            return this.id;
        }

        public boolean equals(Object object) {
            MessageElementRec messageElementRec = (MessageElementRec)object;
            return this.id.equals(messageElementRec.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public int compareTo(Object object) {
            MessageElementRec messageElementRec = (MessageElementRec)object;
            return this.id.compare(messageElementRec.id);
        }
    }

    private static final class DestinationKey {
        private String name;
        private long generation;

        DestinationKey(String string, long l) {
            this.name = string;
            this.generation = l;
        }

        String getName() {
            return this.name;
        }

        long getGeneration() {
            return this.generation;
        }

        public boolean equals(Object object) {
            try {
                DestinationKey destinationKey = (DestinationKey)object;
                return this.name.equals(destinationKey.name) && this.generation == destinationKey.generation;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.name.hashCode() + (int)this.generation;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ name=");
            stringBuffer.append(this.name);
            stringBuffer.append(" generation=");
            stringBuffer.append(this.generation);
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    private static final class DestinationRec {
        private long generation;
        private DestinationImpl dest;

        DestinationRec(long l) {
            this.generation = l;
        }

        DestinationRec(long l, DestinationImpl destinationImpl) {
            this.generation = l;
            this.dest = destinationImpl;
        }

        long getGeneration() {
            return this.generation;
        }

        void setDestination(DestinationImpl destinationImpl) {
            this.dest = destinationImpl;
        }

        DestinationImpl getDestination() {
            return this.dest;
        }
    }

    private static class DifferentiatedHashMap {
        private HashMap map = new HashMap();

        private DifferentiatedHashMap() {
        }

        Object get(JMSMessageId jMSMessageId) {
            return this.map.get(new DifferentiatedJMSMessageId(jMSMessageId));
        }

        void put(JMSMessageId jMSMessageId, Object object) {
            this.map.put(new DifferentiatedJMSMessageId(jMSMessageId), object);
        }

        Object remove(JMSMessageId jMSMessageId) {
            return this.map.remove(new DifferentiatedJMSMessageId(jMSMessageId));
        }

        Collection values() {
            return this.map.values();
        }
    }

    private static class DifferentiatedJMSMessageId {
        private JMSMessageId mid;

        DifferentiatedJMSMessageId(JMSMessageId jMSMessageId) {
            this.mid = jMSMessageId;
        }

        public boolean equals(Object object) {
            DifferentiatedJMSMessageId differentiatedJMSMessageId = (DifferentiatedJMSMessageId)object;
            return this.mid.differentiatedEquals(differentiatedJMSMessageId.mid);
        }

        public int hashCode() {
            return this.mid.differentiatedHashCode();
        }
    }
}

