/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.PlugInProgressObservation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.management.InvalidAttributeValueException;
import weblogic.jms.backend.BEDurableSubscriptionStore;
import weblogic.jms.store.JMSObjectHandler;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.GenericFileStoreMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.internal.PersistenceImpl;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.StoreWritePolicy;
import weblogic.store.admin.FileAdminHandler;
import weblogic.store.admin.JDBCAdminHandler;
import weblogic.store.io.file.StoreDir;
import weblogic.store.xa.PersistentStoreManagerXA;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.jms.FileStoreReader;
import weblogic.upgrade.jms.JDBCStoreReader;
import weblogic.upgrade.jms.JMSStoreUpgradeProcessor;
import weblogic.upgrade.jms.StoreReader;
import weblogic.upgrade.jms.UpgradeIOBypass;

public class StoreUpgradePlugIn
extends AbstractPlugIn {
    private static final String NEW_FILE_NAME_PREFIX = "NEW";
    private static final String OLD_FILE_NAME_PREFIX = "OLD";
    private static final String UPGRADE_CONNECTION_NAME = "weblogic.upgrade.jms";
    private static final String UPGRADE_START_INDICATOR = "9.1 UpgradeInProgress";
    private static final String UPGRADE_DONE_INDICATOR = "9.1 UpgradeComplete";
    private DomainMBean domainBean;
    private String[] serverNames;
    private ClearOrEncryptedService encryptionService;
    private PlugInProgressObservation progress;
    private PersistentStoreXA currentNewStore;

    public StoreUpgradePlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
            UpgradeHelper.setupWLSClientLogger(this);
            this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
            if (this.domainBean == null) {
                throw this.createException("StoreUpgradePlugIn.exc.NoBeanTree");
            }
            File file = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
            if (file == null) {
                throw this.createException("StoreUpgradePlugIn.exc.NoDomainDir");
            }
            EncryptionService encryptionService = SerializedSystemIni.getEncryptionService(file.getPath());
            this.encryptionService = new ClearOrEncryptedService(encryptionService);
            this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
            if (this.serverNames == null) {
                throw new PlugInException(this.getName(), "The list of server names was not found");
            }
            JMSServerMBean[] jMSServerMBeanArray = this.domainBean.getJMSServers();
            for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
                if (jMSServerMBeanArray[i].getStore() == null) continue;
                throw this.createException("StoreUpgradePlugIn.exc.NotUpgraded", jMSServerMBeanArray[i].getName());
            }
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
    }

    private boolean targetsMatch(JMSServerMBean jMSServerMBean) {
        TargetMBean[] targetMBeanArray = jMSServerMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length != 1) {
            return false;
        }
        for (int i = 0; i < this.serverNames.length; ++i) {
            if (!targetMBeanArray[0].getServerNames().contains(this.serverNames[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws PlugInException {
        try {
            UpgradeHelper.setupWLSClientLogger(this);
            this.setProgress(0);
            JMSServerMBean[] jMSServerMBeanArray = this.domainBean.getJMSServers();
            if (jMSServerMBeanArray == null || jMSServerMBeanArray.length == 0) {
                this.updateStatus("StoreUpgradePlugIn.msg.NoServersToUpgrade");
                this.setProgress(100);
                return;
            }
            int n = 100 / jMSServerMBeanArray.length;
            for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
                JMSServerMBean jMSServerMBean = jMSServerMBeanArray[i];
                if (!this.targetsMatch(jMSServerMBean)) continue;
                this.upgradeServer(jMSServerMBean, n);
                this.setProgress(n * (i + 1));
            }
            this.setProgress(100);
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeServer(JMSServerMBean jMSServerMBean, int n) throws PlugInException {
        this.updateStatus("StoreUpgradePlugIn.msg.UpgradingServer", jMSServerMBean.getName());
        PersistentStoreMBean persistentStoreMBean = jMSServerMBean.getPersistentStore();
        if (persistentStoreMBean == null) {
            this.updateStatus("StoreUpgradePlugIn.msg.NoStore");
            return;
        }
        StoreReader storeReader = null;
        boolean bl = false;
        try {
            this.updateStatus("StoreUpgradePlugIn.msg.OpeningOldStore");
            storeReader = this.openOldStore(persistentStoreMBean);
            if (!storeReader.requiresUpgrade()) {
                this.updateStatus("StoreUpgradePlugIn.msg.NothingToUpgrade");
                return;
            }
            if (storeReader.alreadyUpgraded()) {
                this.updateStatus("StoreUpgradePlugIn.msg.AlreadyUpgraded", jMSServerMBean.getName());
                return;
            }
            this.updateStatus("StoreUpgradePlugIn.msg.OpeningNewStore");
            this.currentNewStore = this.openNewStore(persistentStoreMBean);
            this.updateStatus("StoreUpgradePlugIn.msg.UpgradingData");
            this.updateStatus("StoreUpgradePlugIn.msg.UpgradingDataWait");
            this.performUpgrade(jMSServerMBean.getName(), persistentStoreMBean, storeReader, this.currentNewStore, n);
            this.updateStatus("StoreUpgradePlugIn.msg.UpgradingDataDone");
            bl = true;
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            throw new RuntimeException(throwable);
        }
        finally {
            this.updateStatus("StoreUpgradePlugIn.msg.ClosingStores");
            if (storeReader != null) {
                storeReader.close();
            }
            if (this.currentNewStore != null) {
                try {
                    this.currentNewStore.close();
                }
                catch (PersistentStoreException persistentStoreException) {
                }
                finally {
                    this.currentNewStore = null;
                }
            }
        }
        if (bl && persistentStoreMBean instanceof FileStoreMBean) {
            this.updateStatus("StoreUpgradePlugIn.msg.RenamingFiles");
            this.renameFileStoreFiles((FileStoreMBean)persistentStoreMBean);
        }
    }

    private StoreReader openReader(PersistentStoreMBean persistentStoreMBean) throws JMSException {
        if (persistentStoreMBean instanceof GenericFileStoreMBean) {
            return new FileStoreReader((GenericFileStoreMBean)((Object)persistentStoreMBean), new UpgradeIOBypass());
        }
        if (persistentStoreMBean instanceof JDBCStoreMBean) {
            return new JDBCStoreReader((JDBCStoreMBean)persistentStoreMBean, new UpgradeIOBypass(), this.encryptionService);
        }
        throw new AssertionError((Object)"Invalid store type detected");
    }

    private StoreReader openOldStore(PersistentStoreMBean persistentStoreMBean) throws PlugInException {
        try {
            return this.openReader(persistentStoreMBean);
        }
        catch (JMSException jMSException) {
            throw this.createException("StoreUpgradePlugIn.exc.ErrorOpeningOldStore", jMSException);
        }
    }

    private PersistentStoreXA openNewStore(PersistentStoreMBean persistentStoreMBean) throws PlugInException {
        String string = NEW_FILE_NAME_PREFIX + persistentStoreMBean.getName();
        try {
            PersistentStoreXA persistentStoreXA;
            Object object;
            if (persistentStoreMBean instanceof GenericFileStoreMBean) {
                object = ((GenericFileStoreMBean)((Object)persistentStoreMBean)).getDirectory();
                object = FileAdminHandler.canonicalizeDirectoryName((String)object);
                persistentStoreXA = PersistentStoreManagerXA.makeXAStore((String)string, (String)object, null, (boolean)true, null);
            } else if (persistentStoreMBean instanceof JDBCStoreMBean) {
                persistentStoreXA = JDBCAdminHandler.makeStore(string, null, (JDBCStoreMBean)persistentStoreMBean, this.encryptionService, null);
            } else {
                throw new AssertionError((Object)"Invalid store type detected");
            }
            object = new HashMap();
            ((HashMap)object).put("SynchronousWritePolicy", StoreWritePolicy.DISABLED);
            persistentStoreXA.open((HashMap)object);
            return persistentStoreXA;
        }
        catch (PersistentStoreException persistentStoreException) {
            throw this.createException("StoreUpgradePlugIn.exc.ErrorOpeningNewStore", persistentStoreException);
        }
    }

    private void performUpgrade(String string, PersistentStoreMBean persistentStoreMBean, StoreReader storeReader, PersistentStoreXA persistentStoreXA, int n) throws PlugInException {
        try {
            Object object;
            PersistentStoreConnection persistentStoreConnection = persistentStoreXA.createConnection(UPGRADE_CONNECTION_NAME);
            PersistentStoreConnection.Cursor cursor = persistentStoreConnection.createCursor(0);
            PersistentStoreRecord persistentStoreRecord = cursor.next();
            if (persistentStoreRecord != null) {
                object = (String)persistentStoreRecord.getData();
                if (((String)object).equals(UPGRADE_DONE_INDICATOR)) {
                    this.updateStatus("StoreUpgradePlugIn.msg.AlreadyUpgraded", string);
                    return;
                }
                if (((String)object).equals(UPGRADE_START_INDICATOR)) {
                    try {
                        this.updateStatus("StoreUpgradePlugIn.msg.ReUpgradingPartiallyUpgraded", string);
                        this.currentNewStore = null;
                        persistentStoreXA.close();
                        this.cleanupNewStore(persistentStoreMBean);
                        this.currentNewStore = persistentStoreXA = this.openNewStore(persistentStoreMBean);
                        persistentStoreConnection = persistentStoreXA.createConnection(UPGRADE_CONNECTION_NAME);
                    }
                    catch (PersistentStoreException persistentStoreException) {
                        throw this.createException("StoreUpgradePlugIn.exc.ReUpgradingError", string);
                    }
                }
            }
            object = persistentStoreXA.begin();
            PersistentHandle persistentHandle = persistentStoreConnection.create((PersistentStoreTransaction)object, (Object)UPGRADE_START_INDICATOR, 0);
            object.commit();
            PersistenceImpl persistenceImpl = new PersistenceImpl(string, persistentStoreXA, (ObjectHandler)new JMSObjectHandler());
            persistenceImpl.open();
            BEDurableSubscriptionStore bEDurableSubscriptionStore = new BEDurableSubscriptionStore(string, persistentStoreXA);
            String string2 = "JMS_" + persistentStoreMBean.getName();
            JMSStoreUpgradeProcessor jMSStoreUpgradeProcessor = new JMSStoreUpgradeProcessor(this, string, string2, storeReader, persistentStoreXA, persistenceImpl, bEDurableSubscriptionStore, new UpgradeIOBypass());
            jMSStoreUpgradeProcessor.upgrade(n);
            try {
                persistentStoreMBean.setXAResourceName(string2);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                // empty catch block
            }
            object = persistentStoreXA.begin();
            persistentStoreConnection.delete((PersistentStoreTransaction)object, persistentHandle, 0);
            persistentStoreConnection.create((PersistentStoreTransaction)object, (Object)UPGRADE_DONE_INDICATOR, 0);
            persistenceImpl.close();
            object.commit();
        }
        catch (JMSException jMSException) {
            throw this.createException("StoreUpgradePlugIn.exc.UpgradeError", jMSException);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw this.createException("StoreUpgradePlugIn.exc.UpgradeError", persistentStoreException);
        }
        catch (KernelException kernelException) {
            throw this.createException("StoreUpgradePlugIn.exc.UpgradeError", kernelException);
        }
    }

    private void renameFileStoreFiles(FileStoreMBean fileStoreMBean) throws PlugInException {
        String string = FileAdminHandler.canonicalizeDirectoryName(fileStoreMBean.getDirectory());
        StoreDir storeDir = new StoreDir(string, fileStoreMBean.getName(), "dat");
        try {
            storeDir.changePrefix(OLD_FILE_NAME_PREFIX + fileStoreMBean.getName());
        }
        catch (IOException iOException) {
            throw this.createException("StoreUpgradePlugIn.exc.RenamingError", iOException);
        }
        StoreDir storeDir2 = new StoreDir(string, NEW_FILE_NAME_PREFIX + fileStoreMBean.getName(), "dat");
        try {
            storeDir2.changePrefix(fileStoreMBean.getName());
        }
        catch (IOException iOException) {
            throw this.createException("StoreUpgradePlugIn.exc.RenamingError", iOException);
        }
    }

    private void cleanupNewStore(PersistentStoreMBean persistentStoreMBean) throws PlugInException {
        if (persistentStoreMBean instanceof GenericFileStoreMBean) {
            this.cleanupNewFileStore((GenericFileStoreMBean)((Object)persistentStoreMBean));
        } else if (persistentStoreMBean instanceof JDBCStoreMBean) {
            this.cleanupNewJDBCStore((JDBCStoreMBean)persistentStoreMBean);
        }
    }

    private void cleanupNewFileStore(GenericFileStoreMBean genericFileStoreMBean) throws PlugInException {
        try {
            String string = genericFileStoreMBean.getDirectory();
            string = FileAdminHandler.canonicalizeDirectoryName(string);
            String string2 = NEW_FILE_NAME_PREFIX + genericFileStoreMBean.getName();
            StoreDir storeDir = new StoreDir(string, string2, "dat");
            storeDir.deleteFiles();
        }
        catch (IOException iOException) {
            throw this.createException("StoreUpgradePlugIn.exc.DeletingPartialUpgradeFilesError", iOException);
        }
    }

    private void cleanupNewJDBCStore(JDBCStoreMBean jDBCStoreMBean) throws PlugInException {
        String string = NEW_FILE_NAME_PREFIX + jDBCStoreMBean.getName();
        try {
            JDBCAdminHandler.deleteStore(string, jDBCStoreMBean, this.encryptionService);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw this.createException("StoreUpgradePlugIn.exc.DeletingPartialUpgradeDBTableError", persistentStoreException);
        }
    }

    private void log(String string) {
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), string + ""));
    }

    private void updateStatus(String string) {
        this.log(UpgradeHelper.i18n(string));
    }

    private void updateStatus(String string, Object object) {
        this.log(UpgradeHelper.i18n(string, object));
    }

    private PlugInException createException(String string) {
        String string2 = UpgradeHelper.i18n(string);
        this.log(string2);
        return new PlugInException(this.getName(), string2);
    }

    private PlugInException createException(String string, Object object) {
        String string2 = UpgradeHelper.i18n(string, object);
        this.log(string2);
        return new PlugInException(this.getName(), string2);
    }

    private PlugInException createException(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UpgradeHelper.i18n(string));
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuffer.append(": ");
            stringBuffer.append(throwable2.toString());
        }
        this.log(stringBuffer.toString());
        PlugInException plugInException = new PlugInException(this.getName(), stringBuffer.toString());
        if (throwable != null) {
            plugInException.initCause(throwable);
        }
        return plugInException;
    }

    void setProgress(int n) {
        if (this.progress == null) {
            this.progress = new PlugInProgressObservation(this.getName());
        }
        this.progress.setProgress(n);
        this.updateObservers((PlugInObservation)this.progress);
    }

    void incrementProgress(int n) {
        if (this.progress != null) {
            this.progress.incrementProgress(n);
            this.updateObservers((PlugInObservation)this.progress);
        }
    }

    DomainMBean getDomainBean() {
        return this.domainBean;
    }
}

