/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.upgrade.jms.UpgradeConsumer;

public class UpgradeDistConsumer
extends UpgradeConsumer {
    static final long serialVersionUID = 8321229324831192400L;
    private static final int EXTVERSION = 1;
    private static final int HAS_NAME = 2;
    private static final int VERSION_MASK = 13;
    private String remotePhysicalTopicName;

    public final String getRemotePhysicalTopicName() {
        return this.remotePhysicalTopicName;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        throw new AssertionError((Object)"writeExternal must not be called on upgrade objects");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        int n2 = n & 0xD;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        if ((n & 2) != 0) {
            this.remotePhysicalTopicName = objectInput.readUTF();
        }
    }
}

