/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSUtilities;
import weblogic.upgrade.jms.UpgradeConsumer;
import weblogic.upgrade.jms.UpgradeXAXid;

public class UpgradeDurableTopicMessageInfo
implements Externalizable {
    private static final byte EXTVERSION = 4;
    static final long serialVersionUID = -17931833902731539L;
    private JMSMessageId messageId;
    private HashMap receiveTrans;
    private byte[] hasMessageSlots;
    private byte[] redeliveredSlots;
    private int consumerCount;
    private int pageCount;
    private boolean isMessageExpired;
    private boolean isMoveMessageOperation;
    private long generation;

    private static final int roundUp8(int n) {
        return n + 8 - 1 & 0xFFFFFFF8;
    }

    void setMessageId(JMSMessageId jMSMessageId) {
        this.messageId = jMSMessageId;
    }

    public JMSMessageId getMessageId() {
        return this.messageId;
    }

    long getGeneration() {
        return this.generation;
    }

    boolean isOlderThanConsumer(UpgradeConsumer upgradeConsumer) {
        return upgradeConsumer.getDurableSlot() >= this.hasMessageSlots.length << 3 || this.messageId.compareTime(upgradeConsumer.getTimestampId()) < 0;
    }

    int getNextOccupiedSlot(int n) {
        int n2 = this.hasMessageSlots.length << 3;
        while (++n < n2) {
            if ((this.hasMessageSlots[n >> 3] & 1 << (n & 7)) == 0) continue;
            return n;
        }
        return -1;
    }

    boolean isRedelivered(UpgradeConsumer upgradeConsumer) {
        if (this.redeliveredSlots == null) {
            return false;
        }
        int n = upgradeConsumer.getDurableSlot();
        return (this.redeliveredSlots[n >> 3] & 1 << (n & 7)) != 0;
    }

    UpgradeXAXid getReceiveTran(UpgradeConsumer upgradeConsumer) {
        if (this.receiveTrans == null) {
            return null;
        }
        return (UpgradeXAXid)this.receiveTrans.get(upgradeConsumer.getDurableSlot());
    }

    public void migrateConsumer(int n, boolean bl) {
        ++this.consumerCount;
        int n2 = n >> 3;
        this.hasMessageSlots[n2] = (byte)(this.hasMessageSlots[n2] | 1 << (n & 7));
        if (this.redeliveredSlots == null && bl) {
            this.redeliveredSlots = new byte[this.hasMessageSlots.length];
        }
        if (this.redeliveredSlots != null) {
            if (bl) {
                int n3 = n >> 3;
                this.redeliveredSlots[n3] = (byte)(this.redeliveredSlots[n3] | 1 << (n & 7));
            } else {
                int n4 = n >> 3;
                this.redeliveredSlots[n4] = (byte)(this.redeliveredSlots[n4] & ~(1 << (n & 7)));
            }
        }
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) {
        throw new AssertionError((Object)"Can't call writeExternal on an upgrade object");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        byte by = objectInput.readByte();
        if (by != 4) {
            throw JMSUtilities.versionIOException(by, 4, 4);
        }
        this.generation = objectInput.readLong();
        this.messageId = new JMSMessageId();
        this.messageId.readExternal(objectInput);
        this.consumerCount = objectInput.readInt();
        int n2 = objectInput.readInt();
        this.hasMessageSlots = new byte[n2];
        objectInput.readFully(this.hasMessageSlots);
        if (objectInput.readBoolean()) {
            this.redeliveredSlots = new byte[n2];
            objectInput.readFully(this.redeliveredSlots);
        }
        if ((n = objectInput.readInt()) > 0) {
            this.receiveTrans = new HashMap();
        }
        while (n-- > 0) {
            Integer n3 = new Integer(objectInput.readInt());
            UpgradeXAXid upgradeXAXid = new UpgradeXAXid();
            upgradeXAXid.readExternal(objectInput);
            this.receiveTrans.put(n3, upgradeXAXid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        UpgradeDurableTopicMessageInfo upgradeDurableTopicMessageInfo = this;
        synchronized (upgradeDurableTopicMessageInfo) {
            return "(dtmi messageId=" + this.messageId + " generation=" + this.generation + " consumerCount=" + this.consumerCount + "pageCount=" + this.pageCount + ")";
        }
    }
}

