/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSUtilities;

public class UpgradeMoveMessagePendingDeleteRecord
implements Externalizable {
    private static final byte EXTVERSION = 1;
    private static final int QUEUESLOT = -1;
    private static final int ALLTOPICSLOT = -2;
    static final long serialVersionUID = 68783746469679355L;
    private JMSMessageId messageId;
    private int durableConsumerSlot;

    boolean isQueueMessage() {
        return this.durableConsumerSlot == -1;
    }

    boolean appliesToAllConsumers() {
        return this.isQueueMessage() || this.durableConsumerSlot == -2;
    }

    int getSlot() {
        return this.durableConsumerSlot;
    }

    JMSMessageId getMessageId() {
        return this.messageId;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        throw new AssertionError((Object)"Cannot call writeExternal on an upgrade object");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.durableConsumerSlot = objectInput.readInt();
        this.messageId = new JMSMessageId();
        this.messageId.readExternal(objectInput);
    }
}

