/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSUtilities;
import weblogic.upgrade.jms.UpgradeXAXid;

public class UpgradeXATranEntryReceive
implements Externalizable {
    private static final byte EXTVERSION = 3;
    static final long serialVersionUID = -8241869299022940995L;
    private long timeStamp;
    private JMSMessageId recoveredMessageId;
    private UpgradeXAXid recoveredBEXAXid;
    private DestinationImpl recoveredDestination;

    long getTimeStamp() {
        return this.timeStamp;
    }

    JMSMessageId getRecoveredMessageId() {
        return this.recoveredMessageId;
    }

    UpgradeXAXid getRecoveredBEXAXid() {
        return this.recoveredBEXAXid;
    }

    DestinationImpl getRecoveredDestination() {
        return this.recoveredDestination;
    }

    public final void writeExternal(ObjectOutput objectOutput) {
        throw new AssertionError((Object)"Cannot call writeExternal on an upgrade object");
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 3) {
            throw JMSUtilities.versionIOException(by, 3, 3);
        }
        this.recoveredMessageId = new JMSMessageId();
        this.recoveredMessageId.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.recoveredBEXAXid = new UpgradeXAXid();
            this.recoveredBEXAXid.readExternal(objectInput);
        }
        this.recoveredDestination = new DestinationImpl();
        this.recoveredDestination.readExternal(objectInput);
        this.timeStamp = objectInput.readLong();
    }
}

