/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;
import weblogic.jms.common.JMSUtilities;

public final class UpgradeXAXid
implements Xid,
Externalizable {
    private static final byte EXTVERSION = 1;
    static final long serialVersionUID = 68757062319679355L;
    private byte[] gtrid;
    private byte[] bqual;
    private transient int hashCode;
    private int formatId;
    private transient Xid originalXid;

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    Xid getOriginalXid() {
        return this.originalXid;
    }

    public boolean equals(Object object) {
        if (object instanceof UpgradeXAXid) {
            UpgradeXAXid upgradeXAXid = (UpgradeXAXid)object;
            if (upgradeXAXid.gtrid.length == this.gtrid.length) {
                for (int i = 0; i < this.gtrid.length; ++i) {
                    if (upgradeXAXid.gtrid[i] == this.gtrid[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        for (int i = this.gtrid.length - 1; i >= 0; --i) {
            this.hashCode += this.gtrid[i] & 0xFF;
        }
        if (this.hashCode == 0) {
            this.hashCode = 1;
        }
        return this.hashCode;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        throw new AssertionError((Object)"Cannot call writeExternal on an upgrade object");
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.formatId = objectInput.readInt();
        byte by2 = objectInput.readByte();
        if (by2 < 0) {
            throw new IOException("Stream corrupted.");
        }
        this.gtrid = new byte[by2];
        objectInput.readFully(this.gtrid);
        by2 = objectInput.readByte();
        if (by2 < -1) {
            throw new IOException("Stream corrupted.");
        }
        if (by2 > -1) {
            this.bqual = new byte[by2];
            objectInput.readFully(this.bqual);
        }
    }
}

