/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.jta;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import java.io.File;
import java.io.IOException;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.admin.FileAdminHandler;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.transaction.internal.TransactionLogUpgradeHelper;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class JTAUpgradePlugIn
extends AbstractPlugIn {
    private DomainMBean domainBean;
    private String[] serverNames;
    private String domainPath;

    public JTAUpgradePlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
            UpgradeHelper.setupWLSClientLogger(this);
            this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
            if (this.domainBean == null) {
                throw this.createException("JTAUpgradePlugIn.exc.NoBeanTree");
            }
            File file = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
            if (file == null) {
                throw this.createException("JTAUpgradePlugIn.exc.NoDomainDir");
            }
            this.domainPath = file.getPath();
            this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
            if (this.serverNames == null) {
                throw new PlugInException(this.getName(), "The list of server names was not found");
            }
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws PlugInException {
        try {
            UpgradeHelper.setupWLSClientLogger(this);
            ServerMBean[] serverMBeanArray = this.domainBean.getServers();
            if (serverMBeanArray == null || serverMBeanArray.length == 0) {
                this.updateStatus("JTAUpgradePlugIn.msg.NoServersToUpgrade");
                return;
            }
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                ServerMBean serverMBean = serverMBeanArray[i];
                if (this.serverNames != null && !this.targetsMatch(serverMBean)) continue;
                this.upgradeServer(serverMBean);
            }
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeServer(ServerMBean serverMBean) throws PlugInException {
        this.updateStatus("JTAUpgradePlugIn.msg.UpgradingTLOG", serverMBean.getName());
        try {
            FileAdminHandler fileAdminHandler = new FileAdminHandler();
            fileAdminHandler.prepareDefaultStore(serverMBean, true);
            fileAdminHandler.activate(null);
            try {
                PersistentStoreXA persistentStoreXA = fileAdminHandler.getStore();
                TransactionLogUpgradeHelper transactionLogUpgradeHelper = new TransactionLogUpgradeHelper();
                transactionLogUpgradeHelper.attemptUpgrade((PersistentStore)persistentStoreXA, serverMBean.getTransactionLogFilePrefix(), serverMBean.getName(), this.domainPath);
            }
            finally {
                fileAdminHandler.deactivate(null);
                fileAdminHandler.unprepare(null);
            }
        }
        catch (IOException iOException) {
            throw this.createException("JTAUpgradePlugIn.exc.ErrorUpgradingLog", iOException);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw this.createException("JTAUpgradePlugIn.exc.ErrorUpgradingLog", persistentStoreException);
        }
        catch (DeploymentException deploymentException) {
            throw this.createException("JTAUpgradePlugIn.exc.ErrorUpgradingLog", (Throwable)((Object)deploymentException));
        }
        catch (UndeploymentException undeploymentException) {
            throw this.createException("JTAUpgradePlugIn.exc.ErrorUpgradingLog", (Throwable)((Object)undeploymentException));
        }
    }

    private boolean targetsMatch(ServerMBean serverMBean) {
        for (int i = 0; i < this.serverNames.length; ++i) {
            if (!serverMBean.getName().equals(this.serverNames[i])) continue;
            return true;
        }
        return false;
    }

    private void log(String string) {
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), string));
    }

    private void updateStatus(String string) {
        this.log(UpgradeHelper.i18n(string));
    }

    private void updateStatus(String string, Object object) {
        this.log(UpgradeHelper.i18n(string, object));
    }

    private PlugInException createException(String string) {
        String string2 = UpgradeHelper.i18n(string);
        this.log(string2);
        return new PlugInException(this.getName(), string2);
    }

    private PlugInException createException(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UpgradeHelper.i18n(string));
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuffer.append(": ");
            stringBuffer.append(throwable2.toString());
        }
        this.log(stringBuffer.toString());
        PlugInException plugInException = new PlugInException(this.getName(), stringBuffer.toString());
        if (throwable != null) {
            plugInException.initCause(throwable);
        }
        return plugInException;
    }
}

