/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.nodemanager;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.DefaultFileSelectionInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import weblogic.nodemanager.server.Upgrader;
import weblogic.upgrade.UpgradeHelper;
import weblogic.utils.FileUtils;

public class NodeManagerPlugIn
extends AbstractPlugIn {
    private static final String NODE_MANAGER_HOME_KEY = "NodeManagerPlugin.NODE_MANAGER_HOME";

    public NodeManagerPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        File file = (File)this._context.get((Object)NODE_MANAGER_HOME_KEY);
        if (file == null) {
            file = new File(".");
        }
        DefaultFileSelectionInputAdapter defaultFileSelectionInputAdapter = (DefaultFileSelectionInputAdapter)this._adapter;
        defaultFileSelectionInputAdapter.setSelectionMode(1);
        defaultFileSelectionInputAdapter.setMultipleSelection(false);
        defaultFileSelectionInputAdapter.setSelectedFileNames(new String[]{file.getPath()});
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        DefaultFileSelectionInputAdapter defaultFileSelectionInputAdapter = (DefaultFileSelectionInputAdapter)this._adapter;
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        if (validationStatus.isValid()) {
            File file = defaultFileSelectionInputAdapter.getSelectedFiles()[0];
            if (!file.isDirectory()) {
                validationStatus.setErrorMessage(UpgradeHelper.i18n("NodeManagerPlugIn.IA.input.invalid.text"));
                validationStatus.setValid(false);
            }
            this._context.put((Object)NODE_MANAGER_HOME_KEY, (Object)file);
        }
        return validationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws PlugInException {
        File file = (File)this._context.get((Object)NODE_MANAGER_HOME_KEY);
        ZipOutputStream zipOutputStream = null;
        File file2 = null;
        try {
            UpgradeHelper.setupWLSClientLogger(this);
            UpgradeHelper.addSummaryMessageForOutputLocation(this._context, this.getName());
            file = file.getAbsoluteFile().getCanonicalFile();
            this.log(UpgradeHelper.i18n("NodeManagerPlugIn.execute.upgrading_node_manager_dir", file));
            Upgrader.upgrade(file, true);
            this.log(UpgradeHelper.i18n("NodeManagerPlugIn.execute.archiving_old_state_files"));
            file2 = new File(file, "weblogic-nodemanager-backup.zip");
            String string = file.getPath().replace(File.separatorChar, '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            int n = string.length();
            file2.createNewFile();
            file2 = file2.getAbsoluteFile().getCanonicalFile();
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            DDBPFileFilter dDBPFileFilter = new DDBPFileFilter();
            ArrayList arrayList = new ArrayList();
            UpgradeHelper.listFiles(file, true, dDBPFileFilter, arrayList);
            File file3 = null;
            byte[] byArray = new byte[1024];
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                file3 = (File)arrayList.get(i);
                FileInputStream fileInputStream = null;
                String string2 = file3.getPath().replace(File.separatorChar, '/').substring(n);
                try {
                    fileInputStream = new FileInputStream(file3);
                    ZipEntry zipEntry = new ZipEntry(string2);
                    zipOutputStream.putNextEntry(zipEntry);
                    int n3 = 0;
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n3);
                    }
                    zipOutputStream.closeEntry();
                }
                catch (IOException iOException) {
                    try {
                        this.log(UpgradeHelper.i18n("plugin.exception_adding_file_to_zip", iOException, string2));
                    }
                    catch (Throwable throwable) {
                        UpgradeHelper.close(fileInputStream);
                        throw throwable;
                    }
                    UpgradeHelper.close(fileInputStream);
                    continue;
                }
                UpgradeHelper.close(fileInputStream);
                continue;
            }
            this.log(UpgradeHelper.i18n("NodeManagerPlugIn.execute.deleting_old_state_files"));
            this.remove(new File(file, "nodemanager.out"));
            this.remove(new File(file, "NodeManagerClientLogs"));
            this.remove(new File(file, "NodeManagerLogs"));
            this.log(UpgradeHelper.i18n("NodeManagerPlugIn.execute.completed_msg"));
            UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("NodeManagerPlugIn.execute.archived_old_state_files", file2));
        }
        catch (Throwable throwable) {
            try {
                throw new PlugInException(this.getName(), UpgradeHelper.i18n("NodeManagerPlugIn.execute.exception_msg", throwable), throwable);
            }
            catch (Throwable throwable2) {
                UpgradeHelper.close(zipOutputStream);
                UpgradeHelper.setupWLSClientLogger(null);
                throw throwable2;
            }
        }
        UpgradeHelper.close(zipOutputStream);
        UpgradeHelper.setupWLSClientLogger(null);
    }

    private void remove(File file) {
        if (file.exists()) {
            FileUtils.remove((File)file);
        }
    }

    private void log(String string) {
        PlugInMessageObservation plugInMessageObservation = new PlugInMessageObservation(this.getName());
        plugInMessageObservation.setMessage(string);
        this.updateObservers((PlugInObservation)plugInMessageObservation);
    }

    private class DDBPFileFilter
    implements FileFilter {
        private DDBPFileFilter() {
        }

        public boolean accept(File file) {
            File file2 = (File)NodeManagerPlugIn.this._context.get((Object)NodeManagerPlugIn.NODE_MANAGER_HOME_KEY);
            if (file2.equals(file.getParentFile())) {
                return file.isFile() && file.getName().equals("nodemanager.out") || file.isDirectory() && file.getName().equals("NodeManagerClientLogs") || file.isDirectory() && file.getName().equals("NodeManagerLogs");
            }
            return true;
        }
    }
}

