/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.singleton;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.DefaultCompositeInputAdapter;
import com.bea.plateng.plugin.ia.DefaultTextInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.management.InvalidAttributeValueException;
import weblogic.cluster.singleton.ConfigMigrationProcessor;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.UpdateException;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.utils.Debug;

public class MigratableServersJDBCConfigPlugIn
extends AbstractPlugIn {
    private static final String MACHINE_CONST = "_Machine";
    private DomainMBean domain;
    private String userNameAsString;
    private String passwordAsString;
    private String urlAsString;
    private String driverNameAsString;
    private String propertiesAsString;
    private boolean domainHasMigratableServers = false;
    private final ArrayList machineNameList = new ArrayList();
    private final ArrayList listenAddressList = new ArrayList();
    private final ArrayList listenPortList = new ArrayList();
    private final ArrayList nmTypeList = new ArrayList();
    private DefaultTextInputAdapter userName;
    private DefaultTextInputAdapter password;
    private DefaultTextInputAdapter url;
    private DefaultTextInputAdapter driverName;
    private DefaultTextInputAdapter properties;
    private final ArrayList nameAdapters = new ArrayList();
    private final ArrayList listenAddrAdapters = new ArrayList();
    private final ArrayList listenPortAdapters = new ArrayList();
    private final ArrayList nmTypeAdapters = new ArrayList();
    private HashSet set = new HashSet();

    public MigratableServersJDBCConfigPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public InputAdapter getInputAdapter() {
        if (!this.domainHasMigratableServers) {
            return null;
        }
        try {
            DefaultCompositeInputAdapter defaultCompositeInputAdapter = UpgradeHelper.createCompositeIA(this.getName(), "compIA");
            this.userName = UpgradeHelper.createTextIA(this.getName(), "TextIA");
            this.userName.setPrompt(UpgradeHelper.i18n(this.getName() + "." + this.userName.getName() + ".input.prompt.text"));
            defaultCompositeInputAdapter.add((InputAdapter)this.userName);
            this.password = UpgradeHelper.createTextIA(this.getName(), "TextIB");
            this.password.setPrompt(UpgradeHelper.i18n(this.getName() + "." + this.password.getName() + ".input.prompt.text"));
            defaultCompositeInputAdapter.add((InputAdapter)this.password);
            this.url = UpgradeHelper.createTextIA(this.getName(), "TextIC");
            defaultCompositeInputAdapter.add((InputAdapter)this.url);
            this.url.setValue("");
            this.url.setPrompt(UpgradeHelper.i18n(this.getName() + "." + this.url.getName() + ".input.prompt.text"));
            this.driverName = UpgradeHelper.createTextIA(this.getName(), "TextID");
            this.driverName.setValue("weblogic.jdbc.oracle.OracleDriver");
            this.driverName.setPrompt(UpgradeHelper.i18n(this.getName() + "." + this.driverName.getName() + ".input.prompt.text"));
            defaultCompositeInputAdapter.add((InputAdapter)this.driverName);
            this.properties = UpgradeHelper.createTextIA(this.getName(), "TextIE");
            this.properties.setValue("");
            this.properties.setPrompt(UpgradeHelper.i18n(this.getName() + "." + this.properties.getName() + ".input.prompt.text"));
            defaultCompositeInputAdapter.add((InputAdapter)this.properties);
            Debug.assertion((this.domain != null ? 1 : 0) != 0, (String)"Domain cannot be null");
            MigratableTargetMBean[] migratableTargetMBeanArray = this.domain.getMigratableTargets();
            for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
                ServerMBean serverMBean = migratableTargetMBeanArray[i].getUserPreferredServer();
                if (this.set.contains(serverMBean)) continue;
                this.set.add(serverMBean);
                if (serverMBean.getMachine() != null) continue;
                this.promptMachineConfig(serverMBean, defaultCompositeInputAdapter);
            }
            return defaultCompositeInputAdapter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AssertionError((Object)("Unexpected exception" + exception));
        }
    }

    private void promptMachineConfig(ServerMBean serverMBean, DefaultCompositeInputAdapter defaultCompositeInputAdapter) throws Exception {
        DefaultTextInputAdapter defaultTextInputAdapter = null;
        defaultTextInputAdapter = UpgradeHelper.createTextIA(this.getName(), serverMBean.getName() + MACHINE_CONST);
        defaultTextInputAdapter.setValue(serverMBean.getName() + "Machine");
        defaultTextInputAdapter.setPrompt(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.msg.machinename", serverMBean.getName()));
        defaultCompositeInputAdapter.add((InputAdapter)defaultTextInputAdapter);
        this.nameAdapters.add(defaultTextInputAdapter);
        DefaultTextInputAdapter defaultTextInputAdapter2 = UpgradeHelper.createTextIA(this.getName(), serverMBean.getName() + "_ListenAddress");
        defaultTextInputAdapter2.setValue("localhost");
        defaultTextInputAdapter2.setPrompt(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.msg.machinelistenaddress", serverMBean.getName()));
        defaultCompositeInputAdapter.add((InputAdapter)defaultTextInputAdapter2);
        this.listenAddrAdapters.add(defaultTextInputAdapter2);
        DefaultTextInputAdapter defaultTextInputAdapter3 = UpgradeHelper.createTextIA(this.getName(), serverMBean.getName() + "_ListenPort");
        defaultTextInputAdapter3.setValue("5556");
        defaultTextInputAdapter3.setPrompt(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.msg.machinelistenport", serverMBean.getName()));
        defaultCompositeInputAdapter.add((InputAdapter)defaultTextInputAdapter3);
        this.listenPortAdapters.add(defaultTextInputAdapter3);
        DefaultTextInputAdapter defaultTextInputAdapter4 = UpgradeHelper.createTextIA(this.getName(), serverMBean.getName() + "_NMType");
        defaultTextInputAdapter4.setPrompt(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.msg.nmtype"));
        defaultCompositeInputAdapter.add((InputAdapter)defaultTextInputAdapter4);
        this.nmTypeAdapters.add(defaultTextInputAdapter4);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        this.domain = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domain == null) {
            throw new PlugInException(this.getName(), "Failed to find domain mbean tree");
        }
        this.domainHasMigratableServers = MigratableServersJDBCConfigPlugIn.doesDomainHaveMigratableServers(this.domain);
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        if (this.domainHasMigratableServers) {
            DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)inputAdapter;
            this.userName = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIA");
            this.password = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIB");
            this.url = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIC");
            this.driverName = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextID");
            this.properties = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIE");
            if (validationStatus.isValid()) {
                this.validateInputValues(validationStatus);
            }
        }
        return validationStatus;
    }

    private boolean areJDBCConfigurationInputValuesValid(ValidationStatus validationStatus) {
        if (this.userNameAsString.length() == 0) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.IA.input.username.text"));
            validationStatus.setValid(false);
            return false;
        }
        if (this.passwordAsString.length() == 0) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.IB.input.password.text"));
            validationStatus.setValid(false);
            return false;
        }
        if (this.urlAsString.length() == 0) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.IC.input.url.text"));
            validationStatus.setValid(false);
            return false;
        }
        if (this.driverNameAsString.length() == 0) {
            validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.ID.input.driver.text"));
            validationStatus.setValid(false);
            return false;
        }
        return true;
    }

    private boolean areMachineAttributesCorrect(ValidationStatus validationStatus) {
        DefaultTextInputAdapter defaultTextInputAdapter;
        int n;
        for (n = 0; n < this.nameAdapters.size(); ++n) {
            defaultTextInputAdapter = (DefaultTextInputAdapter)this.nameAdapters.get(n);
            if (defaultTextInputAdapter.getValue().length() == 0) {
                validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.IE.input.machinename.text"));
                validationStatus.setValid(false);
                return false;
            }
            this.machineNameList.add(defaultTextInputAdapter.getValue());
        }
        for (n = 0; n < this.listenAddrAdapters.size(); ++n) {
            defaultTextInputAdapter = (DefaultTextInputAdapter)this.listenAddrAdapters.get(n);
            if (defaultTextInputAdapter.getValue().length() == 0) {
                validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.IF.input.machinelistenaddress.text"));
                validationStatus.setValid(false);
                return false;
            }
            this.listenAddressList.add(defaultTextInputAdapter.getValue());
        }
        for (n = 0; n < this.listenPortAdapters.size(); ++n) {
            defaultTextInputAdapter = (DefaultTextInputAdapter)this.listenPortAdapters.get(n);
            if (defaultTextInputAdapter.getValue().length() == 0) {
                validationStatus.setErrorMessage(UpgradeHelper.i18n("MigratableServersJDBCConfigPlugIn.IG.input.machinelistenport.text"));
                validationStatus.setValid(false);
                return false;
            }
            this.listenPortList.add(defaultTextInputAdapter.getValue());
        }
        for (n = 0; n < this.nmTypeAdapters.size(); ++n) {
            defaultTextInputAdapter = (DefaultTextInputAdapter)this.nmTypeAdapters.get(n);
            if (defaultTextInputAdapter.getValue().length() == 0) {
                this.nmTypeList.add("");
                continue;
            }
            this.nmTypeList.add(defaultTextInputAdapter.getValue());
        }
        return true;
    }

    private void validateInputValues(ValidationStatus validationStatus) {
        this.userNameAsString = this.userName.getValue();
        this.passwordAsString = this.password.getValue();
        this.urlAsString = this.url.getValue();
        this.driverNameAsString = this.driverName.getValue();
        this.propertiesAsString = this.properties.getValue();
        if (!this.areJDBCConfigurationInputValuesValid(validationStatus)) {
            return;
        }
        if (!this.areMachineAttributesCorrect(validationStatus)) {
            return;
        }
    }

    public void execute() throws PlugInException {
        if (!this.domainHasMigratableServers) {
            return;
        }
        ConfigMigrationProcessor configMigrationProcessor = ConfigMigrationProcessor.getInstance();
        try {
            configMigrationProcessor.updateConfiguration(this.domain);
            configMigrationProcessor.setConnectionPoolProperties(this.userNameAsString, this.passwordAsString, this.urlAsString, this.driverNameAsString, this.propertiesAsString, this.domain);
            int n = this.machineNameList.size();
            for (int i = 0; i < n; ++i) {
                String string = ((DefaultTextInputAdapter)this.nameAdapters.get(i)).getName();
                String string2 = string.substring(0, string.indexOf(MACHINE_CONST));
                configMigrationProcessor.createMachine(this.domain, (String)this.machineNameList.get(i), (String)this.listenAddressList.get(i), (String)this.listenPortList.get(i), (String)this.nmTypeList.get(i), string2);
            }
            configMigrationProcessor.setCandidateMachinesForAutomaticMigration(this.domain);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            invalidAttributeValueException.printStackTrace();
        }
        catch (UpdateException updateException) {
            updateException.printStackTrace();
        }
        catch (DistributedManagementException distributedManagementException) {
            distributedManagementException.printStackTrace();
        }
    }

    public static boolean doesDomainHaveMigratableServers(DomainMBean domainMBean) {
        boolean bl = false;
        MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
        if (migratableTargetMBeanArray.length > 0) {
            ServerMBean[] serverMBeanArray = domainMBean.getServers();
            for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
                if (MigratableServersJDBCConfigPlugIn.isDefaultMigratableTarget(serverMBeanArray, migratableTargetMBeanArray[i].getName())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static boolean isDefaultMigratableTarget(ServerMBean[] serverMBeanArray, String string) {
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            String string2 = serverMBeanArray[i].getName() + " (migratable)";
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

