/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.application;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WarDetector {
    instance;

    private final Set<String> suffixes = new HashSet<String>(Arrays.asList(".war"));
    private final Set<String> markers = new HashSet<String>(Arrays.asList("WEB-INF" + File.separator + "web.xml"));

    public void addSuffix(String string) {
        this.suffixes.add(string);
    }

    public void addExplodedApplicationMarker(String string) {
        this.markers.add(string);
    }

    public String[] getSuffixes() {
        return this.suffixes.toArray(new String[0]);
    }

    public boolean suffixed(String string) {
        for (String string2 : this.suffixes) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public String stem(String string) {
        for (String string2 : this.suffixes) {
            if (!string.endsWith(string2)) continue;
            return string.substring(0, string.indexOf(string2));
        }
        return string;
    }

    public boolean isWar(File file) {
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string : stringArray = this.markers.toArray(new String[0])) {
                if (!new File(file, string).exists()) continue;
                return true;
            }
            if (this.suffixed(file.getName())) {
                return true;
            }
        }
        return this.suffixed(file.getName().toLowerCase());
    }
}

