/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.server.ServiceActivator;
import weblogic.t3.srvr.ServerServices;
import weblogic.utils.StringUtils;

public class version {
    private static final String VERBOSE = "-verbose";
    private static final String WLS_TITLE = "WebLogic Server";
    private static PackageInfo WLS_PACKAGEINFO = null;

    private static VersionInfo getVersionInfo() {
        return VersionInfoFactory.getVersionInfo();
    }

    public static String getBuildVersion() {
        return version.getVersionInfo().getImplementationTitle();
    }

    public static String getReleaseBuildVersion() {
        return version.getVersionInfo().getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        VersionInfoFactory.initialize(true);
        boolean bl = stringArray != null && stringArray.length >= 1 && VERBOSE.equalsIgnoreCase(stringArray[0]);
        try {
            System.out.println("\n" + version.getVersions(bl));
            if (bl) {
                System.out.println("\n" + version.getServiceVersions());
            } else {
                System.out.println("\nUse 'weblogic.version -verbose' to get subsystem information");
                System.out.println("\nUse 'weblogic.utils.Versions' to get version information for all modules");
            }
            System.out.flush();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public static String getVersions() {
        return version.getVersions(false);
    }

    private static String getVersions(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        PackageInfo[] packageInfoArray = version.getVersionInfo().getPackages();
        int n = packageInfoArray.length;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            String string = packageInfoArray[i].getImplementationTitle();
            if (!bl && !string.startsWith(WLS_TITLE)) continue;
            if (!bl2) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(packageInfoArray[i].getImplementationTitle());
            if (bl) {
                stringBuffer.append(" ImplVersion: " + packageInfoArray[i].getImplementationVersion());
            }
            bl2 = false;
        }
        return stringBuffer.toString();
    }

    private static String getServiceVersions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(version.truncate("SERVICE NAME") + "\t" + "VERSION INFORMATION" + "\n");
        stringBuffer.append(version.truncate("============") + "\t" + "===================" + "\n");
        for (int i = 0; i < ServerServices.SERVICE_CLASS_NAMES.length; ++i) {
            String string = ServerServices.SERVICE_CLASS_NAMES[i];
            if (string == "standby_state" || string == "admin_state") continue;
            try {
                Method method;
                Object object;
                String string2 = null;
                String string3 = null;
                Class<?> clazz = Class.forName(string);
                if (ServiceActivator.class.isAssignableFrom(clazz)) {
                    object = clazz.getField("INSTANCE");
                    if (object != null && (method = (ServiceActivator)((Field)object).get(null)) != null) {
                        string2 = method.getName();
                        string3 = method.getVersion();
                    }
                } else {
                    object = clazz.newInstance();
                    method = clazz.getMethod("getVersion", null);
                    string3 = (String)method.invoke(object, (Object[])null);
                    Method method2 = clazz.getMethod("getName", null);
                    string2 = (String)method2.invoke(object, (Object[])null);
                }
                if (string2 == null || string3 == null || string3.trim().length() <= 0) continue;
                stringBuffer.append(version.truncate(string2) + "\t" + string3 + "\n");
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private static String truncate(String string) {
        String string2 = string;
        if (string.length() >= 30) {
            return string.substring(0, 30);
        }
        return StringUtils.padStringWidth((String)string2, (int)30);
    }

    public static String[] getPLInfo() {
        String[] stringArray = new String[2];
        PackageInfo[] packageInfoArray = version.getVersionInfo().getPackages();
        PackageInfo packageInfo = null;
        for (int i = 0; i < packageInfoArray.length; ++i) {
            String string = packageInfoArray[i].getImplementationTitle();
            if (!string.startsWith(WLS_TITLE)) continue;
            WLS_PACKAGEINFO = packageInfo = packageInfoArray[i];
            break;
        }
        stringArray[0] = WLS_TITLE;
        stringArray[1] = "" + packageInfo.getMajor() + "." + packageInfo.getMinor();
        return stringArray;
    }

    public static PackageInfo getWLSPackageInfo() {
        if (WLS_PACKAGEINFO == null) {
            version.getPLInfo();
        }
        return WLS_PACKAGEINFO;
    }

    public static final String getWebServerReleaseInfo() {
        PackageInfo[] packageInfoArray = version.getVersionInfo().getPackages();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        block0: for (int i = 0; i < packageInfoArray.length; ++i) {
            String[] stringArray;
            String string = packageInfoArray[i].getImplementationTitle();
            if (string.indexOf("Server") > 0) {
                stringArray = StringUtils.splitCompletely((String)string);
                StringBuffer stringBuffer3 = new StringBuffer();
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuffer3.append(stringArray[j]);
                    stringBuffer3.append(' ');
                }
                stringBuffer.append(stringBuffer3.toString());
                continue;
            }
            if (string.indexOf("Temporary Patch") <= 0) continue;
            stringArray = StringUtils.splitCompletely((String)string);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].startsWith("CR")) continue;
                stringBuffer2.append(' ');
                stringBuffer2.append(stringArray[j]);
                continue block0;
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("with");
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }
}

