/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import weblogic.application.Deployment;
import weblogic.application.DeploymentManager;
import weblogic.application.utils.EarUtils;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.j2ee.descriptor.wl.ApplicationAdminModeTriggerBean;
import weblogic.management.DeploymentException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.AbstractStuckThreadAction;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerLogger;

final class ApplicationAdminModeAction
extends AbstractStuckThreadAction {
    private final String applicationName;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    ApplicationAdminModeAction(ApplicationAdminModeTriggerBean applicationAdminModeTriggerBean, String string) {
        super((long)applicationAdminModeTriggerBean.getMaxStuckThreadTime(), applicationAdminModeTriggerBean.getStuckThreadCount());
        this.applicationName = string;
        if (this.isDebugEnabled()) {
            this.debug("MaxStuckThreadTime=" + applicationAdminModeTriggerBean.getMaxStuckThreadTime() + ", StuckThreadCount=" + applicationAdminModeTriggerBean.getStuckThreadCount());
        }
    }

    public void execute() {
        final Deployment deployment = DeploymentManager.getDeploymentManager().findDeployment(this.applicationName);
        if (this.isDebugEnabled()) {
            this.debug("executing action for deployment " + deployment);
        }
        assert (deployment != null);
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                try {
                    if (ApplicationAdminModeAction.this.isDebugEnabled()) {
                        ApplicationAdminModeAction.this.debug("invoking forceProductionToAdmin");
                    }
                    DeploymentContextImpl deploymentContextImpl = DeployHelper.createDeploymentContext(null);
                    deploymentContextImpl.setAdminModeTransition(true);
                    deploymentContextImpl.setAdminModeCallback(EarUtils.noopAdminModeCallback);
                    deployment.forceProductionToAdmin(deploymentContextImpl);
                    if (ApplicationAdminModeAction.this.isDebugEnabled()) {
                        ApplicationAdminModeAction.this.debug("forceProductionToAdmin invoked");
                    }
                }
                catch (DeploymentException deploymentException) {
                    deploymentException.printStackTrace();
                }
            }
        });
    }

    public void withdraw() {
        final Deployment deployment = DeploymentManager.getDeploymentManager().findDeployment(this.applicationName);
        if (this.isDebugEnabled()) {
            this.debug("withdraw action for deployment " + deployment);
        }
        assert (deployment != null);
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                try {
                    if (ApplicationAdminModeAction.this.isDebugEnabled()) {
                        ApplicationAdminModeAction.this.debug("invoking adminToProduction");
                    }
                    DeploymentContextImpl deploymentContextImpl = DeployHelper.createDeploymentContext(null);
                    deploymentContextImpl.setAdminModeTransition(false);
                    deployment.adminToProduction(deploymentContextImpl);
                    if (ApplicationAdminModeAction.this.isDebugEnabled()) {
                        ApplicationAdminModeAction.this.debug("adminToProduction invoked");
                    }
                }
                catch (DeploymentException deploymentException) {
                    deploymentException.printStackTrace();
                }
            }
        });
    }

    private void debug(String string) {
        WorkManagerLogger.logDebug((String)("[ApplicationAdminModeAction][" + this.applicationName + "]" + string));
    }
}

