/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.spi.WLSGroup;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.work.FairShareRequestClass;
import weblogic.work.RequestClass;
import weblogic.work.ServiceClassSupport;
import weblogic.work.ServiceClassesStats;

final class ContextRequestClass
extends ServiceClassSupport {
    private static final AbstractSubject kernelId = (AbstractSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String name;
    private RequestClass defaultRequestClass;
    private ConcurrentHashMap groupMap = new ConcurrentHashMap();
    private ConcurrentHashMap usernameMap = new ConcurrentHashMap();
    private final SubjectManager subjectManager = SubjectManager.getSubjectManager();

    public ContextRequestClass(String string) {
        super(string);
        this.name = string;
        this.defaultRequestClass = new FairShareRequestClass(string);
    }

    public void addUser(String string, RequestClass requestClass) {
        this.usernameMap.put(string, requestClass);
    }

    public void addGroup(String string, RequestClass requestClass) {
        this.groupMap.put(string, requestClass);
    }

    public RequestClass getEffective(AuthenticatedSubject authenticatedSubject) {
        AuthenticatedSubject authenticatedSubject2 = authenticatedSubject;
        if (authenticatedSubject2 == null) {
            authenticatedSubject2 = (AuthenticatedSubject)this.subjectManager.getCurrentSubject(kernelId);
        }
        if (authenticatedSubject2 == null) {
            return this.defaultRequestClass;
        }
        RequestClass requestClass = (RequestClass)this.usernameMap.get(SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject2));
        if (requestClass != null) {
            return requestClass;
        }
        Set set = authenticatedSubject2.getPrincipals();
        if (set == null) {
            return this.defaultRequestClass;
        }
        for (Object e : set) {
            if (!(e instanceof WLSGroup) || (requestClass = (RequestClass)this.groupMap.get(((WLSGroup)e).getName())) == null) continue;
            return requestClass;
        }
        requestClass = (RequestClass)this.groupMap.get("everyone");
        if (requestClass != null) {
            return requestClass;
        }
        return this.defaultRequestClass;
    }

    public String getName() {
        return this.name;
    }

    public void timeElapsed(long l, ServiceClassesStats serviceClassesStats) {
    }

    public void cleanup() {
        super.cleanup();
        this.defaultRequestClass.cleanup();
    }
}

