/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import javax.management.InvalidAttributeValueException;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.work.KernelDelegator;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class ExecuteQueueFactory
extends WorkManagerFactory {
    private static ExecuteQueueFactory SINGLETON;

    private ExecuteQueueFactory() {
    }

    public static synchronized void initialize(KernelMBean kernelMBean) {
        if (SINGLETON != null) {
            return;
        }
        SINGLETON = new ExecuteQueueFactory();
        WorkManagerFactory.set((WorkManagerFactory)SINGLETON);
        SINGLETON.initializeHere(kernelMBean);
    }

    private void initializeHere(KernelMBean kernelMBean) {
        Object object;
        if (kernelMBean != null) {
            object = kernelMBean.getExecuteQueues();
            int n = ((ExecuteQueueMBean[])object).length;
            while (--n >= 0) {
                ExecuteQueueMBean executeQueueMBean = object[n];
                String string = executeQueueMBean.getName();
                if (string.startsWith("wl_bootstrap_")) {
                    string = string.substring(13);
                }
                this.create(string, executeQueueMBean);
            }
        }
        if (this.DEFAULT == null) {
            object = new ExecuteQueueMBeanStub();
            if (kernelMBean != null && kernelMBean.getThreadPoolSize() > 0) {
                try {
                    object.setThreadCount(kernelMBean.getThreadPoolSize());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.create(object.getName(), (ExecuteQueueMBean)object);
        }
        if (Kernel.isServer()) {
            object = new KernelDelegator("weblogic.kernel.Non-Blocking", 3);
            this.byName.put("weblogic.kernel.Non-Blocking", object);
            this.SYSTEM = new KernelDelegator("weblogic.kernel.System", kernelMBean.getSystemThreadPoolSize());
            this.byName.put("weblogic.kernel.System", this.SYSTEM);
            this.REJECTOR = new KernelDelegator("weblogic.Rejector", 2);
        } else {
            this.SYSTEM = this.DEFAULT;
        }
        object = new KernelDelegator();
        this.byName.put("direct", object);
    }

    protected WorkManager create(String string, int n, int n2, int n3) {
        return this.create(string, n2, n3);
    }

    private WorkManager create(String string, int n, int n2) {
        int n3 = Math.max(n2, n);
        return new KernelDelegator(string, n3);
    }

    private WorkManager create(String string, ExecuteQueueMBean executeQueueMBean) {
        KernelDelegator kernelDelegator = new KernelDelegator(string, executeQueueMBean);
        if ("weblogic.kernel.Default".equalsIgnoreCase(string) || "default".equalsIgnoreCase(string)) {
            this.DEFAULT = kernelDelegator;
        } else {
            this.byName.put(string, kernelDelegator);
        }
        return kernelDelegator;
    }

    public static WorkManager createExecuteQueue(String string, int n) {
        ExecuteQueueMBeanStub executeQueueMBeanStub = new ExecuteQueueMBeanStub();
        try {
            executeQueueMBeanStub.setThreadCount(n);
            executeQueueMBeanStub.setThreadsIncrease(0);
            executeQueueMBeanStub.setThreadsMaximum(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)("Invalid ExecuteQueueMBean attributes specified for " + string));
        }
        assert (SINGLETON != null);
        return SINGLETON.create(string, executeQueueMBeanStub);
    }
}

