/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import weblogic.application.ApplicationAccess;
import weblogic.kernel.AuditableThread;
import weblogic.management.runtime.JTATransaction;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.work.ExecuteThread;
import weblogic.work.WorkAdapter;

public final class ExecuteThreadRuntime
implements weblogic.management.runtime.ExecuteThread {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final long serialVersionUID = -5035431251569572684L;
    private final String name;
    private final String currentWork;
    private final String lastRequest;
    private final int servicedRequests;
    private final JTATransaction transaction;
    private final String user;
    private final long startTime;
    private final transient ExecuteThread executeThread;
    private String wmName;
    private String applicationName;
    private String moduleName;
    private String applicationVersion;
    private final boolean standby;
    private final boolean hogger;
    private final boolean stuck;

    public ExecuteThreadRuntime(ExecuteThread executeThread) {
        AuthenticatedSubject authenticatedSubject;
        this.executeThread = executeThread;
        WorkAdapter workAdapter = executeThread.getCurrentWork();
        this.currentWork = workAdapter != null ? workAdapter.toString() : null;
        this.lastRequest = null;
        this.servicedRequests = executeThread.getExecuteCount();
        TransactionManager transactionManager = TxHelper.getTransactionManager();
        this.transaction = transactionManager != null && transactionManager instanceof ServerTransactionManager ? ((ServerTransactionManager)transactionManager).getJTATransactionForThread((AuditableThread)executeThread) : null;
        String string = null;
        try {
            authenticatedSubject = SecurityManager.getCurrentSubject((AuthenticatedSubject)kernelID, (AuditableThread)executeThread);
            if (authenticatedSubject != null) {
                string = SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.user = string;
        this.name = executeThread.getName();
        this.standby = executeThread.isStandby();
        this.startTime = executeThread.getTimeStamp();
        this.hogger = executeThread.isHog();
        this.stuck = executeThread.isStuck();
        try {
            authenticatedSubject = executeThread.getWorkManager();
            this.wmName = authenticatedSubject.getName();
            ClassLoader classLoader = executeThread.getContextClassLoader();
            ApplicationAccess applicationAccess = ApplicationAccess.getApplicationAccess();
            this.applicationName = applicationAccess.getApplicationName(classLoader);
            this.moduleName = applicationAccess.getModuleName(classLoader);
            this.applicationVersion = applicationAccess.getApplicationVersion(classLoader);
        }
        catch (Exception exception) {
            this.wmName = null;
            this.applicationName = null;
            this.moduleName = null;
            this.applicationVersion = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCurrentRequest() {
        return this.currentWork;
    }

    public String getLastRequest() {
        return this.lastRequest;
    }

    public int getServicedRequestTotalCount() {
        return this.servicedRequests;
    }

    public JTATransaction getTransaction() {
        return this.transaction;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isIdle() {
        return this.currentWork == null;
    }

    public boolean isStandby() {
        return this.standby;
    }

    public long getCurrentRequestStartTime() {
        return this.startTime;
    }

    public Thread getExecuteThread() {
        return this.executeThread;
    }

    public String getWorkManagerName() {
        return this.wmName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public boolean isHogger() {
        return this.executeThread != null ? this.executeThread.isHog() : this.hogger;
    }

    public boolean isStuck() {
        return this.executeThread != null ? this.executeThread.isStuck() : this.stuck;
    }
}

