/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import java.util.HashMap;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CapacityMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ContextCaseMBean;
import weblogic.management.configuration.ContextRequestClassMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FairShareRequestClassMBean;
import weblogic.management.configuration.MaxThreadsConstraintMBean;
import weblogic.management.configuration.MinThreadsConstraintMBean;
import weblogic.management.configuration.ResponseTimeRequestClassMBean;
import weblogic.management.configuration.SelfTuningMBean;
import weblogic.management.configuration.ServerFailureTriggerMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WorkManagerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.ContextRequestClass;
import weblogic.work.FairShareRequestClass;
import weblogic.work.FairShareRequestClassBeanUpdateListener;
import weblogic.work.IncrementAdvisor;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MaxThreadsConstraintBeanUpdateListener;
import weblogic.work.MaxThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.MinThreadsConstraintBeanUpdateListener;
import weblogic.work.MinThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.OverloadManager;
import weblogic.work.OverloadManagerBeanUpdateListener;
import weblogic.work.PoolBasedMaxThreadsConstraint;
import weblogic.work.RequestClass;
import weblogic.work.RequestClassRuntimeMBeanImpl;
import weblogic.work.ResponseTimeRequestClass;
import weblogic.work.ResponseTimeRequestClassBeanUpdateListener;
import weblogic.work.ServerFailureAction;
import weblogic.work.WorkManagerLogger;

final class GlobalWorkManagerComponentsFactory {
    private static final DebugCategory debugWM = Debug.getCategory((String)"weblogic.globalworkmanagercomponents");
    private boolean initialized;
    private SelfTuningMBean stmb;
    private ServerRuntimeMBean serverRuntime;
    private final HashMap maxMap = new HashMap();
    private final HashMap minMap = new HashMap();
    private final HashMap overloadMap = new HashMap();
    private final HashMap requestClassMap = new HashMap();
    private final HashMap workManagerTemplateMap = new HashMap();
    private ServerFailureAction serverFailureAction;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    static GlobalWorkManagerComponentsFactory getInstance() {
        return Factory.THE_ONE;
    }

    private GlobalWorkManagerComponentsFactory() {
    }

    synchronized void initialize() throws ManagementException {
        if (this.initialized) {
            return;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.stmb = domainMBean.getSelfTuning();
        this.serverRuntime = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        IncrementAdvisor.setMinThreadPoolSize((int)serverMBean.getSelfTuningThreadPoolSizeMin());
        IncrementAdvisor.setMaxThreadPoolSize((int)serverMBean.getSelfTuningThreadPoolSizeMax());
        ServerFailureTriggerMBean serverFailureTriggerMBean = serverMBean.getOverloadProtection().getServerFailureTrigger();
        if (serverFailureTriggerMBean != null && serverFailureTriggerMBean.getStuckThreadCount() > 0) {
            GlobalWorkManagerComponentsFactory.debug("creating ServerFailureAction with " + serverFailureTriggerMBean.getMaxStuckThreadTime() + " seconds and count of " + serverFailureTriggerMBean.getStuckThreadCount());
            this.serverFailureAction = new ServerFailureAction(serverFailureTriggerMBean);
        }
        this.create(this.stmb.getFairShareRequestClasses());
        this.create(this.stmb.getResponseTimeRequestClasses());
        this.create(this.stmb.getContextRequestClasses());
        this.create(this.stmb.getMaxThreadsConstraints());
        this.create(this.stmb.getMinThreadsConstraints());
        this.create(this.stmb.getCapacities());
        this.create(this.stmb.getWorkManagers());
        this.initialized = true;
    }

    void create(WorkManagerMBean[] workManagerMBeanArray) throws ConfigurationException {
        if (workManagerMBeanArray == null) {
            return;
        }
        for (int i = 0; i < workManagerMBeanArray.length; ++i) {
            String string;
            WorkManagerMBean workManagerMBean = workManagerMBeanArray[i];
            if (!this.isDeployedToThisServer(workManagerMBean) || this.workManagerTemplateMap.get(string = workManagerMBean.getName()) != null) continue;
            WorkManagerTemplate workManagerTemplate = new WorkManagerTemplate(workManagerMBean);
            this.workManagerTemplateMap.put(string, workManagerTemplate);
        }
    }

    void create(FairShareRequestClassMBean[] fairShareRequestClassMBeanArray) throws ManagementException {
        if (fairShareRequestClassMBeanArray == null) {
            return;
        }
        for (int i = 0; i < fairShareRequestClassMBeanArray.length; ++i) {
            FairShareRequestClass fairShareRequestClass;
            FairShareRequestClassMBean fairShareRequestClassMBean = fairShareRequestClassMBeanArray[i];
            if (!this.isDeployedToThisServer(fairShareRequestClassMBean) || (fairShareRequestClass = (FairShareRequestClass)this.getRequestClass(fairShareRequestClassMBean.getName(), FairShareRequestClass.class)) != null) continue;
            this.create(fairShareRequestClassMBean);
        }
    }

    private RequestClass create(FairShareRequestClassMBean fairShareRequestClassMBean) throws ManagementException {
        FairShareRequestClass fairShareRequestClass = new FairShareRequestClass(fairShareRequestClassMBean.getName(), fairShareRequestClassMBean.getFairShare());
        GlobalWorkManagerComponentsFactory.debug("created global fair share RC '" + fairShareRequestClassMBean.getName() + "'");
        fairShareRequestClassMBean.addBeanUpdateListener(new FairShareRequestClassBeanUpdateListener(fairShareRequestClass));
        fairShareRequestClass.setShared(true);
        this.requestClassMap.put(fairShareRequestClassMBean.getName(), fairShareRequestClass);
        this.serverRuntime.addRequestClassRuntime(new RequestClassRuntimeMBeanImpl((RequestClass)fairShareRequestClass));
        return fairShareRequestClass;
    }

    void create(ResponseTimeRequestClassMBean[] responseTimeRequestClassMBeanArray) throws ManagementException {
        if (responseTimeRequestClassMBeanArray == null) {
            return;
        }
        for (int i = 0; i < responseTimeRequestClassMBeanArray.length; ++i) {
            ResponseTimeRequestClass responseTimeRequestClass;
            ResponseTimeRequestClassMBean responseTimeRequestClassMBean = responseTimeRequestClassMBeanArray[i];
            if (!this.isDeployedToThisServer(responseTimeRequestClassMBean) || (responseTimeRequestClass = (ResponseTimeRequestClass)this.getRequestClass(responseTimeRequestClassMBean.getName(), ResponseTimeRequestClass.class)) != null) continue;
            this.create(responseTimeRequestClassMBean);
        }
    }

    private RequestClass create(ResponseTimeRequestClassMBean responseTimeRequestClassMBean) throws ManagementException {
        ResponseTimeRequestClass responseTimeRequestClass = new ResponseTimeRequestClass(responseTimeRequestClassMBean.getName(), responseTimeRequestClassMBean.getGoalMs());
        GlobalWorkManagerComponentsFactory.debug("created global response time RC '" + responseTimeRequestClassMBean.getName() + "'");
        responseTimeRequestClassMBean.addBeanUpdateListener(new ResponseTimeRequestClassBeanUpdateListener(responseTimeRequestClass));
        responseTimeRequestClass.setShared(true);
        this.requestClassMap.put(responseTimeRequestClassMBean.getName(), responseTimeRequestClass);
        this.serverRuntime.addRequestClassRuntime(new RequestClassRuntimeMBeanImpl((RequestClass)responseTimeRequestClass));
        return responseTimeRequestClass;
    }

    void create(ContextRequestClassMBean[] contextRequestClassMBeanArray) throws ConfigurationException {
        if (contextRequestClassMBeanArray == null) {
            return;
        }
        for (int i = 0; i < contextRequestClassMBeanArray.length; ++i) {
            ContextRequestClass contextRequestClass;
            ContextRequestClassMBean contextRequestClassMBean = contextRequestClassMBeanArray[i];
            if (!this.isDeployedToThisServer(contextRequestClassMBean) || (contextRequestClass = (ContextRequestClass)((Object)this.getRequestClass(contextRequestClassMBean.getName(), ContextRequestClass.class))) != null) continue;
            contextRequestClass = this.create(contextRequestClassMBean);
        }
    }

    private ContextRequestClass create(ContextRequestClassMBean contextRequestClassMBean) throws ConfigurationException {
        ContextRequestClass contextRequestClass = new ContextRequestClass(contextRequestClassMBean.getName());
        ContextCaseMBean[] contextCaseMBeanArray = contextRequestClassMBean.getContextCases();
        if (contextCaseMBeanArray != null) {
            for (int i = 0; i < contextCaseMBeanArray.length; ++i) {
                ContextCaseMBean contextCaseMBean = contextCaseMBeanArray[i];
                RequestClass requestClass = this.findPrimitiveRequestClass(contextCaseMBean.getRequestClassName());
                if (requestClass == null) {
                    throw new ConfigurationException("request class for group " + contextCaseMBean.getGroupName() + " not found");
                }
                if (contextCaseMBean.getUserName() != null) {
                    contextRequestClass.addUser(contextCaseMBean.getUserName(), requestClass);
                    continue;
                }
                if (contextCaseMBean.getGroupName() == null) continue;
                contextRequestClass.addGroup(contextCaseMBean.getGroupName(), requestClass);
            }
        }
        GlobalWorkManagerComponentsFactory.debug("created global context RC '" + contextRequestClassMBean.getName() + "'");
        contextRequestClass.setShared(true);
        this.requestClassMap.put(contextRequestClassMBean.getName(), contextRequestClass);
        return contextRequestClass;
    }

    private Object getRequestClass(String string, Class clazz) throws ConfigurationException {
        Object v = this.requestClassMap.get(string);
        if (clazz.isInstance(v)) {
            return v;
        }
        if (v != null) {
            throw new ConfigurationException(string + " request class cannot be " + "created. A request class of a different type already exists with " + "that name");
        }
        return null;
    }

    void create(MaxThreadsConstraintMBean[] maxThreadsConstraintMBeanArray) throws ManagementException {
        if (maxThreadsConstraintMBeanArray == null) {
            return;
        }
        for (int i = 0; i < maxThreadsConstraintMBeanArray.length; ++i) {
            String string;
            MaxThreadsConstraint maxThreadsConstraint;
            MaxThreadsConstraintMBean maxThreadsConstraintMBean = maxThreadsConstraintMBeanArray[i];
            if (!this.isDeployedToThisServer(maxThreadsConstraintMBean) || (maxThreadsConstraint = (MaxThreadsConstraint)this.maxMap.get(maxThreadsConstraintMBean.getName())) != null || (string = maxThreadsConstraintMBean.getConnectionPoolName()) != null && string.trim().length() != 0) continue;
            this.create(maxThreadsConstraintMBean);
        }
    }

    private MaxThreadsConstraint create(MaxThreadsConstraintMBean maxThreadsConstraintMBean) throws ManagementException {
        MaxThreadsConstraint maxThreadsConstraint;
        String string = maxThreadsConstraintMBean.getConnectionPoolName();
        if (string != null && string.trim().length() != 0) {
            maxThreadsConstraint = new PoolBasedMaxThreadsConstraint(maxThreadsConstraintMBean.getName(), maxThreadsConstraintMBean.getConnectionPoolName());
        } else {
            maxThreadsConstraint = new MaxThreadsConstraint(maxThreadsConstraintMBean.getName(), maxThreadsConstraintMBean.getCount());
            maxThreadsConstraintMBean.addBeanUpdateListener(new MaxThreadsConstraintBeanUpdateListener(maxThreadsConstraint));
        }
        GlobalWorkManagerComponentsFactory.debug("created global max threads constraint '" + maxThreadsConstraintMBean.getName() + "'");
        this.maxMap.put(maxThreadsConstraintMBean.getName(), maxThreadsConstraint);
        this.serverRuntime.addMaxThreadsConstraintRuntime(new MaxThreadsConstraintRuntimeMBeanImpl(maxThreadsConstraint));
        return maxThreadsConstraint;
    }

    void create(MinThreadsConstraintMBean[] minThreadsConstraintMBeanArray) throws ManagementException {
        if (minThreadsConstraintMBeanArray == null) {
            return;
        }
        for (int i = 0; i < minThreadsConstraintMBeanArray.length; ++i) {
            MinThreadsConstraint minThreadsConstraint;
            MinThreadsConstraintMBean minThreadsConstraintMBean = minThreadsConstraintMBeanArray[i];
            if (!this.isDeployedToThisServer(minThreadsConstraintMBean) || (minThreadsConstraint = (MinThreadsConstraint)this.minMap.get(minThreadsConstraintMBean.getName())) != null) continue;
            this.create(minThreadsConstraintMBean);
        }
    }

    private MinThreadsConstraint create(MinThreadsConstraintMBean minThreadsConstraintMBean) throws ManagementException {
        MinThreadsConstraint minThreadsConstraint = new MinThreadsConstraint(minThreadsConstraintMBean.getName(), minThreadsConstraintMBean.getCount());
        minThreadsConstraintMBean.addBeanUpdateListener(new MinThreadsConstraintBeanUpdateListener(minThreadsConstraint));
        GlobalWorkManagerComponentsFactory.debug("created global min threads constraint '" + minThreadsConstraintMBean.getName() + "'");
        this.minMap.put(minThreadsConstraintMBean.getName(), minThreadsConstraint);
        this.serverRuntime.addMinThreadsConstraintRuntime(new MinThreadsConstraintRuntimeMBeanImpl(minThreadsConstraint));
        return minThreadsConstraint;
    }

    void create(CapacityMBean[] capacityMBeanArray) {
        if (capacityMBeanArray == null) {
            return;
        }
        for (int i = 0; i < capacityMBeanArray.length; ++i) {
            CapacityMBean capacityMBean = capacityMBeanArray[i];
            if (!this.isDeployedToThisServer(capacityMBean) || this.overloadMap.get(capacityMBean.getName()) != null) continue;
            this.create(capacityMBean);
        }
    }

    private OverloadManager create(CapacityMBean capacityMBean) {
        OverloadManager overloadManager = new OverloadManager(capacityMBean.getName(), capacityMBean.getCount());
        capacityMBean.addBeanUpdateListener(new OverloadManagerBeanUpdateListener(overloadManager));
        this.overloadMap.put(capacityMBean.getName(), overloadManager);
        GlobalWorkManagerComponentsFactory.debug("created global capacity " + capacityMBean.getName() + "' with count " + capacityMBean.getCount());
        return overloadManager;
    }

    synchronized RequestClass findRequestClass(String string) {
        RequestClass requestClass = this.findPrimitiveRequestClass(string);
        if (requestClass != null) {
            return requestClass;
        }
        try {
            ContextRequestClassMBean contextRequestClassMBean = this.stmb.lookupContextRequestClass(string);
            if (contextRequestClassMBean != null && this.isDeployedToThisServer(contextRequestClassMBean)) {
                return this.create(contextRequestClassMBean);
            }
            return null;
        }
        catch (ManagementException managementException) {
            throw new IllegalArgumentException("RequestClassMBean  has invalid attributes", managementException);
        }
    }

    private RequestClass findPrimitiveRequestClass(String string) {
        RequestClass requestClass = (RequestClass)this.requestClassMap.get(string);
        if (requestClass != null) {
            return requestClass;
        }
        try {
            FairShareRequestClassMBean fairShareRequestClassMBean = this.stmb.lookupFairShareRequestClass(string);
            if (fairShareRequestClassMBean != null && this.isDeployedToThisServer(fairShareRequestClassMBean)) {
                return this.create(fairShareRequestClassMBean);
            }
            ResponseTimeRequestClassMBean responseTimeRequestClassMBean = this.stmb.lookupResponseTimeRequestClass(string);
            if (responseTimeRequestClassMBean != null && this.isDeployedToThisServer(responseTimeRequestClassMBean)) {
                return this.create(responseTimeRequestClassMBean);
            }
            return null;
        }
        catch (ManagementException managementException) {
            throw new IllegalArgumentException("RequestClassMBean  has invalid attributes", managementException);
        }
    }

    synchronized MaxThreadsConstraint findMaxThreadsConstraint(String string) {
        MaxThreadsConstraint maxThreadsConstraint = (MaxThreadsConstraint)this.maxMap.get(string);
        if (maxThreadsConstraint != null) {
            return maxThreadsConstraint;
        }
        MaxThreadsConstraintMBean maxThreadsConstraintMBean = this.stmb.lookupMaxThreadsConstraint(string);
        if (maxThreadsConstraintMBean == null || !this.isDeployedToThisServer(maxThreadsConstraintMBean)) {
            return null;
        }
        try {
            return this.create(maxThreadsConstraintMBean);
        }
        catch (ManagementException managementException) {
            throw new IllegalArgumentException("MaxThreadsConstraintMBean '" + maxThreadsConstraintMBean.getName() + "' has invalid attributes", managementException);
        }
    }

    synchronized MinThreadsConstraint findMinThreadsConstraint(String string) {
        MinThreadsConstraint minThreadsConstraint = (MinThreadsConstraint)this.minMap.get(string);
        if (minThreadsConstraint != null) {
            return minThreadsConstraint;
        }
        MinThreadsConstraintMBean minThreadsConstraintMBean = this.stmb.lookupMinThreadsConstraint(string);
        if (minThreadsConstraintMBean == null || !this.isDeployedToThisServer(minThreadsConstraintMBean)) {
            return null;
        }
        try {
            return this.create(minThreadsConstraintMBean);
        }
        catch (ManagementException managementException) {
            throw new IllegalArgumentException("MinThreadsConstraintMBean '" + minThreadsConstraintMBean.getName() + "' has invalid attributes", managementException);
        }
    }

    synchronized OverloadManager findOverloadManager(String string) {
        OverloadManager overloadManager = (OverloadManager)this.overloadMap.get(string);
        if (overloadManager != null) {
            return overloadManager;
        }
        CapacityMBean capacityMBean = this.stmb.lookupCapacity(string);
        if (capacityMBean == null || !this.isDeployedToThisServer(capacityMBean)) {
            return null;
        }
        return this.create(capacityMBean);
    }

    synchronized WorkManagerTemplate removeWorkManagerTemplate(String string) {
        return (WorkManagerTemplate)this.workManagerTemplateMap.remove(string);
    }

    synchronized WorkManagerTemplate findWorkManagerTemplate(WorkManagerMBean workManagerMBean) {
        if (workManagerMBean == null || !"default".equals(workManagerMBean.getName()) && !this.isDeployedToThisServer(workManagerMBean)) {
            return null;
        }
        WorkManagerTemplate workManagerTemplate = (WorkManagerTemplate)this.workManagerTemplateMap.get(workManagerMBean.getName());
        if (workManagerTemplate != null) {
            return workManagerTemplate;
        }
        try {
            workManagerTemplate = new WorkManagerTemplate(workManagerMBean);
            this.workManagerTemplateMap.put(workManagerMBean.getName(), workManagerTemplate);
            return workManagerTemplate;
        }
        catch (ConfigurationException configurationException) {
            throw new IllegalArgumentException("WorkManagerMBean '" + workManagerMBean.getName() + "' has invalid attributes", configurationException);
        }
    }

    ServerFailureAction getServerFailedAction() {
        return this.serverFailureAction;
    }

    private boolean isDeployedToThisServer(DeploymentMBean deploymentMBean) {
        if (deploymentMBean != null) {
            TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
            if (targetMBeanArray == null || targetMBeanArray.length == 0) {
                return true;
            }
            for (TargetMBean targetMBean : targetMBeanArray) {
                if (!targetMBean.getServerNames().contains(this.serverRuntime.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void debug(String string) {
        if (debugWM.isEnabled()) {
            WorkManagerLogger.logDebug((String)("<GlobalWMComponents>" + string));
        }
    }

    final class WorkManagerTemplate {
        private RequestClass requestClass;
        private MaxThreadsConstraint maxThreadsConstraint;
        private MinThreadsConstraint minThreadsConstraint;
        private OverloadManager capacity;

        WorkManagerTemplate(WorkManagerMBean workManagerMBean) throws ConfigurationException {
            this.initRequestClass(workManagerMBean);
            this.initMinThreadsConstraint(workManagerMBean);
            this.initMaxThreadsConstraint(workManagerMBean);
            this.initCapacity(workManagerMBean);
        }

        RequestClass getRequestClass() {
            return this.requestClass;
        }

        MaxThreadsConstraint getMaxThreadsConstraint() {
            return this.maxThreadsConstraint;
        }

        MinThreadsConstraint getMinThreadsConstraint() {
            return this.minThreadsConstraint;
        }

        OverloadManager getCapacity() {
            return this.capacity;
        }

        private void initRequestClass(WorkManagerMBean workManagerMBean) {
            ResponseTimeRequestClassMBean responseTimeRequestClassMBean = workManagerMBean.getResponseTimeRequestClass();
            if (responseTimeRequestClassMBean != null) {
                ResponseTimeRequestClass responseTimeRequestClass = new ResponseTimeRequestClass(responseTimeRequestClassMBean.getName(), responseTimeRequestClassMBean.getGoalMs());
                responseTimeRequestClassMBean.addBeanUpdateListener(new ResponseTimeRequestClassBeanUpdateListener(responseTimeRequestClass));
                GlobalWorkManagerComponentsFactory.debug("created response time RC '" + responseTimeRequestClassMBean.getName() + "' for WorkManagerMBean '" + workManagerMBean.getName() + "'");
                this.requestClass = GlobalWorkManagerComponentsFactory.this.findRequestClass(responseTimeRequestClassMBean.getName());
                return;
            }
            ContextRequestClassMBean contextRequestClassMBean = workManagerMBean.getContextRequestClass();
            if (contextRequestClassMBean != null) {
                GlobalWorkManagerComponentsFactory.debug("created context RC  for WorkManagerMBean '" + workManagerMBean.getName() + "'");
                this.requestClass = GlobalWorkManagerComponentsFactory.this.findRequestClass(contextRequestClassMBean.getName());
                return;
            }
            FairShareRequestClassMBean fairShareRequestClassMBean = workManagerMBean.getFairShareRequestClass();
            if (fairShareRequestClassMBean != null) {
                FairShareRequestClass fairShareRequestClass = new FairShareRequestClass(fairShareRequestClassMBean.getName(), fairShareRequestClassMBean.getFairShare());
                fairShareRequestClassMBean.addBeanUpdateListener(new FairShareRequestClassBeanUpdateListener(fairShareRequestClass));
                GlobalWorkManagerComponentsFactory.debug("created fair share RC '" + fairShareRequestClassMBean.getName() + "' for WorkManagerMBean '" + workManagerMBean.getName() + "'");
                this.requestClass = GlobalWorkManagerComponentsFactory.this.findRequestClass(fairShareRequestClassMBean.getName());
            }
        }

        private void initCapacity(WorkManagerMBean workManagerMBean) {
            CapacityMBean capacityMBean = workManagerMBean.getCapacity();
            if (capacityMBean != null) {
                GlobalWorkManagerComponentsFactory.debug("created capacity '" + capacityMBean.getName() + "' for WorkManagerMBean '" + workManagerMBean.getName() + "'");
                this.capacity = GlobalWorkManagerComponentsFactory.this.findOverloadManager(capacityMBean.getName());
                capacityMBean.addBeanUpdateListener(new OverloadManagerBeanUpdateListener(this.capacity));
            }
        }

        private void initMaxThreadsConstraint(WorkManagerMBean workManagerMBean) {
            MaxThreadsConstraintMBean maxThreadsConstraintMBean = workManagerMBean.getMaxThreadsConstraint();
            if (maxThreadsConstraintMBean != null) {
                GlobalWorkManagerComponentsFactory.debug("created max threads constraint '" + maxThreadsConstraintMBean.getName() + "' for WorkManagerMBean '" + workManagerMBean.getName() + "'");
                this.maxThreadsConstraint = GlobalWorkManagerComponentsFactory.this.findMaxThreadsConstraint(maxThreadsConstraintMBean.getName());
                maxThreadsConstraintMBean.addBeanUpdateListener(new MaxThreadsConstraintBeanUpdateListener(this.maxThreadsConstraint));
            }
        }

        private void initMinThreadsConstraint(WorkManagerMBean workManagerMBean) {
            MinThreadsConstraintMBean minThreadsConstraintMBean = workManagerMBean.getMinThreadsConstraint();
            if (minThreadsConstraintMBean != null) {
                GlobalWorkManagerComponentsFactory.debug("created min threads constraint '" + minThreadsConstraintMBean.getName() + "' for WorkManagerMBean '" + workManagerMBean.getName() + "'");
                this.minThreadsConstraint = GlobalWorkManagerComponentsFactory.this.findMinThreadsConstraint(minThreadsConstraintMBean.getName());
                minThreadsConstraintMBean.addBeanUpdateListener(new MinThreadsConstraintBeanUpdateListener(this.minThreadsConstraint));
            }
        }
    }

    private static final class Factory {
        static final GlobalWorkManagerComponentsFactory THE_ONE = new GlobalWorkManagerComponentsFactory();

        private Factory() {
        }
    }
}

