/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.utils.UnsyncCircularQueue;
import weblogic.utils.collections.WeakConcurrentHashMap;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;

public final class IDBasedConstraintEnforcement {
    private static final IDBasedConstraintEnforcement THE_ONE = new IDBasedConstraintEnforcement();
    private final WeakConcurrentHashMap wrappers = new WeakConcurrentHashMap();

    public static IDBasedConstraintEnforcement getInstance() {
        return THE_ONE;
    }

    public synchronized void schedule(WorkManager workManager, Runnable runnable, int n) {
        RunnableWrapper runnableWrapper = this.get(n);
        if (runnableWrapper == null) {
            runnableWrapper = this.create(n, runnable);
            runnableWrapper.submitted();
            workManager.schedule((Runnable)((Object)runnableWrapper));
        } else {
            boolean bl = runnableWrapper.add(runnable);
            if (!bl) {
                runnableWrapper.submitted();
                workManager.schedule((Runnable)((Object)runnableWrapper));
            }
        }
    }

    public synchronized int getExecutingCount(int n) {
        RunnableWrapper runnableWrapper = this.get(n);
        return runnableWrapper != null ? runnableWrapper.getExecutingCount() : 0;
    }

    public synchronized int getPendingCount(int n) {
        RunnableWrapper runnableWrapper = this.get(n);
        return runnableWrapper != null ? runnableWrapper.getPendingCount() : 0;
    }

    private RunnableWrapper create(int n, Runnable runnable) {
        RunnableWrapper runnableWrapper = new RunnableWrapper(n, runnable);
        this.wrappers.put((Object)n, (Object)runnableWrapper);
        return runnableWrapper;
    }

    private RunnableWrapper get(int n) {
        return (RunnableWrapper)((Object)this.wrappers.get((Object)n));
    }

    private static final class RunnableWrapper
    extends WorkAdapter {
        private int id;
        private boolean running;
        private boolean submitted;
        private Runnable initialRunnable;
        private UnsyncCircularQueue queue = null;

        RunnableWrapper(int n, Runnable runnable) {
            this.id = n;
            this.initialRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                if (this.running) {
                    return;
                }
                this.running = true;
            }
            if (this.initialRunnable != null) {
                this.initialRunnable.run();
            }
            object = null;
            while ((object = this.get()) != null) {
                object.run();
            }
        }

        private synchronized Runnable get() {
            if (this.queue == null) {
                this.reset();
                return null;
            }
            Runnable runnable = (Runnable)this.queue.get();
            if (runnable == null) {
                this.reset();
            }
            return runnable;
        }

        private void reset() {
            this.running = false;
            this.submitted = false;
            this.initialRunnable = null;
            this.queue = null;
        }

        synchronized boolean add(Runnable runnable) {
            if (this.initialRunnable == null) {
                this.initialRunnable = runnable;
                return this.submitted;
            }
            if (this.queue == null) {
                this.queue = new UnsyncCircularQueue();
            }
            this.queue.put((Object)runnable);
            return this.submitted;
        }

        synchronized int getPendingCount() {
            return this.queue != null ? this.queue.size() : 0;
        }

        synchronized int getExecutingCount() {
            return this.running ? 1 : 0;
        }

        public final int hashCode() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RunnableWrapper)) {
                return false;
            }
            return ((RunnableWrapper)((Object)object)).id == this.id;
        }

        synchronized void submitted() {
            this.submitted = true;
        }
    }
}

