/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.work.ExecuteRequestAdapter;
import weblogic.work.Work;
import weblogic.work.WorkManagerImpl;
import weblogic.work.WorkManagerLogger;

public final class KernelDelegator
extends WorkManagerImpl {
    private int dispatchId;

    KernelDelegator() {
        this.wmName = "direct";
    }

    KernelDelegator(String string, ExecuteQueueMBean executeQueueMBean) {
        Kernel.addExecuteQueue(string, executeQueueMBean, true);
        this.dispatchId = Kernel.getDispatchPolicyIndex(string);
        this.wmName = string;
    }

    KernelDelegator(String string, int n) {
        if (n > 0) {
            Kernel.addExecuteQueue(string, n);
            this.dispatchId = Kernel.getDispatchPolicyIndex(string);
        } else {
            this.dispatchId = Kernel.getDispatchPolicyIndex("weblogic.kernel.Default");
        }
        this.wmName = string;
    }

    public int getType() {
        return 2;
    }

    public int getConfiguredThreadCount() {
        return Kernel.getExecuteThreadManager(this.wmName).getExecuteThreadCount();
    }

    public void setThreadCount(int n) {
        Kernel.getExecuteThreadManager(this.wmName).setThreadCount(n);
    }

    public void schedule(Runnable runnable) {
        if ("direct" == this.wmName) {
            runnable.run();
            return;
        }
        try {
            Kernel.execute((ExecuteRequest)new ExecuteRequestAdapter(runnable), this.dispatchId);
        }
        catch (UnsyncCircularQueue.FullQueueException fullQueueException) {
            Runnable runnable2 = null;
            if (runnable instanceof Work) {
                runnable2 = ((Work)runnable).overloadAction(fullQueueException.getMessage());
            }
            if (runnable2 == null) {
                WorkManagerLogger.logScheduleFailed((String)this.wmName, (Throwable)fullQueueException);
                throw fullQueueException;
            }
            runnable2.run();
        }
    }

    public boolean executeIfIdle(Runnable runnable) {
        Kernel.executeIfIdle((ExecuteRequest)new ExecuteRequestAdapter(runnable), this.dispatchId);
        return true;
    }

    public boolean scheduleIfBusy(Runnable runnable) {
        if (Kernel.getExecuteQueueDepth(this.dispatchId) > 0) {
            this.schedule(runnable);
            return true;
        }
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof ExecuteThread) {
            ((ExecuteThread)((Object)thread2)).setTimeStamp(System.currentTimeMillis());
        }
        return false;
    }

    public int getQueueDepth() {
        return Kernel.getExecuteQueueDepth(this.dispatchId);
    }

    public boolean isThreadOwner(Thread thread2) {
        if (!(thread2 instanceof ExecuteThread)) {
            return false;
        }
        ExecuteThread executeThread = (ExecuteThread)((Object)thread2);
        if (executeThread.getExecuteThreadManager() == null) {
            return false;
        }
        return this.wmName.equalsIgnoreCase(executeThread.getExecuteThreadManager().getName());
    }
}

