/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import weblogic.application.ApplicationAccess;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorDiff;
import weblogic.descriptor.DescriptorUpdateEvent;
import weblogic.descriptor.DescriptorUpdateListener;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.MaxThreadsConstraintBean;
import weblogic.j2ee.descriptor.wl.SizeParamsBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.jdbc.module.JDBCModule;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JoltConnectionPoolMBean;
import weblogic.management.configuration.MaxThreadsConstraintMBean;
import weblogic.management.configuration.WLECConnectionPoolMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.WorkManagerLogger;

final class PoolBasedMaxThreadsConstraint
extends MaxThreadsConstraint
implements PropertyChangeListener,
BeanUpdateListener,
DescriptorUpdateListener {
    private static final DebugCategory debugMTC = Debug.getCategory((String)"weblogic.maxthreadsconstraint");
    private static final String WLEC_POOL_TYPE = "WLECConnectionPoolConfig";
    private static final String JOLT_POOL_TYPE = "JoltConnectionPoolConfig";
    private static final String CONNECTOR_POOL_TYPE = "ConnectorComponentConfig";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    PoolBasedMaxThreadsConstraint(String string, String string2) throws ManagementException {
        super(string);
        this.setCountUsingBean(string2);
    }

    PoolBasedMaxThreadsConstraint(String string, String string2, WeblogicApplicationBean weblogicApplicationBean) throws DeploymentException {
        super(string);
        JDBCConnectionPoolBean jDBCConnectionPoolBean = this.getAppScopedBean(weblogicApplicationBean, string2);
        if (jDBCConnectionPoolBean != null) {
            SizeParamsBean sizeParamsBean = jDBCConnectionPoolBean.getPoolParams().getSizeParams();
            this.setCount(sizeParamsBean.getMaxCapacity());
            this.registerForUpdates((DescriptorBean)sizeParamsBean);
        } else {
            this.setCountUsingBean(string2);
        }
    }

    private JDBCConnectionPoolBean getAppScopedBean(WeblogicApplicationBean weblogicApplicationBean, String string) {
        PoolBasedMaxThreadsConstraint.debug("looking up data source '" + string + ", within " + weblogicApplicationBean);
        if (weblogicApplicationBean == null || string == null) {
            return null;
        }
        JDBCConnectionPoolBean[] jDBCConnectionPoolBeanArray = weblogicApplicationBean.getJDBCConnectionPools();
        if (jDBCConnectionPoolBeanArray != null) {
            for (int i = 0; i < jDBCConnectionPoolBeanArray.length; ++i) {
                PoolBasedMaxThreadsConstraint.debug("got app scoped pool - " + jDBCConnectionPoolBeanArray[i].getDataSourceJNDIName());
                if (!string.equalsIgnoreCase(jDBCConnectionPoolBeanArray[i].getDataSourceJNDIName())) continue;
                PoolBasedMaxThreadsConstraint.debug("found a match for app scoped pool - " + string);
                return jDBCConnectionPoolBeanArray[i];
            }
        }
        return null;
    }

    private void setCountUsingBean(String string) throws DeploymentException {
        JDBCSystemResourceMBean jDBCSystemResourceMBean = this.getJDBCSystemResource(string);
        if (jDBCSystemResourceMBean != null) {
            this.setCount(jDBCSystemResourceMBean.getJDBCResource().getJDBCConnectionPoolParams().getMaxCapacity());
            jDBCSystemResourceMBean.getResource().getDescriptor().addUpdateListener((DescriptorUpdateListener)this);
            return;
        }
        JDBCConnectionPoolParamsBean jDBCConnectionPoolParamsBean = this.getJDBCConnectionPoolParams(string);
        if (jDBCConnectionPoolParamsBean != null) {
            this.setCount(jDBCConnectionPoolParamsBean.getMaxCapacity());
            this.registerForUpdates((DescriptorBean)jDBCConnectionPoolParamsBean);
            return;
        }
        ConfigurationMBean configurationMBean = this.getPoolMBean(CONNECTOR_POOL_TYPE, string);
        if (configurationMBean == null) {
            configurationMBean = this.getPoolMBean(WLEC_POOL_TYPE, string);
        }
        if (configurationMBean == null) {
            configurationMBean = this.getPoolMBean(JOLT_POOL_TYPE, string);
        }
        if (configurationMBean == null) {
            throw new DeploymentException("Unable to lookup pool '" + string + "'. Please check if the pool name is valid and points to a valid " + "data source");
        }
        configurationMBean.addPropertyChangeListener(this);
        if (configurationMBean instanceof WLECConnectionPoolMBean) {
            this.setCount(((WLECConnectionPoolMBean)configurationMBean).getMaximumPoolSize());
        } else if (configurationMBean instanceof JoltConnectionPoolMBean) {
            this.setCount(((JoltConnectionPoolMBean)configurationMBean).getMaximumPoolSize());
        } else if (configurationMBean instanceof ConnectorComponentMBean) {
            this.setCount(((ConnectorComponentMBean)configurationMBean).getMaxCapacity());
        }
    }

    private JDBCSystemResourceMBean getJDBCSystemResource(String string) {
        PoolBasedMaxThreadsConstraint.debug("looking up connection pool - " + string);
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (debugMTC.isEnabled()) {
            PoolBasedMaxThreadsConstraint.dumpAllJDBCResources(domainMBean);
        }
        JDBCSystemResourceMBean jDBCSystemResourceMBean = domainMBean.lookupJDBCSystemResource(string);
        PoolBasedMaxThreadsConstraint.debug("found JDBCSystemResource with name " + string + " - " + jDBCSystemResourceMBean);
        return jDBCSystemResourceMBean;
    }

    private JDBCConnectionPoolParamsBean getJDBCConnectionPoolParams(String string) {
        JDBCDataSourceBean jDBCDataSourceBean = PoolBasedMaxThreadsConstraint.getJDBCDataSourceBean(string);
        PoolBasedMaxThreadsConstraint.debug("found jdbc connection pool using JDBCUtil - " + jDBCDataSourceBean + " for name --- " + string);
        return jDBCDataSourceBean != null ? jDBCDataSourceBean.getJDBCConnectionPoolParams() : null;
    }

    private static JDBCDataSourceBean getJDBCDataSourceBean(String string) {
        JDBCDataSourceBean[] jDBCDataSourceBeanArray = null;
        jDBCDataSourceBeanArray = JDBCModule.getJDBCDataSourceBean(string);
        if (jDBCDataSourceBeanArray != null) {
            return jDBCDataSourceBeanArray[0];
        }
        return null;
    }

    private ConfigurationMBean getPoolMBean(String string, String string2) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        String string3 = string.intern();
        if (string3 == WLEC_POOL_TYPE) {
            PoolBasedMaxThreadsConstraint.debug("looking up WLEC POOL with name - " + string2);
            return domainMBean.lookupWLECConnectionPool(string2);
        }
        if (string3 == JOLT_POOL_TYPE) {
            PoolBasedMaxThreadsConstraint.debug("looking up JOLT POOL with name - " + string2);
            return domainMBean.lookupJoltConnectionPool(string2);
        }
        if (string3 == CONNECTOR_POOL_TYPE) {
            String string4 = ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
            if (string4 == null) {
                return null;
            }
            PoolBasedMaxThreadsConstraint.debug("looking up CONNECTOR POOL with name " + string2 + " in application " + string4);
            ApplicationMBean applicationMBean = domainMBean.lookupApplication(string4);
            if (applicationMBean == null) {
                return null;
            }
            return applicationMBean.lookupConnectorComponent(string2);
        }
        return null;
    }

    private void registerForUpdates(DescriptorBean descriptorBean) {
        descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
    }

    public void prepareUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
    }

    public void activateUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
        DescriptorDiff descriptorDiff = descriptorUpdateEvent.getDiff();
        for (BeanUpdateEvent beanUpdateEvent : descriptorDiff) {
            if (beanUpdateEvent.getSource() instanceof JDBCConnectionPoolParamsBean) {
                this.setCount(((JDBCConnectionPoolParamsBean)beanUpdateEvent.getSource()).getMaxCapacity());
                PoolBasedMaxThreadsConstraint.debug("Dynamic update of PoolBasedMaxThreadsConstraint " + this.getName() + " to count " + this.getCount());
                break;
            }
            if (!(beanUpdateEvent.getSource() instanceof SizeParamsBean)) continue;
            this.setCount(((SizeParamsBean)beanUpdateEvent.getSource()).getMaxCapacity());
            PoolBasedMaxThreadsConstraint.debug("Dynamic update of PoolBasedMaxThreadsConstraint " + this.getName() + " to count " + this.getCount());
            break;
        }
    }

    public void rollbackUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
    }

    public final void prepareUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public final void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        if (descriptorBean instanceof MaxThreadsConstraintMBean) {
            this.setCountInternal(((MaxThreadsConstraintMBean)descriptorBean).getCount());
        } else if (descriptorBean instanceof MaxThreadsConstraintBean) {
            this.setCountInternal(((MaxThreadsConstraintBean)descriptorBean).getCount());
        }
    }

    public final void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (!string.equals("MaxCapacity") && !string.equals("MaximumPoolSize")) {
            return;
        }
        int n = (Integer)propertyChangeEvent.getNewValue();
        this.setCount(n);
    }

    private static void dumpAllJDBCResources(DomainMBean domainMBean) {
        if (debugMTC.isEnabled()) {
            JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = domainMBean.getJDBCSystemResources();
            if (jDBCSystemResourceMBeanArray == null || jDBCSystemResourceMBeanArray.length == 0) {
                PoolBasedMaxThreadsConstraint.debug("There are no JDBCSystemResources in the configuration !");
            } else {
                for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                    PoolBasedMaxThreadsConstraint.debug("found JDBCSystemResource - " + jDBCSystemResourceMBeanArray[i].getName());
                }
            }
        }
    }

    private static void debug(String string) {
        if (debugMTC.isEnabled()) {
            WorkManagerLogger.logDebug((String)("<WM_MaxTC>" + string));
        }
    }
}

