/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkManagerCollection;
import weblogic.work.WorkManagerLogger;
import weblogic.work.WorkManagerService;

public final class RMIGracePeriodManager
implements WorkManagerService.WorkListener {
    private static final DebugCategory debugWMService = Debug.getCategory((String)"weblogic.workmanagerservice");
    private static final DebugCategory debugAppVersion = Debug.getCategory((String)"weblogic.AppVersion");
    private int rmiGracePeriodSecs = -1;
    private long lastScheduledTimeMillis = -1L;
    private WorkManagerCollection wmColl;

    public RMIGracePeriodManager(WorkManagerCollection workManagerCollection, int n) {
        this.wmColl = workManagerCollection;
        this.rmiGracePeriodSecs = n;
        if (n > 0) {
            this.initialize();
        }
    }

    private void initialize() {
        this.updateLastScheduledTimeMillis();
        if (RMIGracePeriodManager.debugEnabled()) {
            RMIGracePeriodManager.debug("-- wmservice - " + this + " RMI grace period will expire in " + this.rmiGracePeriodSecs + " secs");
        }
        for (WorkManagerService workManagerService : this.wmColl) {
            workManagerService.startRMIGracePeriod(this);
        }
        TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new RMIGracePeriodChecker(), (long)(this.rmiGracePeriodSecs * 1000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastScheduledTimeMillis() {
        RMIGracePeriodManager rMIGracePeriodManager = this;
        synchronized (rMIGracePeriodManager) {
            this.lastScheduledTimeMillis = System.currentTimeMillis();
            if (RMIGracePeriodManager.debugEnabled()) {
                RMIGracePeriodManager.debug("-- wmservice - " + this + " updateLastScheduledTime " + this.lastScheduledTimeMillis);
            }
        }
    }

    public void preScheduleWork() {
        this.updateLastScheduledTimeMillis();
    }

    public void postScheduleWork() {
    }

    private long getRMIGracePeriodTimeToExpireMillis() {
        if (this.rmiGracePeriodSecs == -1) {
            return -1L;
        }
        return this.getLastScheduledTimeMillis() + (long)(this.rmiGracePeriodSecs * 1000) - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastScheduledTimeMillis() {
        RMIGracePeriodManager rMIGracePeriodManager = this;
        synchronized (rMIGracePeriodManager) {
            return this.lastScheduledTimeMillis;
        }
    }

    private void notifyRMIGracePeriodExpired() {
        for (WorkManagerService workManagerService : this.wmColl) {
            workManagerService.endRMIGracePeriod();
        }
    }

    private static boolean debugEnabled() {
        return debugWMService.isEnabled() || debugAppVersion.isEnabled();
    }

    private static void debug(String string) {
        WorkManagerLogger.logDebug((String)string);
    }

    private final class RMIGracePeriodChecker
    implements TimerListener {
        private RMIGracePeriodChecker() {
        }

        public void timerExpired(Timer timer) {
            long l = RMIGracePeriodManager.this.getRMIGracePeriodTimeToExpireMillis();
            if (RMIGracePeriodManager.debugEnabled()) {
                RMIGracePeriodManager.debug("-- wmservice - " + this + " RMI grace period checker, " + "timeToExpireMillis=" + l);
            }
            if (l <= 0L) {
                RMIGracePeriodManager.this.notifyRMIGracePeriodExpired();
            } else {
                TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, l);
            }
        }
    }
}

