/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.management.ManagementException;
import weblogic.management.runtime.RequestClassRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.work.FairShareRequestClass;
import weblogic.work.RequestClass;
import weblogic.work.ResponseTimeRequestClass;
import weblogic.work.ServiceClassSupport;

public final class RequestClassRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements RequestClassRuntimeMBean {
    private final ServiceClassSupport rc;

    RequestClassRuntimeMBeanImpl(RequestClass requestClass) throws ManagementException {
        super(requestClass.getName());
        this.rc = (ServiceClassSupport)requestClass;
    }

    RequestClassRuntimeMBeanImpl(RequestClass requestClass, RuntimeMBean runtimeMBean) throws ManagementException {
        this(requestClass, runtimeMBean, true);
    }

    RequestClassRuntimeMBeanImpl(RequestClass requestClass, RuntimeMBean runtimeMBean, boolean bl) throws ManagementException {
        super(requestClass.getName(), runtimeMBean, bl);
        this.rc = (ServiceClassSupport)requestClass;
    }

    public String getRequestClassType() {
        if (this.rc instanceof FairShareRequestClass) {
            return "fairshare";
        }
        if (this.rc instanceof ResponseTimeRequestClass) {
            return "responsetime";
        }
        return "context";
    }

    public long getCompletedCount() {
        return this.rc.getCompleted();
    }

    public long getTotalThreadUse() {
        return this.rc.getThreadUse();
    }

    public long getThreadUseSquares() {
        return this.rc.getThreadUseSquares();
    }

    public long getDeltaFirst() {
        return this.rc.getDeltaFirst();
    }

    public long getDeltaRepeat() {
        return this.rc.getDelta();
    }

    public long getMyLast() {
        return this.rc.getMyLast();
    }

    public int getPendingRequestCount() {
        int n = this.rc.getPendingRequestsCount();
        return n >= 0 ? n : 0;
    }

    public long getVirtualTimeIncrement() {
        return this.rc.getVirtualTimeIncrement();
    }

    public double getInterval() {
        if (!(this.rc instanceof ResponseTimeRequestClass)) {
            return -1.0;
        }
        return ((ResponseTimeRequestClass)this.rc).getInterval();
    }
}

