/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import javax.management.InvalidAttributeValueException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.diagnostics.image.ImageManager;
import weblogic.health.HealthMonitorService;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.WorkManagerWrapper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.WorkManagerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.FairShareRequestClass;
import weblogic.work.GlobalWorkManagerComponentsFactory;
import weblogic.work.IncrementAdvisor;
import weblogic.work.KernelDelegator;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MaxThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.MinThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.OverloadManager;
import weblogic.work.RequestClass;
import weblogic.work.RequestClassRuntimeMBeanImpl;
import weblogic.work.RequestManager;
import weblogic.work.ResponseTimeRequestClass;
import weblogic.work.SelfTuningWorkManagerFactory;
import weblogic.work.ServerWorkManagerImpl;
import weblogic.work.StuckThreadManager;
import weblogic.work.ThreadPoolRuntimeMBeanImpl;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerImageSource;
import weblogic.work.WorkManagerLogger;
import weblogic.work.WorkManagerRuntimeMBeanImpl;

public final class ServerWorkManagerFactory
extends SelfTuningWorkManagerFactory {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ServerWorkManagerFactory SINGLETON;

    private ServerWorkManagerFactory() {
    }

    static ServerWorkManagerFactory get() {
        return SINGLETON;
    }

    public static synchronized void initialize(KernelMBean kernelMBean) throws ManagementException {
        if (SINGLETON != null) {
            return;
        }
        SINGLETON = new ServerWorkManagerFactory();
        WorkManagerFactory.set((WorkManagerFactory)SINGLETON);
        WorkManagerLogger.logInitializingSelfTuning();
        SINGLETON.initializeHere(kernelMBean);
    }

    public static synchronized void initialize(int n) {
        if (SINGLETON != null) {
            return;
        }
        SINGLETON = new ServerWorkManagerFactory();
        WorkManagerFactory.set((WorkManagerFactory)SINGLETON);
        WorkManagerLogger.logInitializingSelfTuning();
        SINGLETON.initializeHere(n);
    }

    private void initializeHere(KernelMBean kernelMBean) throws ManagementException {
        ServerWorkManagerImpl.initialize();
        IncrementAdvisor.setIncrementByCPUCount((boolean)kernelMBean.isAddWorkManagerThreadsByCpuCount());
        GlobalWorkManagerComponentsFactory.getInstance().initialize();
        super.initializeHere();
        Kernel.addDummyDefaultQueue(new WorkManagerWrapper("weblogic.kernel.Default"));
        ExecuteQueueMBean[] executeQueueMBeanArray = kernelMBean.getExecuteQueues();
        if (executeQueueMBeanArray != null) {
            boolean bl = false;
            int n = executeQueueMBeanArray.length;
            while (--n >= 0) {
                ExecuteQueueMBean executeQueueMBean = executeQueueMBeanArray[n];
                String string = executeQueueMBean.getName();
                if ("weblogic.kernel.Default".equalsIgnoreCase(string) || "default".equalsIgnoreCase(string)) continue;
                if (string.startsWith("wl_bootstrap_")) {
                    string = string.substring(13);
                }
                this.create(string, executeQueueMBean);
                bl = true;
            }
            if (bl) {
                WorkManagerLogger.logNoSelfTuningForExecuteQueues();
            }
        }
        ImageManager.getInstance().registerImageSource("WORK_MANAGER", WorkManagerImageSource.getInstance());
        try {
            ThreadPoolRuntimeMBeanImpl threadPoolRuntimeMBeanImpl = new ThreadPoolRuntimeMBeanImpl(RequestManager.getInstance());
            HealthMonitorService.register("threadpool", threadPoolRuntimeMBeanImpl, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private WorkManager createGlobalInternalWorkManagerFromTemplate(String string) {
        WorkManager workManager = null;
        GlobalWorkManagerComponentsFactory.WorkManagerTemplate workManagerTemplate = GlobalWorkManagerComponentsFactory.getInstance().removeWorkManagerTemplate(string);
        if (workManagerTemplate != null) {
            workManager = ServerWorkManagerFactory.create(string, null, null, workManagerTemplate.getRequestClass(), workManagerTemplate.getMaxThreadsConstraint(), workManagerTemplate.getMinThreadsConstraint(), workManagerTemplate.getCapacity(), null);
            WorkManagerLogger.logGlobalInternalWorkManagerOverriden((String)string);
        }
        return workManager;
    }

    private void initializeHere(int n) {
        ServerWorkManagerImpl.initialize((int)n);
        super.initializeHere();
        Kernel.addDummyDefaultQueue(new WorkManagerWrapper("weblogic.kernel.Default"));
    }

    protected WorkManager create(String string, int n, int n2, int n3, int n4) {
        MinThreadsConstraint minThreadsConstraint = null;
        if (n3 != -1) {
            minThreadsConstraint = new MinThreadsConstraint(string, n3);
        }
        MaxThreadsConstraint maxThreadsConstraint = null;
        if (n4 != -1) {
            maxThreadsConstraint = new MaxThreadsConstraint(string, n4);
        }
        ResponseTimeRequestClass responseTimeRequestClass = null;
        if (n2 > 0) {
            responseTimeRequestClass = new ResponseTimeRequestClass(string, n2);
        } else if (n > 0) {
            responseTimeRequestClass = new FairShareRequestClass(string, n);
        }
        WorkManager workManager = this.createGlobalInternalWorkManagerFromTemplate(string);
        if (workManager == null) {
            workManager = ServerWorkManagerFactory.create(string, null, null, (RequestClass)responseTimeRequestClass, maxThreadsConstraint, minThreadsConstraint, null, null);
        }
        if (KernelStatus.isServer()) {
            ServerWorkManagerFactory.createRuntimeMBean(workManager, (RequestClass)responseTimeRequestClass, minThreadsConstraint, maxThreadsConstraint);
        }
        return workManager;
    }

    private static void createRuntimeMBean(WorkManager workManager, RequestClass requestClass, MinThreadsConstraint minThreadsConstraint, MaxThreadsConstraint maxThreadsConstraint) {
        if (workManager instanceof ServerWorkManagerImpl) {
            try {
                WorkManagerRuntimeMBeanImpl workManagerRuntimeMBeanImpl = new WorkManagerRuntimeMBeanImpl((ServerWorkManagerImpl)workManager);
                if (requestClass != null) {
                    workManagerRuntimeMBeanImpl.setRequestClassRuntime(new RequestClassRuntimeMBeanImpl(requestClass));
                }
                if (minThreadsConstraint != null) {
                    workManagerRuntimeMBeanImpl.setMinThreadsConstraintRuntime(new MinThreadsConstraintRuntimeMBeanImpl(minThreadsConstraint));
                }
                if (maxThreadsConstraint != null) {
                    workManagerRuntimeMBeanImpl.setMaxThreadsConstraintRuntime(new MaxThreadsConstraintRuntimeMBeanImpl(maxThreadsConstraint));
                }
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().addWorkManagerRuntime(workManagerRuntimeMBeanImpl);
            }
            catch (ManagementException managementException) {
                WorkManagerLogger.logRuntimeMBeanCreationError((String)workManager.getName(), (Throwable)managementException);
            }
        }
    }

    private WorkManager create(String string, ExecuteQueueMBean executeQueueMBean) {
        WorkManagerLogger.logCreatingExecuteQueueFromMBean((String)string);
        KernelDelegator kernelDelegator = new KernelDelegator(string, executeQueueMBean);
        this.byName.put(string, kernelDelegator);
        return kernelDelegator;
    }

    public static WorkManager createExecuteQueue(String string, int n) {
        ExecuteQueueMBeanStub executeQueueMBeanStub = new ExecuteQueueMBeanStub();
        try {
            executeQueueMBeanStub.setThreadCount(n);
            executeQueueMBeanStub.setThreadsIncrease(0);
            executeQueueMBeanStub.setThreadsMaximum(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)("Invalid ExecuteQueueMBean attributes specified for " + string));
        }
        return ServerWorkManagerFactory.get().create(string, executeQueueMBeanStub);
    }

    protected WorkManager findAppScoped(String string, String string2, String string3, boolean bl) {
        ApplicationContextInternal applicationContextInternal = string2 != null && string2.length() != 0 ? ApplicationAccess.getApplicationAccess().getApplicationContext(this.getSanitizedAppName(string2)) : ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
        if (applicationContextInternal == null) {
            return null;
        }
        String string4 = string3 != null ? string3 : ApplicationAccess.getApplicationAccess().getCurrentModuleName();
        WorkManager workManager = applicationContextInternal.getWorkManagerCollection().get(string4, string, bl);
        return workManager != null ? workManager : this.DEFAULT;
    }

    private String getSanitizedAppName(String string) {
        int n;
        if (string != null && string.length() != 0 && (n = string.indexOf("@")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    static WorkManager create(String string, String string2, String string3) {
        return ServerWorkManagerFactory.create(string, string2, string3, null, null, null, null, null);
    }

    static WorkManager create(String string, String string2, String string3, StuckThreadManager stuckThreadManager) {
        return ServerWorkManagerFactory.create(string, string2, string3, null, null, null, null, stuckThreadManager);
    }

    protected static WorkManager create(String string, String string2, String string3, RequestClass requestClass, MaxThreadsConstraint maxThreadsConstraint, MinThreadsConstraint minThreadsConstraint, OverloadManager overloadManager, StuckThreadManager stuckThreadManager) {
        return new ServerWorkManagerImpl(string, string2, string3, requestClass, maxThreadsConstraint, minThreadsConstraint, overloadManager, stuckThreadManager);
    }

    static WorkManager create(String string, String string2, WorkManagerMBean workManagerMBean, StuckThreadManager stuckThreadManager) {
        GlobalWorkManagerComponentsFactory.WorkManagerTemplate workManagerTemplate = GlobalWorkManagerComponentsFactory.getInstance().findWorkManagerTemplate(workManagerMBean);
        return ServerWorkManagerFactory.create(workManagerMBean.getName(), string, string2, workManagerTemplate.getRequestClass(), workManagerTemplate.getMaxThreadsConstraint(), workManagerTemplate.getMinThreadsConstraint(), workManagerTemplate.getCapacity(), stuckThreadManager);
    }
}

