/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.OverloadManager;
import weblogic.work.RequestClass;
import weblogic.work.SelfTuningDebugLogger;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.ServerWorkAdapter;
import weblogic.work.StuckThreadManager;
import weblogic.work.Work;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerImageSource;
import weblogic.work.WorkManagerLogger;

public final class ServerWorkManagerImpl
extends SelfTuningWorkManagerImpl {
    static LowMemoryListener LOW_MEMORY_LISTENER;
    private static final AuthenticatedSubject kernelId;

    static void initialize() {
        SHARED_OVERLOAD_MANAGER = new OverloadManager("global overload manager");
        SHARED_OVERLOAD_MANAGER.setCapacity(ManagementService.getRuntimeAccess(kernelId).getServer().getOverloadProtection().getSharedCapacityForWorkManagers());
        LOW_MEMORY_LISTENER = new LowMemoryListener();
        ServerWorkManagerImpl.setDebugLogger((SelfTuningWorkManagerImpl.Logger)new SelfTuningWorkManagerImpl.Logger(){

            public boolean debugEnabled() {
                return SelfTuningDebugLogger.isDebugEnabled();
            }

            public void log(String string) {
                SelfTuningDebugLogger.debug("<ThreadPriorityManager>" + string);
            }
        });
    }

    ServerWorkManagerImpl(String string, String string2, String string3, RequestClass requestClass, MaxThreadsConstraint maxThreadsConstraint, MinThreadsConstraint minThreadsConstraint, OverloadManager overloadManager, StuckThreadManager stuckThreadManager) {
        super(string, string2, string3, requestClass, maxThreadsConstraint, minThreadsConstraint, overloadManager, stuckThreadManager);
        WorkManagerImageSource.getInstance().register(this);
    }

    protected static void notifyOOME(OutOfMemoryError outOfMemoryError) {
        HealthMonitorService.panic(outOfMemoryError);
    }

    protected boolean accept(Runnable runnable) {
        Object object;
        if (this.isInternal()) {
            return true;
        }
        if (!(runnable instanceof Work)) {
            return true;
        }
        String string = null;
        if (LOW_MEMORY_LISTENER.lowMemory()) {
            string = this.getLowMemoryMessage();
        } else {
            object = this.getRejectingOverloadManager();
            if (object != null) {
                string = ServerWorkManagerImpl.getOverloadMessage((OverloadManager)object);
            }
        }
        if (string == null) {
            return true;
        }
        object = ((Work)runnable).overloadAction(string);
        if (object == null || ServerWorkManagerImpl.isAdminWork(runnable)) {
            return true;
        }
        WorkManagerFactory.getInstance().getRejector().schedule((Runnable)object);
        return false;
    }

    private static final boolean isAdminWork(Runnable runnable) {
        if (!(runnable instanceof ServerWorkAdapter)) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = ((ServerWorkAdapter)((Object)runnable)).getAuthenticatedSubject();
        if (authenticatedSubject == null) {
            return false;
        }
        return SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)authenticatedSubject);
    }

    final String getLowMemoryMessage() {
        return WorkManagerLogger.logLowMemoryLoggable((String)this.wmName).getMessage();
    }

    public void cleanup() {
        super.cleanup();
        WorkManagerImageSource.getInstance().deregister(this);
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    static final class LowMemoryListener
    implements PropertyChangeListener {
        private static boolean lowMemory;

        private LowMemoryListener() {
            ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
            serverRuntimeMBean.addPropertyChangeListener(this);
        }

        boolean lowMemory() {
            return lowMemory;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if (!"HealthState".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            int n = ((HealthState)propertyChangeEvent.getNewValue()).getState();
            if (n == 4) {
                lowMemory = true;
                return;
            }
            if (n == 0) {
                lowMemory = false;
            }
        }
    }
}

