/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import java.util.ArrayList;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ThreadPoolRuntimeMBean;
import weblogic.platform.VM;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.CalendarQueue;
import weblogic.work.ExecuteThread;
import weblogic.work.ExecuteThreadRuntime;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.RequestManager;
import weblogic.work.ServerWorkManagerImpl;
import weblogic.work.WorkAdapter;

public final class ThreadPoolRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ThreadPoolRuntimeMBean {
    private static final boolean DESTRUCTIVE_DUMP = false;
    private static final String SHARED_CAPACITY_EXCEEDED = "Shared WorkManager capacity exceeded";
    private static final String STUCK_THREADS = "ThreadPool has stuck threads";
    private static final HealthState HEALTH_OK = new HealthState(0);
    private static final HealthState HEALTH_OVERLOADED = new HealthState(4, "Shared WorkManager capacity exceeded");
    private static final HealthState HEALTH_WARNING = new HealthState(1, "ThreadPool has stuck threads");
    private final transient RequestManager requestManager;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private HealthState healthState = HEALTH_OK;

    ThreadPoolRuntimeMBeanImpl(RequestManager requestManager) throws ManagementException {
        super("ThreadPoolRuntime");
        this.requestManager = requestManager;
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setThreadPoolRuntime(this);
    }

    public weblogic.management.runtime.ExecuteThread[] getExecuteThreads() {
        ExecuteThread[] executeThreadArray = this.requestManager.getExecuteThreads();
        int n = executeThreadArray.length;
        weblogic.management.runtime.ExecuteThread[] executeThreadArray2 = new weblogic.management.runtime.ExecuteThread[n];
        for (int i = 0; i < n; ++i) {
            executeThreadArray2[i] = new ExecuteThreadRuntime(executeThreadArray[i]);
        }
        return executeThreadArray2;
    }

    public weblogic.management.runtime.ExecuteThread getExecuteThread(String string) {
        if (string != null) {
            for (ExecuteThread executeThread : this.requestManager.getExecuteThreads()) {
                if (executeThread.getName() == null || !string.equals(executeThread.getName())) continue;
                return new ExecuteThreadRuntime(executeThread);
            }
        }
        return null;
    }

    private int getStuckThreadCount() {
        long l = ThreadPoolRuntimeMBeanImpl.getConfiguredStuckThreadMaxTime(ManagementService.getRuntimeAccess(kernelId).getServer());
        ArrayList arrayList = this.requestManager.getStuckThreads(l);
        return arrayList != null ? arrayList.size() : 0;
    }

    public weblogic.management.runtime.ExecuteThread[] getStuckExecuteThreads() {
        long l = ThreadPoolRuntimeMBeanImpl.getConfiguredStuckThreadMaxTime(ManagementService.getRuntimeAccess(kernelId).getServer());
        ArrayList arrayList = this.requestManager.getStuckThreads(l);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        weblogic.management.runtime.ExecuteThread[] executeThreadArray = new weblogic.management.runtime.ExecuteThread[n];
        for (int i = 0; i < n; ++i) {
            executeThreadArray[i] = new ExecuteThreadRuntime((ExecuteThread)arrayList.get(i));
        }
        return executeThreadArray;
    }

    private static final long getConfiguredStuckThreadMaxTime(ServerMBean serverMBean) {
        return serverMBean.getOverloadProtection().getServerFailureTrigger() != null ? (long)serverMBean.getOverloadProtection().getServerFailureTrigger().getMaxStuckThreadTime() * 1000L : (long)serverMBean.getStuckThreadMaxTime() * 1000L;
    }

    public int getExecuteThreadTotalCount() {
        return this.requestManager.getExecuteThreadCount();
    }

    public int getHoggingThreadCount() {
        return this.requestManager.getHogSize();
    }

    public int getStandbyThreadCount() {
        return this.requestManager.getStandbyCount();
    }

    public int getExecuteThreadIdleCount() {
        return this.requestManager.getIdleThreadCount();
    }

    public int getPendingUserRequestCount() {
        return ServerWorkManagerImpl.SHARED_OVERLOAD_MANAGER.getQueueDepth();
    }

    public int getQueueLength() {
        return this.requestManager.getQueueDepth();
    }

    public int getSharedCapacityForWorkManagers() {
        return ServerWorkManagerImpl.SHARED_OVERLOAD_MANAGER.getCapacity();
    }

    public long getCompletedRequestCount() {
        return this.requestManager.getQueueDepartures();
    }

    public double getThroughput() {
        double d = this.requestManager.getThroughput();
        return d > 0.0 ? d : 0.0;
    }

    public int getMinThreadsConstraintsPending() {
        return this.requestManager.getMustRunCount();
    }

    public long getMinThreadsConstraintsCompleted() {
        return this.requestManager.getMinThreadsConstraintsCompleted();
    }

    public boolean isSuspended() {
        return false;
    }

    public HealthState getHealthState() {
        HealthState healthState = HEALTH_OK;
        if (!ServerWorkManagerImpl.SHARED_OVERLOAD_MANAGER.canAcceptMore()) {
            healthState = HEALTH_OVERLOADED;
        } else if (this.getStuckThreadCount() > 0) {
            healthState = HEALTH_WARNING;
        }
        if (healthState != this.healthState) {
            this._postSet("HealthState", this.healthState, healthState);
            this.healthState = healthState;
        }
        return this.healthState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAndDestroy() {
        RequestManager requestManager = RequestManager.getInstance();
        synchronized (requestManager) {
            this.log("\n\n" + VM.getVM().threadDumpAsString() + "\n\n");
            CalendarQueue calendarQueue = RequestManager.getInstance().queue;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < calendarQueue.size(); ++i) {
                WorkAdapter workAdapter = (WorkAdapter)calendarQueue.pop();
                this.log("---- count " + i + " ------------- ");
                this.log(workAdapter.dump() + "\n");
            }
            this.log("###### PRINTING MIN THREADS CONSTRAINTS #######");
            MinThreadsConstraint[] minThreadsConstraintArray = RequestManager.getInstance().minThreadsConstraints;
            for (int i = 0; i < minThreadsConstraintArray.length; ++i) {
                this.log("@@@@@@@@ MTC @@@@@@ " + minThreadsConstraintArray[i].getName());
                minThreadsConstraintArray[i].dumpAndDestroy();
            }
        }
    }

    private void log(String string) {
        System.out.println(string);
    }
}

