/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.wl.ApplicationAdminModeTriggerBean;
import weblogic.j2ee.descriptor.wl.CapacityBean;
import weblogic.j2ee.descriptor.wl.ContextCaseBean;
import weblogic.j2ee.descriptor.wl.ContextRequestClassBean;
import weblogic.j2ee.descriptor.wl.FairShareRequestClassBean;
import weblogic.j2ee.descriptor.wl.MaxThreadsConstraintBean;
import weblogic.j2ee.descriptor.wl.MinThreadsConstraintBean;
import weblogic.j2ee.descriptor.wl.ResponseTimeRequestClassBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.descriptor.wl.WorkManagerBean;
import weblogic.j2ee.descriptor.wl.WorkManagerShutdownTriggerBean;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.SelfTuningMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WorkManagerMBean;
import weblogic.management.configuration.WorkManagerShutdownTriggerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.ApplicationAdminModeAction;
import weblogic.work.ContextRequestClass;
import weblogic.work.FairShareRequestClass;
import weblogic.work.FairShareRequestClassBeanUpdateListener;
import weblogic.work.GlobalWorkManagerComponentsFactory;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MaxThreadsConstraintBeanUpdateListener;
import weblogic.work.MaxThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.MinThreadsConstraintBeanUpdateListener;
import weblogic.work.MinThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.OverloadManager;
import weblogic.work.OverloadManagerBeanUpdateListener;
import weblogic.work.PoolBasedMaxThreadsConstraint;
import weblogic.work.RequestClass;
import weblogic.work.RequestClassRuntimeMBeanImpl;
import weblogic.work.ResponseTimeRequestClass;
import weblogic.work.ResponseTimeRequestClassBeanUpdateListener;
import weblogic.work.StuckThreadAction;
import weblogic.work.StuckThreadManager;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerLogger;
import weblogic.work.WorkManagerRuntimeMBeanImpl;
import weblogic.work.WorkManagerService;
import weblogic.work.WorkManagerServiceImpl;
import weblogic.work.WorkManagerShutdownAction;

public final class WorkManagerCollection
extends AbstractCollection
implements BeanUpdateListener {
    public static final int SHUTDOWN = 0;
    public static final int STARTED = 1;
    private static final DebugCategory debugWMCollection = Debug.getCategory((String)"weblogic.workmanagercollection");
    static final String DEFAULT_WM_NAME = "default";
    private static final String MODULE_DELIMITER = "@";
    private HashMap workManagers = new HashMap();
    private HashMap requestClassMap = new HashMap();
    private HashMap maxMap = new HashMap();
    private HashMap minMap = new HashMap();
    private HashMap overloadMap = new HashMap();
    private Map<String, WorkManagerRuntimeMBean> runtimeMBeans = new HashMap<String, WorkManagerRuntimeMBean>();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final String applicationName;
    private WeblogicApplicationBean weblogicApplicationBean;
    private J2EEApplicationRuntimeMBeanImpl applicationRuntimeMBean;
    private boolean initialized;
    private static final boolean use81ExecuteQueues = ManagementService.getRuntimeAccess(kernelId).getServer().getUse81StyleExecuteQueues();
    private boolean internal;
    private ApplicationAdminModeAction adminModeAction;
    private int state = 0;
    private static String thisCluster;
    private static String thisServer;

    public WorkManagerCollection(String string) {
        this(string, false);
    }

    public WorkManagerCollection(String string, boolean bl) {
        this.applicationName = string;
        this.internal = bl;
        this.debug("creating a new collection for app: " + string + ", internal: " + bl);
    }

    public synchronized void initialize(WeblogicApplicationBean weblogicApplicationBean) throws DeploymentException {
        Object object;
        if (this.initialized) {
            return;
        }
        this.populateNonWorkManagerComponents(weblogicApplicationBean);
        SelfTuningMBean selfTuningMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSelfTuning();
        StuckThreadManager stuckThreadManager = null;
        WorkManagerService workManagerService = null;
        if (selfTuningMBean == null) {
            stuckThreadManager = this.getStuckThreadManager();
            workManagerService = WorkManagerServiceImpl.createService(DEFAULT_WM_NAME, this.applicationName, (String)null, stuckThreadManager);
            if (this.internal) {
                workManagerService.setInternal();
            }
            this.workManagers.put(DEFAULT_WM_NAME, workManagerService);
            this.addWorkManagerRuntime(workManagerService, this.applicationRuntimeMBean);
            this.debug("created default WorkManager for " + this.applicationName);
            this.initialized = true;
            return;
        }
        if (thisServer == null || thisCluster == null) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            thisServer = runtimeAccess.getServerName();
            object = runtimeAccess.getServerRuntime().getClusterRuntime();
            if (object != null) {
                thisCluster = object.getName();
            }
        }
        boolean bl = false;
        object = selfTuningMBean.getWorkManagers();
        if (object != null) {
            for (int i = 0; i < ((WorkManagerMBean[])object).length; ++i) {
                WorkManagerMBean workManagerMBean = object[i];
                WorkManagerService workManagerService2 = this.configureWorkManagerService(workManagerMBean);
                if (workManagerService2 == null || !workManagerService2.getName().equals(DEFAULT_WM_NAME)) continue;
                bl = true;
            }
        }
        selfTuningMBean.addBeanUpdateListener(this);
        if (!bl) {
            stuckThreadManager = this.getStuckThreadManager();
            workManagerService = WorkManagerServiceImpl.createService(DEFAULT_WM_NAME, this.applicationName, (String)null, stuckThreadManager);
            if (this.internal) {
                workManagerService.setInternal();
            }
            this.workManagers.put(DEFAULT_WM_NAME, workManagerService);
            this.addWorkManagerRuntime(workManagerService, this.applicationRuntimeMBean);
            this.debug("created default WorkManager for " + this.applicationName);
        }
        this.populateWorkManagers(weblogicApplicationBean);
        this.initialized = true;
    }

    private WorkManagerService configureWorkManagerService(WorkManagerMBean workManagerMBean) throws DeploymentException {
        WorkManagerService workManagerService = null;
        if (DEFAULT_WM_NAME.equals(workManagerMBean.getName())) {
            workManagerService = this.addWorkManager(workManagerMBean);
        } else {
            TargetMBean[] targetMBeanArray;
            for (TargetMBean targetMBean : targetMBeanArray = workManagerMBean.getTargets()) {
                String string = targetMBean.getName();
                if (!string.equals(thisServer) && !string.equals(thisCluster)) continue;
                workManagerService = this.addWorkManager(workManagerMBean);
                break;
            }
        }
        return workManagerService;
    }

    public void setApplicationRuntime(J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl) {
        this.applicationRuntimeMBean = j2EEApplicationRuntimeMBeanImpl;
    }

    public synchronized Iterator iterator() {
        return this.workManagers.values().iterator();
    }

    public int size() {
        return this.workManagers.size();
    }

    private synchronized void populateNonWorkManagerComponents(WeblogicApplicationBean weblogicApplicationBean) throws DeploymentException {
        if (weblogicApplicationBean == null) {
            return;
        }
        this.weblogicApplicationBean = weblogicApplicationBean;
        this.populate(weblogicApplicationBean.getFairShareRequests());
        this.populate(weblogicApplicationBean.getResponseTimeRequests());
        this.populate(weblogicApplicationBean.getContextRequests());
        this.populate(weblogicApplicationBean.getMaxThreadsConstraints());
        this.populate(weblogicApplicationBean.getMinThreadsConstraints());
        this.populate(weblogicApplicationBean.getCapacities());
        this.populate(weblogicApplicationBean.getApplicationAdminModeTrigger());
    }

    private synchronized void populateWorkManagers(WeblogicApplicationBean weblogicApplicationBean) throws DeploymentException {
        if (weblogicApplicationBean == null) {
            return;
        }
        this.weblogicApplicationBean = weblogicApplicationBean;
        this.populate(null, weblogicApplicationBean.getWorkManagers());
    }

    public synchronized void populate(String string, WeblogicEjbJarBean weblogicEjbJarBean) throws DeploymentException {
        this.populate(string, weblogicEjbJarBean.getWorkManagers());
    }

    public synchronized void populate(String string, WeblogicWebAppBean weblogicWebAppBean) throws DeploymentException {
        this.populate(string, weblogicWebAppBean.getWorkManagers());
    }

    private void populate(FairShareRequestClassBean[] fairShareRequestClassBeanArray) throws DeploymentException {
        if (fairShareRequestClassBeanArray == null || use81ExecuteQueues) {
            return;
        }
        try {
            for (int i = 0; i < fairShareRequestClassBeanArray.length; ++i) {
                FairShareRequestClassBean fairShareRequestClassBean = fairShareRequestClassBeanArray[i];
                FairShareRequestClass fairShareRequestClass = new FairShareRequestClass(fairShareRequestClassBean.getName(), fairShareRequestClassBean.getFairShare());
                ((DescriptorBean)fairShareRequestClassBean).addBeanUpdateListener((BeanUpdateListener)new FairShareRequestClassBeanUpdateListener(fairShareRequestClass));
                fairShareRequestClass.setShared(true);
                this.requestClassMap.put(fairShareRequestClassBean.getName(), fairShareRequestClass);
                this.applicationRuntimeMBean.addRequestClass(new RequestClassRuntimeMBeanImpl((RequestClass)fairShareRequestClass, this.applicationRuntimeMBean));
            }
        }
        catch (ManagementException managementException) {
            throw new DeploymentException(managementException);
        }
    }

    private void populate(ResponseTimeRequestClassBean[] responseTimeRequestClassBeanArray) throws DeploymentException {
        if (responseTimeRequestClassBeanArray == null || use81ExecuteQueues) {
            return;
        }
        try {
            for (int i = 0; i < responseTimeRequestClassBeanArray.length; ++i) {
                ResponseTimeRequestClassBean responseTimeRequestClassBean = responseTimeRequestClassBeanArray[i];
                ResponseTimeRequestClass responseTimeRequestClass = new ResponseTimeRequestClass(responseTimeRequestClassBean.getName(), responseTimeRequestClassBean.getGoalMs());
                ((DescriptorBean)responseTimeRequestClassBean).addBeanUpdateListener((BeanUpdateListener)new ResponseTimeRequestClassBeanUpdateListener(responseTimeRequestClass));
                responseTimeRequestClass.setShared(true);
                this.requestClassMap.put(responseTimeRequestClassBean.getName(), responseTimeRequestClass);
                this.applicationRuntimeMBean.addRequestClass(new RequestClassRuntimeMBeanImpl((RequestClass)responseTimeRequestClass, this.applicationRuntimeMBean));
            }
        }
        catch (ManagementException managementException) {
            throw new DeploymentException(managementException);
        }
    }

    private void populate(ContextRequestClassBean[] contextRequestClassBeanArray) throws DeploymentException {
        if (contextRequestClassBeanArray == null || use81ExecuteQueues) {
            return;
        }
        for (int i = 0; i < contextRequestClassBeanArray.length; ++i) {
            ContextRequestClassBean contextRequestClassBean = contextRequestClassBeanArray[i];
            ContextCaseBean[] contextCaseBeanArray = contextRequestClassBean.getContextCases();
            ContextRequestClass contextRequestClass = new ContextRequestClass(contextRequestClassBean.getName());
            if (contextCaseBeanArray != null) {
                for (int j = 0; j < contextCaseBeanArray.length; ++j) {
                    ContextCaseBean contextCaseBean = contextCaseBeanArray[i];
                    RequestClass requestClass = this.getRequestClass(contextCaseBean.getRequestClassName());
                    if (requestClass == null) {
                        throw new DeploymentException("request class " + contextCaseBean.getRequestClassName() + " not found");
                    }
                    if (contextCaseBean.getUserName() != null) {
                        contextRequestClass.addUser(contextCaseBean.getUserName(), requestClass);
                        continue;
                    }
                    if (contextCaseBean.getGroupName() == null) continue;
                    contextRequestClass.addGroup(contextCaseBean.getGroupName(), requestClass);
                }
            }
            contextRequestClass.setShared(true);
            this.requestClassMap.put(contextRequestClassBean.getName(), contextRequestClass);
        }
    }

    private void populate(MaxThreadsConstraintBean[] maxThreadsConstraintBeanArray) throws DeploymentException {
        if (maxThreadsConstraintBeanArray == null) {
            return;
        }
        for (int i = 0; i < maxThreadsConstraintBeanArray.length; ++i) {
            MaxThreadsConstraintBean maxThreadsConstraintBean = maxThreadsConstraintBeanArray[i];
            try {
                MaxThreadsConstraint maxThreadsConstraint;
                if (maxThreadsConstraintBean.getPoolName() != null) {
                    maxThreadsConstraint = new PoolBasedMaxThreadsConstraint(maxThreadsConstraintBean.getName(), maxThreadsConstraintBean.getPoolName(), this.weblogicApplicationBean);
                } else {
                    maxThreadsConstraint = new MaxThreadsConstraint(maxThreadsConstraintBean.getName(), maxThreadsConstraintBean.getCount());
                    ((DescriptorBean)maxThreadsConstraintBean).addBeanUpdateListener((BeanUpdateListener)new MaxThreadsConstraintBeanUpdateListener(maxThreadsConstraint));
                }
                this.maxMap.put(maxThreadsConstraintBean.getName(), maxThreadsConstraint);
                if (use81ExecuteQueues) continue;
                this.applicationRuntimeMBean.addMaxThreadsConstraint(new MaxThreadsConstraintRuntimeMBeanImpl(maxThreadsConstraint, this.applicationRuntimeMBean));
                continue;
            }
            catch (ManagementException managementException) {
                throw new DeploymentException("unable to create runtime mbean for max constraint " + maxThreadsConstraintBean.getName(), managementException);
            }
        }
    }

    private void populate(MinThreadsConstraintBean[] minThreadsConstraintBeanArray) throws DeploymentException {
        try {
            if (minThreadsConstraintBeanArray == null) {
                return;
            }
            for (int i = 0; i < minThreadsConstraintBeanArray.length; ++i) {
                MinThreadsConstraintBean minThreadsConstraintBean = minThreadsConstraintBeanArray[i];
                MinThreadsConstraint minThreadsConstraint = new MinThreadsConstraint(minThreadsConstraintBean.getName(), minThreadsConstraintBean.getCount());
                this.minMap.put(minThreadsConstraintBean.getName(), minThreadsConstraint);
                if (use81ExecuteQueues) continue;
                ((DescriptorBean)minThreadsConstraintBean).addBeanUpdateListener((BeanUpdateListener)new MinThreadsConstraintBeanUpdateListener(minThreadsConstraint));
                this.applicationRuntimeMBean.addMinThreadsConstraint(new MinThreadsConstraintRuntimeMBeanImpl(minThreadsConstraint, this.applicationRuntimeMBean));
            }
        }
        catch (ManagementException managementException) {
            throw new DeploymentException("unable to create runtime mbean for min constraint", managementException);
        }
    }

    private void populate(CapacityBean[] capacityBeanArray) {
        if (capacityBeanArray == null || use81ExecuteQueues) {
            return;
        }
        for (int i = 0; i < capacityBeanArray.length; ++i) {
            CapacityBean capacityBean = capacityBeanArray[i];
            OverloadManager overloadManager = new OverloadManager(capacityBean.getName(), capacityBean.getCount());
            ((DescriptorBean)capacityBean).addBeanUpdateListener((BeanUpdateListener)new OverloadManagerBeanUpdateListener(overloadManager));
            this.overloadMap.put(capacityBean.getName(), overloadManager);
        }
    }

    private void populate(ApplicationAdminModeTriggerBean applicationAdminModeTriggerBean) {
        if (applicationAdminModeTriggerBean == null || use81ExecuteQueues) {
            return;
        }
        this.adminModeAction = new ApplicationAdminModeAction(applicationAdminModeTriggerBean, this.applicationName);
    }

    private void populate(String string, WorkManagerBean[] workManagerBeanArray) throws DeploymentException {
        if (workManagerBeanArray == null) {
            return;
        }
        for (int i = 0; i < workManagerBeanArray.length; ++i) {
            WorkManagerBean workManagerBean = workManagerBeanArray[i];
            this.populate(string, workManagerBean);
        }
    }

    public synchronized WorkManagerService populate(String string, WorkManagerBean workManagerBean) throws DeploymentException {
        RequestClass requestClass = this.getPolicy(workManagerBean);
        MinThreadsConstraint minThreadsConstraint = this.getMinConstraint(workManagerBean);
        MaxThreadsConstraint maxThreadsConstraint = this.getMaxConstraint(workManagerBean);
        OverloadManager overloadManager = this.getOverload(workManagerBean);
        WorkManagerShutdownAction workManagerShutdownAction = this.getShutdownAction(workManagerBean);
        StuckThreadManager stuckThreadManager = this.getStuckThreadManager(workManagerBean, workManagerShutdownAction);
        WorkManagerLogger.logCreatingWorkManagerService((String)string, (String)this.applicationName, (String)workManagerBean.getName());
        WorkManagerService workManagerService = WorkManagerServiceImpl.createService(workManagerBean.getName(), this.applicationName, string, requestClass, maxThreadsConstraint, minThreadsConstraint, overloadManager, stuckThreadManager);
        if (workManagerShutdownAction != null) {
            workManagerShutdownAction.setWorkManagerService(workManagerService);
        }
        if (this.internal) {
            workManagerService.setInternal();
        }
        if (string != null) {
            this.workManagers.put(string + MODULE_DELIMITER + workManagerBean.getName(), workManagerService);
        } else {
            this.workManagers.put(workManagerBean.getName(), workManagerService);
        }
        if (use81ExecuteQueues || string != null) {
            return workManagerService;
        }
        this.addWorkManagerRuntime(workManagerService, this.applicationRuntimeMBean);
        return workManagerService;
    }

    private WorkManagerShutdownAction getShutdownAction(WorkManagerMBean workManagerMBean) {
        if (use81ExecuteQueues) {
            return null;
        }
        if (workManagerMBean == null) {
            return null;
        }
        if (workManagerMBean.getIgnoreStuckThreads()) {
            return null;
        }
        WorkManagerShutdownTriggerMBean workManagerShutdownTriggerMBean = workManagerMBean.getWorkManagerShutdownTrigger();
        if (workManagerShutdownTriggerMBean != null && workManagerShutdownTriggerMBean.getStuckThreadCount() > 0) {
            this.debug("Found WorkManagerShutdownTriggerMBean with " + workManagerShutdownTriggerMBean.getMaxStuckThreadTime() + " seconds and " + workManagerShutdownTriggerMBean.getStuckThreadCount() + " count");
            return new WorkManagerShutdownAction(workManagerShutdownTriggerMBean);
        }
        return null;
    }

    private StuckThreadManager getStuckThreadManager(WorkManagerMBean workManagerMBean, WorkManagerShutdownAction workManagerShutdownAction) {
        if (use81ExecuteQueues) {
            return null;
        }
        if (workManagerMBean != null && workManagerMBean.getIgnoreStuckThreads()) {
            return new StuckThreadManager();
        }
        if (workManagerShutdownAction == null && this.adminModeAction == null && GlobalWorkManagerComponentsFactory.getInstance().getServerFailedAction() == null) {
            this.debug("NO global ServerFailureAction found. No stuck thread action !");
            return null;
        }
        this.debug("Global ServerFailureAction FOUND. Creating StuckThreadManager !");
        return new StuckThreadManager((StuckThreadAction)workManagerShutdownAction, (StuckThreadAction)this.adminModeAction, (StuckThreadAction)GlobalWorkManagerComponentsFactory.getInstance().getServerFailedAction());
    }

    private StuckThreadManager getStuckThreadManager() {
        return this.getStuckThreadManager((WorkManagerBean)null, null);
    }

    private WorkManagerShutdownAction getShutdownAction(WorkManagerBean workManagerBean) {
        if (use81ExecuteQueues) {
            return null;
        }
        if (workManagerBean == null) {
            return null;
        }
        if (workManagerBean.getIgnoreStuckThreads()) {
            return null;
        }
        WorkManagerShutdownTriggerBean workManagerShutdownTriggerBean = workManagerBean.getWorkManagerShutdownTrigger();
        if (workManagerShutdownTriggerBean != null && workManagerShutdownTriggerBean.getStuckThreadCount() > 0) {
            this.debug("Found WorkManagerShutdownTriggerMBean with " + workManagerShutdownTriggerBean.getMaxStuckThreadTime() + " seconds and " + workManagerShutdownTriggerBean.getStuckThreadCount() + " count");
            return new WorkManagerShutdownAction(workManagerShutdownTriggerBean);
        }
        return null;
    }

    private StuckThreadManager getStuckThreadManager(WorkManagerBean workManagerBean, WorkManagerShutdownAction workManagerShutdownAction) {
        if (use81ExecuteQueues) {
            return null;
        }
        if (workManagerBean != null && workManagerBean.getIgnoreStuckThreads()) {
            return new StuckThreadManager();
        }
        if (workManagerShutdownAction == null && this.adminModeAction == null && GlobalWorkManagerComponentsFactory.getInstance().getServerFailedAction() == null) {
            this.debug("NO global ServerFailureAction found. No stuck thread action !");
            return null;
        }
        this.debug("Global ServerFailureAction FOUND. Creating StuckThreadManager !");
        return new StuckThreadManager((StuckThreadAction)workManagerShutdownAction, (StuckThreadAction)this.adminModeAction, (StuckThreadAction)GlobalWorkManagerComponentsFactory.getInstance().getServerFailedAction());
    }

    private OverloadManager getOverload(WorkManagerBean workManagerBean) {
        if (use81ExecuteQueues) {
            return null;
        }
        CapacityBean capacityBean = workManagerBean.getCapacity();
        if (capacityBean != null) {
            OverloadManager overloadManager = new OverloadManager(capacityBean.getName(), capacityBean.getCount());
            ((DescriptorBean)capacityBean).addBeanUpdateListener((BeanUpdateListener)new OverloadManagerBeanUpdateListener(overloadManager));
            return overloadManager;
        }
        String string = workManagerBean.getCapacityName();
        if (string != null) {
            return this.getOverload(string);
        }
        return null;
    }

    private MaxThreadsConstraint getMaxConstraint(WorkManagerBean workManagerBean) throws DeploymentException {
        MaxThreadsConstraintBean maxThreadsConstraintBean = workManagerBean.getMaxThreadsConstraint();
        if (maxThreadsConstraintBean != null) {
            String string = maxThreadsConstraintBean.getPoolName();
            if (string != null) {
                return new PoolBasedMaxThreadsConstraint(maxThreadsConstraintBean.getName(), string, this.weblogicApplicationBean);
            }
            MaxThreadsConstraint maxThreadsConstraint = new MaxThreadsConstraint(maxThreadsConstraintBean.getName(), maxThreadsConstraintBean.getCount());
            ((DescriptorBean)maxThreadsConstraintBean).addBeanUpdateListener((BeanUpdateListener)new MaxThreadsConstraintBeanUpdateListener(maxThreadsConstraint));
            return maxThreadsConstraint;
        }
        String string = workManagerBean.getMaxThreadsConstraintName();
        if (string != null) {
            return this.getMaxConstraint(string);
        }
        return null;
    }

    private MinThreadsConstraint getMinConstraint(WorkManagerBean workManagerBean) {
        MinThreadsConstraintBean minThreadsConstraintBean = workManagerBean.getMinThreadsConstraint();
        if (minThreadsConstraintBean != null) {
            MinThreadsConstraint minThreadsConstraint = new MinThreadsConstraint(minThreadsConstraintBean.getName(), minThreadsConstraintBean.getCount());
            ((DescriptorBean)minThreadsConstraintBean).addBeanUpdateListener((BeanUpdateListener)new MinThreadsConstraintBeanUpdateListener(minThreadsConstraint));
            return minThreadsConstraint;
        }
        String string = workManagerBean.getMinThreadsConstraintName();
        if (string != null) {
            return this.getMinConstraint(string);
        }
        return null;
    }

    private RequestClass getPolicy(WorkManagerBean workManagerBean) {
        Object object;
        if (use81ExecuteQueues) {
            return null;
        }
        FairShareRequestClassBean fairShareRequestClassBean = workManagerBean.getFairShareRequestClass();
        if (fairShareRequestClassBean != null) {
            FairShareRequestClass fairShareRequestClass = new FairShareRequestClass(fairShareRequestClassBean.getName(), fairShareRequestClassBean.getFairShare());
            ((DescriptorBean)fairShareRequestClassBean).addBeanUpdateListener((BeanUpdateListener)new FairShareRequestClassBeanUpdateListener(fairShareRequestClass));
            return fairShareRequestClass;
        }
        ResponseTimeRequestClassBean responseTimeRequestClassBean = workManagerBean.getResponseTimeRequestClass();
        if (responseTimeRequestClassBean != null) {
            ResponseTimeRequestClass responseTimeRequestClass = new ResponseTimeRequestClass(responseTimeRequestClassBean.getName(), responseTimeRequestClassBean.getGoalMs());
            ((DescriptorBean)responseTimeRequestClassBean).addBeanUpdateListener((BeanUpdateListener)new ResponseTimeRequestClassBeanUpdateListener(responseTimeRequestClass));
            return responseTimeRequestClass;
        }
        ContextRequestClassBean contextRequestClassBean = workManagerBean.getContextRequestClass();
        if (contextRequestClassBean != null && (object = contextRequestClassBean.getContextCases()) != null) {
            ContextRequestClass contextRequestClass = new ContextRequestClass(contextRequestClassBean.getName());
            for (int i = 0; i < ((ContextCaseBean[])object).length; ++i) {
                RequestClass requestClass;
                ContextCaseBean contextCaseBean = object[i];
                if (contextCaseBean.getUserName() != null) {
                    requestClass = this.getRequestClass(contextCaseBean.getRequestClassName());
                    if (requestClass != null) {
                        contextRequestClass.addUser(contextCaseBean.getUserName(), requestClass);
                        continue;
                    }
                    WorkManagerLogger.logMissingContextCaseRequestClass((String)"user-name", (String)contextCaseBean.getUserName());
                    continue;
                }
                if (contextCaseBean.getGroupName() == null) continue;
                requestClass = this.getRequestClass(contextCaseBean.getRequestClassName());
                if (requestClass != null) {
                    contextRequestClass.addGroup(contextCaseBean.getGroupName(), requestClass);
                    continue;
                }
                WorkManagerLogger.logMissingContextCaseRequestClass((String)"group-name", (String)contextCaseBean.getUserName());
            }
            return contextRequestClass;
        }
        object = workManagerBean.getRequestClassName();
        if (object != null) {
            return this.getRequestClass((String)object);
        }
        return null;
    }

    private RequestClass getRequestClass(String string) {
        RequestClass requestClass = (RequestClass)this.requestClassMap.get(string);
        if (requestClass != null) {
            return requestClass;
        }
        if (use81ExecuteQueues) {
            return null;
        }
        return GlobalWorkManagerComponentsFactory.getInstance().findRequestClass(string);
    }

    private MaxThreadsConstraint getMaxConstraint(String string) {
        MaxThreadsConstraint maxThreadsConstraint = (MaxThreadsConstraint)this.maxMap.get(string);
        if (maxThreadsConstraint != null) {
            return maxThreadsConstraint;
        }
        if (use81ExecuteQueues) {
            return null;
        }
        return GlobalWorkManagerComponentsFactory.getInstance().findMaxThreadsConstraint(string);
    }

    private MinThreadsConstraint getMinConstraint(String string) {
        MinThreadsConstraint minThreadsConstraint = (MinThreadsConstraint)this.minMap.get(string);
        if (minThreadsConstraint != null) {
            return minThreadsConstraint;
        }
        if (use81ExecuteQueues) {
            return null;
        }
        return GlobalWorkManagerComponentsFactory.getInstance().findMinThreadsConstraint(string);
    }

    private OverloadManager getOverload(String string) {
        OverloadManager overloadManager = (OverloadManager)this.overloadMap.get(string);
        if (overloadManager != null) {
            return overloadManager;
        }
        if (use81ExecuteQueues) {
            return null;
        }
        return GlobalWorkManagerComponentsFactory.getInstance().findOverloadManager(string);
    }

    public synchronized WorkManager get(String string, String string2) {
        return this.get(string, string2, true);
    }

    synchronized WorkManager get(String string, String string2, boolean bl) {
        String string3;
        WorkManager workManager = null;
        if (string != null && (workManager = (WorkManager)this.workManagers.get(string3 = string + MODULE_DELIMITER + string2)) != null) {
            this.debug("found WorkManager for module '" + string + "' app '" + this.applicationName + "' wmName '" + string2);
            return workManager;
        }
        workManager = (WorkManager)this.workManagers.get(string2);
        if (workManager != null) {
            this.debug("found WorkManager for app '" + this.applicationName + "' wmName '" + string2);
            return workManager;
        }
        this.debug("No WorkManager for wmName '" + string2 + "' in app '" + this.applicationName + "', module '" + string + "'. returning default");
        if (bl) {
            this.logWorkManagerNotFound(string2);
        }
        return this.getDefault();
    }

    private void logWorkManagerNotFound(String string) {
        if (string != null && string.toLowerCase(Locale.ENGLISH).indexOf(DEFAULT_WM_NAME) == -1) {
            WorkManagerLogger.logWorkManagerNotFound((String)string, (String)this.applicationName);
        }
    }

    public synchronized void removeModuleEntries(String string) {
        Iterator iterator = this.workManagers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).startsWith(string + MODULE_DELIMITER)) continue;
            ((WorkManagerService)entry.getValue()).cleanup();
            iterator.remove();
        }
    }

    public synchronized List getWorkManagers(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : this.workManagers.keySet()) {
            if (!string2.startsWith(string + MODULE_DELIMITER)) continue;
            arrayList.add(this.workManagers.get(string2));
        }
        return arrayList;
    }

    public WorkManager getDefault() {
        return (WorkManager)this.workManagers.get(DEFAULT_WM_NAME);
    }

    private void addWorkManagerRuntime(WorkManagerService workManagerService, RuntimeMBean runtimeMBean) throws DeploymentException {
        WorkManager workManager = workManagerService.getDelegate();
        try {
            if (use81ExecuteQueues) {
                return;
            }
            WorkManagerRuntimeMBean workManagerRuntimeMBean = WorkManagerRuntimeMBeanImpl.getWorkManagerRuntime(workManager, this.applicationRuntimeMBean, runtimeMBean);
            this.runtimeMBeans.put(workManager.getName(), workManagerRuntimeMBean);
            this.applicationRuntimeMBean.addWorkManager(workManagerRuntimeMBean);
        }
        catch (ManagementException managementException) {
            throw new DeploymentException("unable to create WorkManagerRuntimeMBean for " + workManager.getName(), managementException);
        }
    }

    private void debug(String string) {
        if (debugWMCollection.isEnabled()) {
            WorkManagerLogger.logDebug((String)("<WMCollection>" + string));
        }
    }

    private synchronized WorkManagerService addWorkManager(WorkManagerMBean workManagerMBean) throws DeploymentException {
        WorkManagerLogger.logCreatingServiceFromMBean((String)this.applicationName, (String)workManagerMBean.getName());
        WorkManagerShutdownAction workManagerShutdownAction = this.getShutdownAction(workManagerMBean);
        StuckThreadManager stuckThreadManager = this.getStuckThreadManager(workManagerMBean, workManagerShutdownAction);
        WorkManagerService workManagerService = WorkManagerServiceImpl.createService(this.applicationName, null, workManagerMBean, stuckThreadManager);
        if (workManagerShutdownAction != null) {
            workManagerShutdownAction.setWorkManagerService(workManagerService);
        }
        if (this.internal) {
            workManagerService.setInternal();
        }
        this.workManagers.put(workManagerMBean.getName(), workManagerService);
        this.addWorkManagerRuntime(workManagerService, this.applicationRuntimeMBean);
        return workManagerService;
    }

    private synchronized void removeWorkManager(WorkManagerMBean workManagerMBean) {
        block4: {
            WorkManagerRuntimeMBeanImpl workManagerRuntimeMBeanImpl = (WorkManagerRuntimeMBeanImpl)this.runtimeMBeans.remove(workManagerMBean.getName());
            if (workManagerRuntimeMBeanImpl != null) {
                try {
                    if (debugWMCollection.isEnabled()) {
                        this.debug("Removing work manager instance for " + workManagerMBean.getName() + " from " + this.applicationName + " runtime");
                    }
                    this.workManagers.remove(workManagerMBean.getName());
                    workManagerRuntimeMBeanImpl.unregister();
                }
                catch (ManagementException managementException) {
                    if (!debugWMCollection.isEnabled()) break block4;
                    this.debug("Unable to unregister RuntimeMBean for WorkManager " + workManagerMBean.getName());
                }
            }
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (this.internal) {
            return;
        }
        if (beanUpdateEvent.getSourceBean() instanceof SelfTuningMBean) {
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            WorkManagerMBean workManagerMBean = null;
            if (propertyUpdateArray == null) {
                return;
            }
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                if (propertyUpdateArray[i].getAddedObject() instanceof WorkManagerMBean) {
                    workManagerMBean = (WorkManagerMBean)propertyUpdateArray[i].getAddedObject();
                    try {
                        WorkManagerService workManagerService = this.configureWorkManagerService(workManagerMBean);
                        if (workManagerService == null) continue;
                        this.startWorkManagerIfRequired(workManagerService);
                    }
                    catch (DeploymentException deploymentException) {
                        if (!debugWMCollection.isEnabled()) continue;
                        this.debug("Unable to add WorkManagerMBean '" + workManagerMBean.getName() + "' to application '" + this.applicationName + "'");
                    }
                    continue;
                }
                if (!(propertyUpdateArray[i].getRemovedObject() instanceof WorkManagerMBean)) continue;
                workManagerMBean = (WorkManagerMBean)propertyUpdateArray[i].getRemovedObject();
                this.removeWorkManager(workManagerMBean);
            }
        }
    }

    private synchronized void startWorkManagerIfRequired(WorkManagerService workManagerService) {
        if (this.state == 1) {
            workManagerService.start();
        }
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void setState(int n) {
        this.state = n;
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public synchronized void close() {
        SelfTuningMBean selfTuningMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSelfTuning();
        if (selfTuningMBean != null) {
            selfTuningMBean.removeBeanUpdateListener(this);
        }
        for (WorkManagerService workManagerService : this.workManagers.values()) {
            workManagerService.cleanup();
        }
        for (WorkManagerService workManagerService : this.requestClassMap.values()) {
            workManagerService.cleanup();
        }
    }
}

