/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.work.RequestManager;
import weblogic.work.ServerWorkManagerImpl;

public class WorkManagerImageSource
implements ImageSource {
    private static final WorkManagerImageSource THE_ONE = new WorkManagerImageSource();
    final ArrayList workManagers = new ArrayList();

    private WorkManagerImageSource() {
    }

    static WorkManagerImageSource getInstance() {
        return THE_ONE;
    }

    synchronized void register(ServerWorkManagerImpl serverWorkManagerImpl) {
        this.workManagers.add(serverWorkManagerImpl);
    }

    synchronized void deregister(ServerWorkManagerImpl serverWorkManagerImpl) {
        this.workManagers.remove((Object)serverWorkManagerImpl);
    }

    public synchronized void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        RequestManager requestManager = RequestManager.getInstance();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("Total thread count  : " + requestManager.getExecuteThreadCount());
        printWriter.println("Idle thread count   : " + requestManager.getIdleThreadCount());
        printWriter.println("Standby thread count: " + requestManager.getStandbyCount());
        printWriter.println("Queue depth         : " + requestManager.getQueueDepth());
        printWriter.println("Queue departures    : " + requestManager.getQueueDepartures());
        printWriter.println("Mean throughput     : " + requestManager.getThroughput());
        printWriter.println("Total requests      : " + requestManager.getTotalRequestsCount());
        for (ServerWorkManagerImpl serverWorkManagerImpl : this.workManagers) {
            serverWorkManagerImpl.dumpInformation(printWriter);
        }
        printWriter.flush();
    }

    public void timeoutImageCreation() {
    }
}

