/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import java.util.ArrayList;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.MaxThreadsConstraintRuntimeMBean;
import weblogic.management.runtime.MinThreadsConstraintRuntimeMBean;
import weblogic.management.runtime.RequestClassRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ThreadPoolRuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.ExecuteThread;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MaxThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.MinThreadsConstraintRuntimeMBeanImpl;
import weblogic.work.OverloadManager;
import weblogic.work.RequestClass;
import weblogic.work.RequestClassRuntimeMBeanImpl;
import weblogic.work.ServerWorkManagerImpl;
import weblogic.work.WorkManager;

public class WorkManagerRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WorkManagerRuntimeMBean {
    private static final HealthState HEALTH_OK = new HealthState(0);
    private final ServerWorkManagerImpl wm;
    private MinThreadsConstraintRuntimeMBean minThreadsConstraintRuntimeMBean;
    private MaxThreadsConstraintRuntimeMBean maxThreadsConstraintRuntimeMBean;
    private RequestClassRuntimeMBean requestClassRuntimeMBean;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int pastStuckThreadCount;
    private long lastTime;

    WorkManagerRuntimeMBeanImpl(ServerWorkManagerImpl serverWorkManagerImpl) throws ManagementException {
        super(serverWorkManagerImpl.getName());
        this.wm = serverWorkManagerImpl;
    }

    private WorkManagerRuntimeMBeanImpl(ServerWorkManagerImpl serverWorkManagerImpl, RuntimeMBean runtimeMBean) throws ManagementException {
        super(serverWorkManagerImpl.getName(), runtimeMBean);
        this.wm = serverWorkManagerImpl;
    }

    public static synchronized WorkManagerRuntimeMBean getWorkManagerRuntime(WorkManager workManager, ApplicationRuntimeMBean applicationRuntimeMBean, RuntimeMBean runtimeMBean) throws ManagementException {
        if (!(workManager instanceof ServerWorkManagerImpl)) {
            return null;
        }
        ServerWorkManagerImpl serverWorkManagerImpl = (ServerWorkManagerImpl)workManager;
        WorkManagerRuntimeMBeanImpl workManagerRuntimeMBeanImpl = new WorkManagerRuntimeMBeanImpl(serverWorkManagerImpl, runtimeMBean);
        workManagerRuntimeMBeanImpl.setRequestClassRuntime(WorkManagerRuntimeMBeanImpl.getRequestClassRuntime(serverWorkManagerImpl.getRequestClass(), applicationRuntimeMBean, workManagerRuntimeMBeanImpl));
        workManagerRuntimeMBeanImpl.setMinThreadsConstraintRuntime(WorkManagerRuntimeMBeanImpl.getMinThreadsConstraintRuntime(serverWorkManagerImpl.getMinThreadsConstraint(), applicationRuntimeMBean, workManagerRuntimeMBeanImpl));
        workManagerRuntimeMBeanImpl.setMaxThreadsConstraintRuntime(WorkManagerRuntimeMBeanImpl.getMaxThreadsConstraintRuntime(serverWorkManagerImpl.getMaxThreadsConstraint(), applicationRuntimeMBean, workManagerRuntimeMBeanImpl));
        return workManagerRuntimeMBeanImpl;
    }

    private static RequestClassRuntimeMBean getRequestClassRuntime(RequestClass requestClass, ApplicationRuntimeMBean applicationRuntimeMBean, WorkManagerRuntimeMBean workManagerRuntimeMBean) throws ManagementException {
        if (requestClass == null) {
            return null;
        }
        RequestClassRuntimeMBean requestClassRuntimeMBean = null;
        requestClassRuntimeMBean = applicationRuntimeMBean.lookupRequestClassRuntime(requestClass.getName());
        if (requestClassRuntimeMBean == null) {
            requestClassRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().lookupRequestClassRuntime(requestClass.getName());
        }
        if (requestClassRuntimeMBean == null) {
            requestClassRuntimeMBean = new RequestClassRuntimeMBeanImpl(requestClass, workManagerRuntimeMBean, true);
        }
        return requestClassRuntimeMBean;
    }

    private static MinThreadsConstraintRuntimeMBean getMinThreadsConstraintRuntime(MinThreadsConstraint minThreadsConstraint, ApplicationRuntimeMBean applicationRuntimeMBean, WorkManagerRuntimeMBean workManagerRuntimeMBean) throws ManagementException {
        if (minThreadsConstraint == null) {
            return null;
        }
        MinThreadsConstraintRuntimeMBean minThreadsConstraintRuntimeMBean = null;
        minThreadsConstraintRuntimeMBean = applicationRuntimeMBean.lookupMinThreadsConstraintRuntime(minThreadsConstraint.getName());
        if (minThreadsConstraintRuntimeMBean == null) {
            minThreadsConstraintRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().lookupMinThreadsConstraintRuntime(minThreadsConstraint.getName());
        }
        if (minThreadsConstraintRuntimeMBean == null) {
            minThreadsConstraintRuntimeMBean = new MinThreadsConstraintRuntimeMBeanImpl(minThreadsConstraint, workManagerRuntimeMBean, true);
        }
        return minThreadsConstraintRuntimeMBean;
    }

    private static MaxThreadsConstraintRuntimeMBean getMaxThreadsConstraintRuntime(MaxThreadsConstraint maxThreadsConstraint, ApplicationRuntimeMBean applicationRuntimeMBean, WorkManagerRuntimeMBean workManagerRuntimeMBean) throws ManagementException {
        if (maxThreadsConstraint == null) {
            return null;
        }
        MaxThreadsConstraintRuntimeMBean maxThreadsConstraintRuntimeMBean = null;
        maxThreadsConstraintRuntimeMBean = applicationRuntimeMBean.lookupMaxThreadsConstraintRuntime(maxThreadsConstraint.getName());
        if (maxThreadsConstraintRuntimeMBean == null) {
            maxThreadsConstraintRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().lookupMaxThreadsConstraintRuntime(maxThreadsConstraint.getName());
        }
        if (maxThreadsConstraintRuntimeMBean == null) {
            maxThreadsConstraintRuntimeMBean = new MaxThreadsConstraintRuntimeMBeanImpl(maxThreadsConstraint, workManagerRuntimeMBean, true);
        }
        return maxThreadsConstraintRuntimeMBean;
    }

    public String getApplicationName() {
        return this.wm.getApplicationName();
    }

    public String getModuleName() {
        return this.wm.getModuleName();
    }

    public int getPendingRequests() {
        int n = (int)(this.wm.getAcceptedCount() - this.wm.getCompletedCount());
        return n > 0 ? n : 0;
    }

    public long getCompletedRequests() {
        return this.wm.getCompletedCount();
    }

    public int getStuckThreadCount() {
        if (this.timeToSync()) {
            ThreadPoolRuntimeMBean threadPoolRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getThreadPoolRuntime();
            weblogic.management.runtime.ExecuteThread[] executeThreadArray = threadPoolRuntimeMBean.getStuckExecuteThreads();
            if (executeThreadArray == null) {
                this.pastStuckThreadCount = 0;
                return 0;
            }
            int n = 0;
            for (int i = 0; i < executeThreadArray.length; ++i) {
                if (!this.claimThread(executeThreadArray[i])) continue;
                ++n;
            }
            this.pastStuckThreadCount = n;
            return n;
        }
        return this.pastStuckThreadCount;
    }

    private synchronized boolean timeToSync() {
        long l = System.currentTimeMillis();
        if (l - this.lastTime > 10000L) {
            this.lastTime = l;
            return true;
        }
        return false;
    }

    private boolean claimThread(weblogic.management.runtime.ExecuteThread executeThread) {
        Thread thread2 = executeThread.getExecuteThread();
        if (thread2 != null && thread2 instanceof ExecuteThread) {
            ExecuteThread executeThread2 = (ExecuteThread)thread2;
            return ((Object)((Object)this.wm)).equals(executeThread2.getWorkManager());
        }
        return WorkManagerRuntimeMBeanImpl.compareNames(executeThread.getWorkManagerName(), this.getName()) && WorkManagerRuntimeMBeanImpl.compareNames(executeThread.getApplicationName(), this.getApplicationName()) && WorkManagerRuntimeMBeanImpl.compareNames(executeThread.getModuleName(), this.getModuleName());
    }

    private static boolean compareNames(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string.equalsIgnoreCase(string2);
    }

    public MinThreadsConstraintRuntimeMBean getMinThreadsConstraintRuntime() {
        return this.minThreadsConstraintRuntimeMBean;
    }

    public MaxThreadsConstraintRuntimeMBean getMaxThreadsConstraintRuntime() {
        return this.maxThreadsConstraintRuntimeMBean;
    }

    public void setMinThreadsConstraintRuntime(MinThreadsConstraintRuntimeMBean minThreadsConstraintRuntimeMBean) {
        this.minThreadsConstraintRuntimeMBean = minThreadsConstraintRuntimeMBean;
    }

    public void setMaxThreadsConstraintRuntime(MaxThreadsConstraintRuntimeMBean maxThreadsConstraintRuntimeMBean) {
        this.maxThreadsConstraintRuntimeMBean = maxThreadsConstraintRuntimeMBean;
    }

    public void setRequestClassRuntime(RequestClassRuntimeMBean requestClassRuntimeMBean) {
        this.requestClassRuntimeMBean = requestClassRuntimeMBean;
    }

    public RequestClassRuntimeMBean getRequestClassRuntime() {
        return this.requestClassRuntimeMBean;
    }

    public HealthState getHealthState() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        if (this.wm.isInternal()) {
            return HEALTH_OK;
        }
        if (this.wm.getOverloadManager() != null && !this.wm.getOverloadManager().canAcceptMore()) {
            n = 4;
            arrayList.add(ServerWorkManagerImpl.getOverloadMessage((OverloadManager)this.wm.getOverloadManager()));
        }
        if (!ServerWorkManagerImpl.SHARED_OVERLOAD_MANAGER.canAcceptMore()) {
            n = 4;
            arrayList.add(ServerWorkManagerImpl.getOverloadMessage((OverloadManager)ServerWorkManagerImpl.SHARED_OVERLOAD_MANAGER));
        }
        if (ServerWorkManagerImpl.LOW_MEMORY_LISTENER.lowMemory()) {
            n = 4;
            arrayList.add(this.wm.getLowMemoryMessage());
        }
        if (this.wm.getStuckThreadManager() != null && this.wm.getStuckThreadManager().getStuckThreadCount() > 0) {
            n = 2;
            arrayList.add(this.wm.getStuckThreadManager().getStuckThreadCount() + " stuck threads detected in WorkManager '" + this.wm.getName() + "'");
        }
        if (arrayList.size() == 0) {
            return new HealthState(n);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return new HealthState(n, stringArray);
    }
}

