/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.security.AccessController;
import weblogic.management.configuration.WorkManagerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.transaction.internal.ClientInitiatedTxShutdownService;
import weblogic.utils.StackTraceUtils;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.OverloadManager;
import weblogic.work.RequestClass;
import weblogic.work.ServerWorkAdapter;
import weblogic.work.ServerWorkManagerFactory;
import weblogic.work.ServerWorkManagerImpl;
import weblogic.work.ShutdownCallback;
import weblogic.work.StuckThreadManager;
import weblogic.work.Work;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerLifecycleImpl;
import weblogic.work.WorkManagerLogger;
import weblogic.work.WorkManagerService;

public final class WorkManagerServiceImpl
extends WorkManagerLifecycleImpl
implements WorkManagerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int PENDING_TX_TIMER_INTERVAL = 2000;
    private WorkManagerService.WorkListener rmiManager;
    private boolean allowRMIWork = false;

    public static WorkManagerService createService(String string, String string2, String string3) {
        return WorkManagerServiceImpl.createService(string, string2, string3, null);
    }

    public static WorkManagerService createService(String string, String string2, String string3, StuckThreadManager stuckThreadManager) {
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getUse81StyleExecuteQueues()) {
            WorkManagerFactory workManagerFactory = WorkManagerFactory.getInstance();
            WorkManager workManager = workManagerFactory.findOrCreate(string, -1, -1);
            return new WorkManagerServiceImpl(workManager);
        }
        WorkManager workManager = ServerWorkManagerFactory.create(string, string2, string3, stuckThreadManager);
        WorkManagerServiceImpl workManagerServiceImpl = new WorkManagerServiceImpl(workManager);
        ((ServerWorkManagerImpl)workManager).setWorkManagerService(workManagerServiceImpl);
        return workManagerServiceImpl;
    }

    public static WorkManagerService createService(String string, String string2, WorkManagerMBean workManagerMBean, StuckThreadManager stuckThreadManager) {
        WorkManagerFactory workManagerFactory = WorkManagerFactory.getInstance();
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getUse81StyleExecuteQueues()) {
            int n = workManagerMBean.getMaxThreadsConstraint() != null ? workManagerMBean.getMaxThreadsConstraint().getCount() : -1;
            int n2 = workManagerMBean.getMinThreadsConstraint() != null ? workManagerMBean.getMinThreadsConstraint().getCount() : -1;
            WorkManager workManager = workManagerFactory.findOrCreate(workManagerMBean.getName(), n, n2);
            return new WorkManagerServiceImpl(workManager);
        }
        ServerWorkManagerImpl serverWorkManagerImpl = (ServerWorkManagerImpl)ServerWorkManagerFactory.create(string, string2, workManagerMBean, stuckThreadManager);
        WorkManagerServiceImpl workManagerServiceImpl = new WorkManagerServiceImpl((WorkManager)serverWorkManagerImpl);
        serverWorkManagerImpl.setWorkManagerService(workManagerServiceImpl);
        return workManagerServiceImpl;
    }

    public static WorkManagerService createService(String string, String string2, String string3, RequestClass requestClass, MaxThreadsConstraint maxThreadsConstraint, MinThreadsConstraint minThreadsConstraint, OverloadManager overloadManager, StuckThreadManager stuckThreadManager) {
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getUse81StyleExecuteQueues()) {
            WorkManagerFactory workManagerFactory = WorkManagerFactory.getInstance();
            WorkManager workManager = workManagerFactory.findOrCreate(string, maxThreadsConstraint != null ? maxThreadsConstraint.getCount() : -1, minThreadsConstraint != null ? minThreadsConstraint.getCount() : -1);
            return new WorkManagerServiceImpl(workManager);
        }
        ServerWorkManagerImpl serverWorkManagerImpl = (ServerWorkManagerImpl)ServerWorkManagerFactory.create(string, string2, string3, requestClass, maxThreadsConstraint, minThreadsConstraint, overloadManager, stuckThreadManager);
        WorkManagerServiceImpl workManagerServiceImpl = new WorkManagerServiceImpl((WorkManager)serverWorkManagerImpl);
        serverWorkManagerImpl.setWorkManagerService(workManagerServiceImpl);
        return workManagerServiceImpl;
    }

    private WorkManagerServiceImpl(WorkManager workManager) {
        super(workManager);
        if (WorkManagerServiceImpl.debugEnabled()) {
            WorkManagerServiceImpl.debug((String)("-- wmservice created - " + this));
        }
    }

    public synchronized void shutdown(ShutdownCallback shutdownCallback) {
        if (this.internal || this.state == 3 || this.state == 2) {
            if (shutdownCallback != null) {
                shutdownCallback.completed();
            }
            return;
        }
        if (WorkManagerServiceImpl.debugEnabled()) {
            WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " shutdown with callback " + shutdownCallback + "\nstack trace:\n" + StackTraceUtils.throwable2StackTrace(null)));
        }
        this.callback = shutdownCallback;
        if (this.waitForPendingTransactions()) {
            if (WorkManagerServiceImpl.debugEnabled()) {
                WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " is waiting for pending txn to complete before shutdown"));
            }
            this.state = 2;
            return;
        }
        if (this.allowRMIWork) {
            return;
        }
        if (WorkManagerServiceImpl.debugEnabled()) {
            WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " has no pending txn. commencing shutdown ..."));
        }
        this.state = 3;
        if (this.workPending()) {
            return;
        }
        if (WorkManagerServiceImpl.debugEnabled()) {
            WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " has no pending work and no pending txn. Invoking callback"));
        }
        if (shutdownCallback != null) {
            shutdownCallback.completed();
        }
        shutdownCallback = null;
    }

    private boolean waitForPendingTransactions() {
        int n = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getStateVal();
        if (n != 2 || ClientInitiatedTxShutdownService.isTxMapEmpty()) {
            return false;
        }
        if (WorkManagerServiceImpl.debugEnabled()) {
            WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " has pending txn and will timeout in " + ClientInitiatedTxShutdownService.getTxTimeoutMillis() + "ms"));
        }
        TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new TxEmptyChecker(ClientInitiatedTxShutdownService.getTxTimeoutMillis(), 2000), 0L, 2000L);
        return true;
    }

    public WorkManager getDelegate() {
        return this.delegate;
    }

    public void cleanup() {
        if (this.delegate instanceof ServerWorkManagerImpl) {
            ((ServerWorkManagerImpl)this.delegate).cleanup();
        }
    }

    String getCancelMessage() {
        return WorkManagerLogger.logCancelBeforeEnqueueLoggable((String)this.getName(), (String)this.getApplicationName()).getMessage();
    }

    public int getQueueDepth() {
        return this.workCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean permitSchedule(Runnable runnable) {
        if (this.internal) {
            return true;
        }
        boolean bl = false;
        WorkManagerServiceImpl workManagerServiceImpl = this;
        synchronized (workManagerServiceImpl) {
            if (this.state == 1 || !(runnable instanceof Work) || this.allowTransactionalWork(runnable)) {
                ++this.workCount;
                bl = true;
            }
        }
        if (this.allowRMIWork) {
            this.rmiManager.preScheduleWork();
            return true;
        }
        if (bl) {
            return true;
        }
        if (WorkManagerServiceImpl.debugEnabled()) {
            WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " is shutdown"));
        }
        if (this.isAdminUser(runnable) || this.isAdminChannelRequest(runnable)) {
            workManagerServiceImpl = this;
            synchronized (workManagerServiceImpl) {
                ++this.workCount;
                return true;
            }
        }
        return false;
    }

    private boolean allowTransactionalWork(Runnable runnable) {
        if (this.state == 2 && runnable instanceof WorkAdapter) {
            boolean bl = ((WorkAdapter)runnable).isTransactional();
            if (WorkManagerServiceImpl.debugEnabled()) {
                WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " is waiting for pending txn and current work has txn:" + bl));
            }
            return bl;
        }
        return false;
    }

    private boolean isAdminChannelRequest(Runnable runnable) {
        if (!(runnable instanceof WorkAdapter)) {
            return false;
        }
        if (((WorkAdapter)runnable).isAdminChannelRequest()) {
            if (WorkManagerServiceImpl.debugEnabled()) {
                WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " is shutdown but accepted work from admin channel"));
            }
            return true;
        }
        return false;
    }

    private boolean isAdminUser(Runnable runnable) {
        if (!(runnable instanceof ServerWorkAdapter)) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = ((ServerWorkAdapter)((Object)runnable)).getAuthenticatedSubject();
        if (authenticatedSubject != null && SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)authenticatedSubject)) {
            if (WorkManagerServiceImpl.debugEnabled()) {
                WorkManagerServiceImpl.debug((String)("-- wmservice - " + this + " is shutdown but accepted work from " + authenticatedSubject));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workStuck() {
        boolean bl;
        if (this.internal) {
            return;
        }
        WorkManagerServiceImpl workManagerServiceImpl = this;
        synchronized (workManagerServiceImpl) {
            ++this.stuckThreadCount;
            if (this.state != 3) {
                return;
            }
            bl = this.workPending();
        }
        if (!bl) {
            this.invokeCallback();
        }
    }

    public void startRMIGracePeriod(WorkManagerService.WorkListener workListener) {
        this.rmiManager = workListener;
        if (workListener != null) {
            this.allowRMIWork = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRMIGracePeriod() {
        boolean bl = false;
        WorkManagerServiceImpl workManagerServiceImpl = this;
        synchronized (workManagerServiceImpl) {
            this.allowRMIWork = false;
            if (this.state != 2) {
                this.state = 3;
            }
            bl = this.workPending();
        }
        if (!bl) {
            this.invokeCallback();
        }
        this.rmiManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransactionCompletion() {
        if (this.callback == null) {
            return;
        }
        boolean bl = false;
        WorkManagerServiceImpl workManagerServiceImpl = this;
        synchronized (workManagerServiceImpl) {
            if (!this.allowRMIWork) {
                this.state = 3;
            }
            bl = this.workPending();
        }
        if (!bl) {
            this.invokeCallback();
        }
    }

    private final class TxEmptyChecker
    implements TimerListener {
        private final int totalExecutionCount;
        private int executionCount;

        TxEmptyChecker(int n, int n2) {
            this.totalExecutionCount = n / n2;
        }

        public void timerExpired(Timer timer) {
            if (ClientInitiatedTxShutdownService.isTxMapEmpty() || this.executionCount >= this.totalExecutionCount) {
                if (WorkManagerLifecycleImpl.debugEnabled()) {
                    WorkManagerLifecycleImpl.debug((String)("-- wmservice - " + this + " timer expired: will no longer wait for pending transactions"));
                }
                WorkManagerServiceImpl.this.notifyTransactionCompletion();
                timer.cancel();
            } else {
                if (WorkManagerLifecycleImpl.debugEnabled()) {
                    WorkManagerLifecycleImpl.debug((String)("-- wmservice - " + this + " timer expired: will wait for pending transactions"));
                }
                ++this.executionCount;
            }
        }
    }
}

