/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work.j2ee;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkRejectedException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;
import weblogic.work.DaemonTaskWorkManager;
import weblogic.work.InheritableThreadContext;
import weblogic.work.ServerWorkAdapter;
import weblogic.work.ShutdownCallback;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.work.commonj.CommonjWorkManagerImpl;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.spi.WorkContextMapInterceptor;

public final class J2EEWorkManager
extends CommonjWorkManagerImpl {
    private DaemonTaskWorkManager daemonTaskWM;
    private static final J2EEWorkManager DEFAULT = new J2EEWorkManager(WorkManagerFactory.getInstance().getDefault());

    private J2EEWorkManager(WorkManager workManager) {
        super(workManager);
    }

    public static commonj.work.WorkManager getDefault() {
        return DEFAULT;
    }

    public static commonj.work.WorkManager getDefault(String string) {
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string);
        if (applicationContextInternal == null) {
            return null;
        }
        return new J2EEWorkManager(applicationContextInternal.getWorkManagerCollection().getDefault());
    }

    public static commonj.work.WorkManager get(String string, String string2, String string3) {
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string);
        return new J2EEWorkManager(applicationContextInternal.getWorkManagerCollection().get(string2, string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItem schedule(Work work, WorkListener workListener) {
        if (work == null) {
            throw new IllegalArgumentException("null work instance");
        }
        WorkStatus workStatus = new WorkStatus(work);
        if (workListener != null) {
            workListener.workAccepted((WorkEvent)((Object)workStatus));
        }
        if (work.isDaemon()) {
            if (this.daemonTaskWM == null) {
                J2EEWorkManager j2EEWorkManager = this;
                synchronized (j2EEWorkManager) {
                    if (this.daemonTaskWM == null) {
                        this.daemonTaskWM = new DaemonTaskWorkManager(this.getDelegate());
                    }
                }
                this.daemonTaskWM.start();
            }
            this.daemonTaskWM.schedule((Runnable)((Object)new WorkWithListener(work, workListener, workStatus, InheritableThreadContext.getContext())));
        } else {
            this.workManager.schedule((Runnable)((Object)new WorkWithListener(work, workListener, workStatus, InheritableThreadContext.getContext())));
        }
        return workStatus;
    }

    public void shutdown(ShutdownCallback shutdownCallback) {
        if (this.daemonTaskWM != null) {
            this.daemonTaskWM.shutdown(shutdownCallback);
        }
    }

    private static final class WorkStatus
    extends CommonjWorkManagerImpl.WorkStatus {
        private static final long VM_DIFFERENTIATOR = LocalServerIdentity.getIdentity().getTransientIdentity().getIdentityAsLong();
        private long serverIdentity = VM_DIFFERENTIATOR;

        private WorkStatus(Work work) {
            super(work);
        }

        public String toString() {
            return "[" + VM_DIFFERENTIATOR + "][" + this.counter + "] executing: " + this.work;
        }

        public int hashCode() {
            return (int)(this.counter ^ VM_DIFFERENTIATOR);
        }

        public int compareTo(Object object) {
            try {
                return this.compare((WorkStatus)((Object)object));
            }
            catch (ClassCastException classCastException) {
                return -1;
            }
        }

        public int compare(WorkStatus workStatus) {
            if (this.counter > workStatus.counter) {
                return 1;
            }
            if (this.counter < workStatus.counter) {
                return -1;
            }
            if (this.serverIdentity > workStatus.serverIdentity) {
                return 1;
            }
            if (this.serverIdentity < workStatus.serverIdentity) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WorkStatus)) {
                return false;
            }
            WorkStatus workStatus = (WorkStatus)((Object)object);
            return this.counter == workStatus.counter && this.serverIdentity == workStatus.serverIdentity;
        }
    }

    private static final class WorkWithListener
    extends ServerWorkAdapter {
        private final Work work;
        private final WorkListener listener;
        private final WorkStatus status;
        private final InheritableThreadContext inheritableThreadContext;
        private WorkContextMapInterceptor workAreaContext;

        private WorkWithListener(Work work, WorkListener workListener, WorkStatus workStatus, InheritableThreadContext inheritableThreadContext) {
            this.work = work;
            this.listener = workListener;
            this.status = workStatus;
            this.inheritableThreadContext = inheritableThreadContext;
            this.workAreaContext = WorkContextHelper.getWorkContextHelper().getInterceptor().copyThreadContexts(2);
        }

        protected AuthenticatedSubject getAuthenticatedSubject() {
            AbstractSubject abstractSubject = this.inheritableThreadContext.getSubject();
            if (abstractSubject instanceof AuthenticatedSubject) {
                return (AuthenticatedSubject)abstractSubject;
            }
            return null;
        }

        private boolean isAdminRequest() {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            return authenticatedSubject != null && SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)authenticatedSubject);
        }

        public Runnable overloadAction(final String string) {
            if (this.isAdminRequest()) {
                return null;
            }
            return new Runnable(){

                public void run() {
                    WorkWithListener.this.status.setType(2);
                    WorkWithListener.this.status.setThrowable(new WorkRejectedException(string));
                    try {
                        if (WorkWithListener.this.listener != null) {
                            WorkWithListener.this.listener.workRejected((WorkEvent)((Object)WorkWithListener.this.status));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }

        public Runnable cancel(String string) {
            if (this.status.getStatus() != 1) {
                return null;
            }
            return this.overloadAction(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.inheritableThreadContext != null) {
                    this.inheritableThreadContext.push();
                }
                if (this.workAreaContext != null) {
                    WorkContextHelper.getWorkContextHelper().getInterceptor().restoreThreadContexts(this.workAreaContext);
                }
                this.status.setType(3);
                try {
                    if (this.listener != null) {
                        this.listener.workStarted((WorkEvent)((Object)this.status));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.work.run();
                }
                catch (Throwable throwable) {
                    this.status.setThrowable(throwable);
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.status.setType(4);
                try {
                    if (this.listener != null) {
                        this.listener.workCompleted((WorkEvent)((Object)this.status));
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                if (this.inheritableThreadContext != null) {
                    this.inheritableThreadContext.pop();
                }
                throw throwable;
            }
            this.status.setType(4);
            try {
                if (this.listener != null) {
                    this.listener.workCompleted((WorkEvent)((Object)this.status));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.inheritableThreadContext != null) {
                this.inheritableThreadContext.pop();
            }
        }

        public void release() {
            this.work.release();
        }
    }
}

