/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee;

import java.util.HashMap;

public final class Version {
    public static final String VERSION = "9.0";
    public static final String VERSION_92 = "9.2";
    public static final String VERSION_95 = "9.5";
    public static final String VERSION_100 = "10.0";
    public static final String VERSION_103 = "10.3";
    public static final String VERSION_103_PLUS = "10.3+";
    public static final String VERSION_1036 = "10.3.6";
    public static final String LATEST = "10.3.6";
    private static HashMap<String, Integer> _versionToOrdinalMap = new HashMap();

    public static boolean isLaterThanOrEqualTo(String string, String string2) {
        int n;
        int n2 = _versionToOrdinalMap.get(string);
        return n2 >= (n = _versionToOrdinalMap.get(string2).intValue());
    }

    public static boolean isKnownVersion(String string) {
        return _versionToOrdinalMap.containsKey(string);
    }

    public static void checkForKnownVersion(String string) {
        if (!Version.isKnownVersion(string)) {
            throw new IllegalStateException("Wrong version, expected one of the following: " + Version.getKnownVersionsString() + " actual: " + string);
        }
    }

    public static String getKnownVersionsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : _versionToOrdinalMap.keySet()) {
            stringBuffer.append(string).append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static {
        _versionToOrdinalMap.put(VERSION, 0);
        _versionToOrdinalMap.put(VERSION_92, 1);
        _versionToOrdinalMap.put(VERSION_95, 2);
        _versionToOrdinalMap.put(VERSION_100, 3);
        _versionToOrdinalMap.put(VERSION_103, 4);
        _versionToOrdinalMap.put(VERSION_103_PLUS, 5);
        _versionToOrdinalMap.put("10.3.6", 6);
    }
}

