/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import javax.xml.namespace.QName;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.FaultDetailHeader;
import weblogic.wsee.addressing.FaultToHeader;
import weblogic.wsee.addressing.FromHeader;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.ProblemHeaderQNameHeader;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;

public abstract class AbstractAddressingProvider
implements AddressingProvider {
    protected abstract boolean isWSA09();

    public boolean isAnonymousReferenceURI(String string) {
        return this.getAnonymousNamespaceURI().equals(string);
    }

    public ActionHeader createActionHeader() {
        if (this.isWSA09()) {
            return new ActionHeader(WSAddressingConstants.WSA_HEADER_ACTION);
        }
        return new ActionHeader(WSAddressingConstants.WSA_HEADER_ACTION_10);
    }

    public ActionHeader createActionHeader(String string) {
        if (this.isWSA09()) {
            return new ActionHeader(string, WSAddressingConstants.WSA_HEADER_ACTION);
        }
        return new ActionHeader(string, WSAddressingConstants.WSA_HEADER_ACTION_10);
    }

    public ActionHeader createFaultActionHeader() {
        if (this.isWSA09()) {
            return new ActionHeader(this.getFaultActionUri(), WSAddressingConstants.WSA_HEADER_ACTION);
        }
        return new ActionHeader(this.getFaultActionUri(), WSAddressingConstants.WSA_HEADER_ACTION_10);
    }

    public String getFaultActionUri() {
        return this.getNamespaceURI() + "/fault";
    }

    public EndpointReference createAnonymousEndpointReference() {
        EndpointReference endpointReference = new EndpointReference(this.getAnonymousNamespaceURI());
        endpointReference.setNamespaceURI(this.getNamespaceURI());
        return endpointReference;
    }

    public EndpointReference createEndpointReference() {
        EndpointReference endpointReference = new EndpointReference();
        endpointReference.setNamespaceURI(this.getNamespaceURI());
        return endpointReference;
    }

    public EndpointReference createEndpointReference(String string, String string2) {
        EndpointReference endpointReference = new EndpointReference(string, string2);
        endpointReference.setNamespaceURI(this.getNamespaceURI());
        return endpointReference;
    }

    public EndpointReference createEndpointReference(String string) {
        EndpointReference endpointReference = new EndpointReference(string);
        endpointReference.setNamespaceURI(this.getNamespaceURI());
        return endpointReference;
    }

    public FaultToHeader createFaultToHeader() {
        if (this.isWSA09()) {
            return new FaultToHeader(WSAddressingConstants.WSA_HEADER_FAULT_TO);
        }
        return new FaultToHeader(WSAddressingConstants.WSA_HEADER_FAULT_TO_10);
    }

    public FaultToHeader createFaultToHeader(EndpointReference endpointReference) {
        if (endpointReference != null) {
            endpointReference.setNamespaceURI(this.getNamespaceURI());
        }
        if (this.isWSA09()) {
            return new FaultToHeader(endpointReference, WSAddressingConstants.WSA_HEADER_FAULT_TO);
        }
        return new FaultToHeader(endpointReference, WSAddressingConstants.WSA_HEADER_FAULT_TO_10);
    }

    public FromHeader createFromHeader() {
        if (this.isWSA09()) {
            return new FromHeader(WSAddressingConstants.WSA_HEADER_SOURCE);
        }
        return new FromHeader(WSAddressingConstants.WSA_HEADER_SOURCE_10);
    }

    public FromHeader createFromHeader(EndpointReference endpointReference) {
        if (endpointReference != null) {
            endpointReference.setNamespaceURI(this.getNamespaceURI());
        }
        if (this.isWSA09()) {
            return new FromHeader(endpointReference, WSAddressingConstants.WSA_HEADER_SOURCE);
        }
        return new FromHeader(endpointReference, WSAddressingConstants.WSA_HEADER_SOURCE_10);
    }

    public MessageIdHeader createMessageIdHeader() {
        if (this.isWSA09()) {
            return new MessageIdHeader(WSAddressingConstants.WSA_HEADER_MESSAGE_ID);
        }
        return new MessageIdHeader(WSAddressingConstants.WSA_HEADER_MESSAGE_ID_10);
    }

    public MessageIdHeader createMessageIdHeader(String string) {
        if (this.isWSA09()) {
            return new MessageIdHeader(string, WSAddressingConstants.WSA_HEADER_MESSAGE_ID);
        }
        return new MessageIdHeader(string, WSAddressingConstants.WSA_HEADER_MESSAGE_ID_10);
    }

    public RelatesToHeader createRelatesToHeader() {
        if (this.isWSA09()) {
            return new RelatesToHeader(WSAddressingConstants.WSA_HEADER_RELATES_TO);
        }
        return new RelatesToHeader(WSAddressingConstants.WSA_HEADER_RELATES_TO_10);
    }

    public RelatesToHeader createRelatesToHeader(String string, QName qName) {
        if (this.isWSA09()) {
            return new RelatesToHeader(string, qName, WSAddressingConstants.WSA_HEADER_RELATES_TO);
        }
        return new RelatesToHeader(string, qName, WSAddressingConstants.WSA_HEADER_RELATES_TO_10);
    }

    public ReplyToHeader createReplyToHeader() {
        if (this.isWSA09()) {
            return new ReplyToHeader(WSAddressingConstants.WSA_HEADER_REPLY_TO);
        }
        return new ReplyToHeader(WSAddressingConstants.WSA_HEADER_REPLY_TO_10);
    }

    public ReplyToHeader createReplyToHeader(EndpointReference endpointReference) {
        if (endpointReference != null) {
            endpointReference.setNamespaceURI(this.getNamespaceURI());
        }
        if (this.isWSA09()) {
            return new ReplyToHeader(endpointReference, WSAddressingConstants.WSA_HEADER_REPLY_TO);
        }
        return new ReplyToHeader(endpointReference, WSAddressingConstants.WSA_HEADER_REPLY_TO_10);
    }

    public ToHeader createToHeader() {
        if (this.isWSA09()) {
            return new ToHeader(WSAddressingConstants.WSA_HEADER_TO);
        }
        return new ToHeader(WSAddressingConstants.WSA_HEADER_TO_10);
    }

    public ToHeader createToHeader(String string) {
        if (this.isWSA09()) {
            return new ToHeader(string, WSAddressingConstants.WSA_HEADER_TO);
        }
        return new ToHeader(string, WSAddressingConstants.WSA_HEADER_TO_10);
    }

    public FaultDetailHeader createFaultDetailHeader() {
        if (this.isWSA09()) {
            return new FaultDetailHeader(WSAddressingConstants.WSA_HEADER_FAULT_DETAIL);
        }
        return new FaultDetailHeader(WSAddressingConstants.WSA_HEADER_FAULT_DETAIL_10);
    }

    public ProblemHeaderQNameHeader createProblemHeaderQNameHeader() {
        if (this.isWSA09()) {
            return new ProblemHeaderQNameHeader(WSAddressingConstants.WSA_HEADER_PROBLEM_HEADER_QNAME);
        }
        return new ProblemHeaderQNameHeader(WSAddressingConstants.WSA_HEADER_PROBLEM_HEADER_QNAME_10);
    }

    public ProblemHeaderQNameHeader createProblemHeaderQNameHeader(String string) {
        if (this.isWSA09()) {
            return new ProblemHeaderQNameHeader(WSAddressingConstants.WSA_HEADER_PROBLEM_HEADER_QNAME, string);
        }
        return new ProblemHeaderQNameHeader(WSAddressingConstants.WSA_HEADER_PROBLEM_HEADER_QNAME_10, string);
    }

    public QName getMessageAddressingHeaderRequiredFaultQName() {
        if (this.isWSA09()) {
            return WSAddressingConstants.WSA_MESSAGE_HEADER_REQUIRED_FC;
        }
        return WSAddressingConstants.WSA_MESSAGE_HEADER_REQUIRED_FC_10;
    }

    public QName getInvalidAddressingHeaderFaultQName() {
        if (this.isWSA09()) {
            return WSAddressingConstants.WSA_INVALID_MESSAGE_HEADER_FC;
        }
        return WSAddressingConstants.WSA_INVALID_ADDRESSING_HEADER_FC;
    }

    public QName getActionNotSupportFaultQName() {
        if (this.isWSA09()) {
            return WSAddressingConstants.WSA_ACTION_NOT_SUPPORTED_FC;
        }
        return WSAddressingConstants.WSA_ACTION_NOT_SUPPORTED_FC_10;
    }

    public String getMessageAddressingHeaderRequiredReason() {
        if (this.isWSA09()) {
            return "A required message information header, To, MessageID, or Action, is not present.";
        }
        return "A required header representing a Message Addressing Property is not present.";
    }
}

