/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.policy.api.UsingAddressingPolicyInfo;
import weblogic.wsee.addressing.policy.api.UsingAddressingPolicyInfoFactory;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.UnknownMsgHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;

public class AddressingHandler
extends GenericHandler {
    private final boolean verbose = Verbose.isVerbose(AddressingHandler.class);
    public static final String OUTPUT_HEADERS = "weblogic.wsee.addressing.OutputHeaders";
    public static final String INPUT_HEADERS = "weblogic.wsee.addressing.InputHeaders";
    public static final String CALLBACK_TO = "weblogic.wsee.addressing.CallbackTo";
    public static final String REPLY_TO = "weblogic.wsee.addressing.ReplyTo";
    public static final String FROM = "weblogic.wsee.addressing.From";
    public static final String FAULT_TO = "weblogic.wsee.addressing.FaultTo";
    public static final String TO = "weblogic.wsee.addressing.To";
    public static final String MESSAGE_ID = "weblogic.wsee.addressing.MessageId";
    public static final String RELATES_TO = "weblogic.wsee.addressing.RelatesTo";
    public static final String ACTION = "weblogic.wsee.addressing.Action";

    public QName[] getHeaders() {
        return WSAddressingConstants.WSA_HEADERS;
    }

    protected void handleInbound(WlMessageContext wlMessageContext) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Iterator iterator = wlMessageContext.getHeaders().listHeaders();
        while (iterator.hasNext()) {
            MsgHeader msgHeader = (MsgHeader)iterator.next();
            if (!(msgHeader instanceof UnknownMsgHeader)) continue;
            arrayList.add(((UnknownMsgHeader)msgHeader).getElement());
        }
    }

    protected void handleOutbound(WlMessageContext wlMessageContext) {
        List list = (List)wlMessageContext.getProperty(OUTPUT_HEADERS);
        if (list != null) {
            for (Element element : list) {
                wlMessageContext.getHeaders().addHeader(new UnknownMsgHeader(element));
            }
        }
    }

    protected String getActionURI(WlMessageContext wlMessageContext, boolean bl) {
        String string = (String)wlMessageContext.getProperty(ACTION);
        if (string == null) {
            string = AddressingHelper.getAddressingWSDLActionURI(wlMessageContext, bl);
        }
        if (string == null) {
            string = this.getSOAPActionFromWSDLBinding(wlMessageContext);
        }
        if (string == null || string.length() == 0) {
            WsdlDefinitions wsdlDefinitions = wlMessageContext.getDispatcher().getWsdlPort().getService().getDefinitions();
            String string2 = wsdlDefinitions.getTargetNamespace();
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (!string2.endsWith("/")) {
                stringBuffer.append("/");
            }
            String string3 = wlMessageContext.getDispatcher().getWsdlPort().getPortType().getName().getLocalPart();
            stringBuffer.append(string3);
            stringBuffer.append("/");
            stringBuffer.append(this.getMessageName(wlMessageContext.getDispatcher().getOperation(), bl));
            string = stringBuffer.toString();
        }
        if (this.verbose) {
            Verbose.log("ActionURI " + string);
        }
        return string;
    }

    protected String getSOAPActionFromWSDLBinding(WlMessageContext wlMessageContext) {
        if (wlMessageContext.getDispatcher() == null) {
            return null;
        }
        WsdlBindingOperation wsdlBindingOperation = wlMessageContext.getDispatcher().getBindingOperation();
        if (wsdlBindingOperation == null) {
            return null;
        }
        if (!AsyncUtil.isSoap12(wlMessageContext)) {
            SoapBindingOperation soapBindingOperation = SoapBindingOperation.narrow(wsdlBindingOperation);
            return soapBindingOperation.getSoapAction();
        }
        Soap12BindingOperation soap12BindingOperation = Soap12BindingOperation.narrow(wsdlBindingOperation);
        return soap12BindingOperation.getSoapAction();
    }

    protected void setSoapActionHeader(WlMessageContext wlMessageContext, String string) {
        if (!AsyncUtil.isSoap12(wlMessageContext)) {
            ((SOAPMessageContext)wlMessageContext).getMessage().getMimeHeaders().setHeader("SOAPAction", string);
            return;
        }
        String[] stringArray = ((SOAPMessageContext)wlMessageContext).getMessage().getMimeHeaders().getHeader("Content-Type");
        if (stringArray != null && stringArray.length == 1) {
            String string2 = stringArray[0];
            int n = string2.indexOf("action=");
            int n2 = 7;
            if (n > 0) {
                String string3 = string2.substring(0, n + n2) + string;
                int n3 = string2.indexOf(";", n);
                if (n3 >= 0) {
                    string3 = string3 + string2.substring(n3);
                }
                ((SOAPMessageContext)wlMessageContext).getMessage().getMimeHeaders().setHeader("Content-Type", string3);
            }
        }
    }

    private String getMessageName(WsdlOperation wsdlOperation, boolean bl) {
        if (bl) {
            return wsdlOperation.getInputName();
        }
        return wsdlOperation.getOutputName();
    }

    protected UsingAddressingPolicyInfo getAddressingPolicyInfo(MessageContext messageContext) {
        UsingAddressingPolicyInfo usingAddressingPolicyInfo;
        block2: {
            usingAddressingPolicyInfo = null;
            try {
                usingAddressingPolicyInfo = UsingAddressingPolicyInfoFactory.getInstance().getAddressigPolicyInfo(messageContext);
            }
            catch (PolicyException policyException) {
                Verbose.log("Warning: Got exception when read UsingAddressing assertion from policy, exception is: " + policyException);
                if (!this.verbose) break block2;
                Verbose.logException(policyException);
            }
        }
        return usingAddressingPolicyInfo;
    }
}

