/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHeaderException;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProvider10Impl;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.AddressingProviderSubmissionImpl;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;

public final class AddressingHelper {
    public static WSAVersion getWSAVersion(MessageContext messageContext) {
        Object object;
        if (messageContext == null) {
            throw new AssertionError((Object)"MessageContext should not be null!");
        }
        if (messageContext.containsProperty("weblogic.wsee.addressing.version") && (object = messageContext.getProperty("weblogic.wsee.addressing.version")) instanceof WSAVersion) {
            return (WSAVersion)((Object)object);
        }
        return WSAVersion.WSA10;
    }

    public static WSAVersion getWSAVersion(Map map) {
        Object v;
        if (map == null) {
            throw new AssertionError((Object)"Map parameter should not be null!");
        }
        if (map.containsKey("weblogic.wsee.addressing.version") && (v = map.get("weblogic.wsee.addressing.version")) instanceof WSAVersion) {
            return (WSAVersion)((Object)v);
        }
        return WSAVersion.WSA10;
    }

    public static WSAVersion getWSAVersion(String string) {
        if ("http://www.w3.org/2005/08/addressing".equals(string)) {
            return WSAVersion.WSA10;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string)) {
            return WSAVersion.MemberSubmission;
        }
        throw new IllegalArgumentException(string + " is a wrong WS-Addressing namespace!");
    }

    public static boolean isAnonymousEndpointReference(MessageContext messageContext, EndpointReference endpointReference) {
        if (messageContext == null) {
            throw new AssertionError((Object)"MessageContext should not be null!");
        }
        if (endpointReference == null) {
            return false;
        }
        String string = endpointReference.getAddress();
        if (AddressingHelper.getWSAVersion(messageContext).equals((Object)WSAVersion.MemberSubmission)) {
            return "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(string);
        }
        return "http://www.w3.org/2005/08/addressing/anonymous".equals(string);
    }

    public static boolean isAnonymousReferenceURI(String string) {
        return "http://www.w3.org/2005/08/addressing/anonymous".equals(string) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(string);
    }

    public static boolean isWSA10NamespaceURI(String string) {
        return "http://www.w3.org/2005/08/addressing".equals(string);
    }

    public static EndpointReference createWSA10AnonymousEndpointReference() {
        return AddressingProvider10Impl.getProviderInstance().createAnonymousEndpointReference();
    }

    public static EndpointReference createMemberSubmissionAnonymousEndpointReference() {
        return AddressingProviderSubmissionImpl.getProviderInstance().createAnonymousEndpointReference();
    }

    public static AddressingProvider getAddressingProvider(MessageContext messageContext) {
        return AddressingProviderFactory.getInstance().getAddressingProvider(messageContext);
    }

    public static void validateAction(WlMessageContext wlMessageContext, boolean bl) {
        String string = AddressingHelper.getAddressingWSDLActionURI(wlMessageContext, bl);
        if (string == null) {
            return;
        }
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        ActionHeader actionHeader = (ActionHeader)msgHeaders.getHeader(ActionHeader.TYPE);
        if (actionHeader == null) {
            return;
        }
        String string2 = actionHeader.getActionURI();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (string.equals(string2)) {
            return;
        }
        wlMessageContext.setProperty("weblogic.wsee.addressing.server.hasexception", "true");
        String string3 = " Action Header in SOAP message is \"" + string2 + "\", but Action defined in WSDL is \"" + string + "\".";
        throw new AddressingHeaderException("The action is not supported in this endpoint, or it is mismatched with the action defined in WSDL." + string3, "Action", AddressingHelper.getAddressingProvider(wlMessageContext).getActionNotSupportFaultQName());
    }

    public static void checkFaultAction(WlMessageContext wlMessageContext) {
        ActionHeader actionHeader = (ActionHeader)wlMessageContext.getHeaders().getHeader(ActionHeader.TYPE);
        if (actionHeader == null) {
            return;
        }
        if (AddressingHelper.getAddressingProvider(wlMessageContext).getFaultActionUri().equals(actionHeader.getActionURI()) || "http://www.w3.org/2005/08/addressing/soap/fault".equals(actionHeader.getActionURI())) {
            throw SOAPFaultUtil.newWLSOAPFaultException((MessageContext)wlMessageContext, "Client", "Sender", "Client has sent a WS-Addressing fault message, it couldn't been processed by server side! (Fault action: " + actionHeader.getActionURI() + ")", null, null, new QName[0]);
        }
    }

    public static String getAddressingWSDLActionURI(WlMessageContext wlMessageContext, boolean bl) {
        if (wlMessageContext.getDispatcher().getOperation() == null) {
            return null;
        }
        String string = null;
        string = bl ? wlMessageContext.getDispatcher().getOperation().getInputAction() : wlMessageContext.getDispatcher().getOperation().getOutputAction();
        return string;
    }
}

