/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProvider10Impl;
import weblogic.wsee.addressing.AddressingProviderSubmissionImpl;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;

public final class AddressingProviderFactory {
    private static final AddressingProviderFactory instance = new AddressingProviderFactory();

    private AddressingProviderFactory() {
    }

    public static AddressingProviderFactory getInstance() {
        return instance;
    }

    public AddressingProvider getAddressingProvider(MessageContext messageContext) {
        if (messageContext == null) {
            throw new AssertionError((Object)"MessageContext should not be null!");
        }
        if (AddressingHelper.getWSAVersion(messageContext).equals((Object)WSAVersion.MemberSubmission)) {
            return AddressingProviderSubmissionImpl.getProviderInstance();
        }
        return AddressingProvider10Impl.getProviderInstance();
    }

    public AddressingProvider getAddressingProvider(Map map) {
        if (AddressingHelper.getWSAVersion(map).equals((Object)WSAVersion.MemberSubmission)) {
            return AddressingProviderSubmissionImpl.getProviderInstance();
        }
        return AddressingProvider10Impl.getProviderInstance();
    }
}

