/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import java.io.Serializable;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHandler;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.CallbackToHeader;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.SetCookieHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.addressing.policy.api.UsingAddressingPolicyInfo;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.HeaderUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapAddress;

public class ClientAddressingHandler
extends AddressingHandler {
    private static final boolean verbose = Verbose.isVerbose(ClientAddressingHandler.class);
    public static final String COOKIES = "weblogic.wsee.addressing.Cookie";
    public static final String TARGET_REFERENCE = "weblogic.wsee.addressing.Target";
    public static final String RELATED_MESSAGE_ID = "weblogic.wsee.addressing.RelatedMessageId";
    public static final String HAS_WSA_EXCEPTION = "weblogic.wsee.addressing.client.hasexception";
    public static final String ACCEPT_EXTERNAL_SETTING_ONLY = "weblogic.wsee.addressing.client.AcceptExternalSettingOnly";
    private static boolean acceptExternalSettingOnly = false;

    public boolean handleRequest(MessageContext messageContext) {
        Serializable serializable;
        EndpointReference endpointReference;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        String string = (String)messageContext.getProperty("weblogic.wsee.complex");
        boolean bl = this.detectUsingAddressingPolicy(messageContext);
        if (string == null && !bl || Boolean.FALSE.toString().equalsIgnoreCase(string)) {
            return true;
        }
        if (WsrmConstants.RMVersion.RM_10 == messageContext.getProperty("weblogic.wsee.wsrm.RMVersion") && messageContext.getProperty("weblogic.wsee.addressing.version") == null && !bl) {
            messageContext.setProperty("weblogic.wsee.addressing.version", (Object)WSAVersion.MemberSubmission);
        }
        if (verbose) {
            Verbose.log("Adding addressing headers");
        }
        acceptExternalSettingOnly = messageContext.containsProperty(ACCEPT_EXTERNAL_SETTING_ONLY);
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        String string2 = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.MessageId");
        if (acceptExternalSettingOnly) {
            if (string2 != null) {
                this.addHeaderNoDups(wlMessageContext, addressingProvider.createMessageIdHeader(string2));
            }
        } else {
            if (string2 == null) {
                string2 = Guid.generateGuid();
            }
            this.addHeaderNoDups(wlMessageContext, addressingProvider.createMessageIdHeader(string2));
        }
        String string3 = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.Action");
        if (acceptExternalSettingOnly) {
            if (string3 != null) {
                this.addHeaderNoDups(wlMessageContext, addressingProvider.createActionHeader(string3));
            }
        } else {
            if (string3 == null) {
                string3 = this.getActionURI(wlMessageContext, true);
            }
            if (string3 != null) {
                object4 = AddressingUtil.wrapSOAPAction(string3);
                this.setSoapActionHeader(wlMessageContext, (String)object4);
            }
            this.addHeaderNoDups(wlMessageContext, addressingProvider.createActionHeader(string3));
        }
        if ((object4 = (EndpointReference)messageContext.getProperty(TARGET_REFERENCE)) != null) {
            messageContext.setProperty("javax.xml.rpc.service.endpoint.address", (Object)((EndpointReference)object4).getAddress());
            object3 = ((EndpointReference)object4).getReferenceProperties().listHeaders();
            while (object3.hasNext()) {
                this.addHeaderNoDups(wlMessageContext, (MsgHeader)object3.next());
            }
            object3 = ((EndpointReference)object4).getReferenceParameters().listHeaders();
            while (object3.hasNext()) {
                object2 = (MsgHeader)object3.next();
                ((MsgHeader)object2).setRefParam(true);
                this.addHeaderNoDups(wlMessageContext, (MsgHeader)object2);
            }
        }
        object3 = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.To");
        if (acceptExternalSettingOnly) {
            if (object3 != null) {
                this.addHeaderNoDups(wlMessageContext, addressingProvider.createToHeader((String)object3));
            }
        } else {
            if (object3 == null) {
                object3 = this.getTargetAddress(wlMessageContext);
                assert (object3 != null);
            }
            this.addHeaderNoDups(wlMessageContext, addressingProvider.createToHeader((String)object3));
        }
        if ((object2 = (MsgHeaders)messageContext.getProperty(COOKIES)) != null) {
            object = object2.listHeaders();
            while (object.hasNext()) {
                this.addHeaderNoDups(wlMessageContext, (MsgHeader)object.next());
            }
        }
        if ((object = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.ReplyTo")) != null) {
            this.addHeaderNoDups(wlMessageContext, addressingProvider.createReplyToHeader((EndpointReference)object));
        } else {
            this.addHeaderNoDups(wlMessageContext, addressingProvider.createReplyToHeader(addressingProvider.createAnonymousEndpointReference()));
        }
        EndpointReference endpointReference2 = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.FaultTo");
        if (endpointReference2 != null) {
            this.addHeaderNoDups(wlMessageContext, addressingProvider.createFaultToHeader(endpointReference2));
        }
        if ((endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.From")) != null && !StringUtil.isEmpty(endpointReference.getAddress())) {
            serializable = addressingProvider.createFromHeader(endpointReference);
            this.addHeaderNoDups(wlMessageContext, (MsgHeader)serializable);
        }
        if ((serializable = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.CallbackTo")) != null) {
            this.addHeaderNoDups(wlMessageContext, new CallbackToHeader((EndpointReference)serializable));
        }
        return true;
    }

    private void addHeaderNoDups(WlMessageContext wlMessageContext, MsgHeader msgHeader) {
        if (wlMessageContext.getHeaders().getHeader(msgHeader.getType()) != null) {
            SoapMsgHeaders soapMsgHeaders = (SoapMsgHeaders)wlMessageContext.getHeaders();
            soapMsgHeaders.replaceHeader(msgHeader);
        } else {
            wlMessageContext.getHeaders().addHeader(msgHeader);
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        ConversationPhase conversationPhase;
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        Map map = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
        if (verbose) {
            Verbose.log("Looking for WS-Addressing headers");
        }
        assert (map != null);
        SetCookieHeader setCookieHeader = (SetCookieHeader)wlMessageContext.getHeaders().getHeader(SetCookieHeader.TYPE);
        if (setCookieHeader != null) {
            map.put(COOKIES, setCookieHeader.getCookies());
            if (verbose) {
                Verbose.log("Received cookies from server");
            }
        }
        if ((conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase")) == ConversationPhase.START) {
            this.handleConversationReplyTo(wlMessageContext, map);
        }
        this.discardAddressingHeaders(wlMessageContext, sOAPMessageContext);
        return true;
    }

    private void handleConversationReplyTo(WlMessageContext wlMessageContext, Map map) {
        ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
        if (replyToHeader != null) {
            EndpointReference endpointReference = (EndpointReference)wlMessageContext.getProperty(TARGET_REFERENCE);
            EndpointReference endpointReference2 = replyToHeader.getReference();
            if (endpointReference != null) {
                if (!endpointReference.getAddress().equals(endpointReference2.getAddress())) {
                    throw new JAXRPCException("The address in the new conversational EPR does not match the existing address, new: " + endpointReference2.getAddress() + " old: " + endpointReference.getAddress());
                }
                ((FreeStandingMsgHeaders)endpointReference.getReferenceProperties()).merge((FreeStandingMsgHeaders)endpointReference2.getReferenceProperties());
                ((FreeStandingMsgHeaders)endpointReference.getReferenceParameters()).merge((FreeStandingMsgHeaders)endpointReference2.getReferenceParameters());
                map.put(TARGET_REFERENCE, endpointReference);
            } else {
                map.put(TARGET_REFERENCE, endpointReference2);
            }
            ContinueHeader continueHeader = (ContinueHeader)endpointReference2.getReferenceParameters().getHeader(ContinueHeader.TYPE);
            if (continueHeader == null) {
                continueHeader = (ContinueHeader)endpointReference2.getReferenceProperties().getHeader(ContinueHeader.TYPE);
            }
            if (continueHeader != null) {
                String string = continueHeader.getConversationId();
                map.put("weblogic.wsee.conversation.ConversationId", string);
            }
        }
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    private String getTargetAddress(WlMessageContext wlMessageContext) {
        String string = (String)wlMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        if (string == null) {
            SoapAddress soapAddress = WsdlUtils.getSoapAddress(wlMessageContext.getDispatcher().getWsdlPort());
            assert (soapAddress != null);
            string = soapAddress.getLocation();
        }
        return string;
    }

    private void discardAddressingHeaders(WlMessageContext wlMessageContext, SOAPMessageContext sOAPMessageContext) {
        ActionHeader actionHeader;
        RelatesToHeader relatesToHeader;
        ToHeader toHeader;
        if (verbose) {
            Verbose.here();
        }
        if ((toHeader = (ToHeader)wlMessageContext.getHeaders().getHeader(ToHeader.TYPE)) != null) {
            if (verbose) {
                Verbose.log("Removing ToHeader mustUnderstand");
            }
            HeaderUtil.removeMustUnderstandFromHeader(toHeader, sOAPMessageContext.getMessage());
        }
        if ((relatesToHeader = (RelatesToHeader)wlMessageContext.getHeaders().getHeader(RelatesToHeader.TYPE)) != null) {
            if (verbose) {
                Verbose.log("Removing RelatesToHeader mustUnderstand");
            }
            HeaderUtil.removeMustUnderstandFromHeader(relatesToHeader, sOAPMessageContext.getMessage());
        }
        if ((actionHeader = (ActionHeader)wlMessageContext.getHeaders().getHeader(ActionHeader.TYPE)) != null) {
            if (verbose) {
                Verbose.log("Removing ActionHeader mustUnderstand");
            }
            HeaderUtil.removeMustUnderstandFromHeader(actionHeader, sOAPMessageContext.getMessage());
        }
    }

    private boolean detectUsingAddressingPolicy(MessageContext messageContext) {
        UsingAddressingPolicyInfo usingAddressingPolicyInfo = this.getAddressingPolicyInfo(messageContext);
        if (usingAddressingPolicyInfo == null) {
            return false;
        }
        if (usingAddressingPolicyInfo.getUsingAddressingWSAVersionInfo() != null) {
            if (messageContext.getProperty("weblogic.wsee.addressing.version") == null) {
                messageContext.setProperty("weblogic.wsee.addressing.version", (Object)usingAddressingPolicyInfo.getUsingAddressingWSAVersionInfo().getWSAVersion());
            }
            return true;
        }
        return false;
    }
}

